/*
 * Decompiled with CFR 0.152.
 */
package com.adyen;

import com.adyen.enums.Environment;
import com.adyen.util.CertificateUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class Config {
    protected String username;
    protected String password;
    protected String merchantAccount;
    protected Environment environment;
    protected String endpoint;
    protected String marketPayEndpoint;
    protected String balancePlatformEndpoint;
    protected String applicationName;
    protected String apiKey;
    protected int connectionTimeoutMillis;
    protected int readTimeoutMillis;
    protected String hppEndpoint;
    protected String skinCode;
    protected String hmacKey;
    protected String checkoutEndpoint;
    protected String terminalApiCloudEndpoint;
    protected String terminalApiLocalEndpoint;
    protected Certificate terminalCertificate;
    protected String posTerminalManagementApiEndpoint;
    protected String dataProtectionEndpoint;
    protected KeyStore trustKeyStore;
    protected KeyStore clientKeyStore;
    protected String clientKeyStorePassword;
    protected String legalEntityManagementEndpoint;
    protected String managementEndpoint;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getMarketPayEndpoint() {
        return this.marketPayEndpoint;
    }

    public void setMarketPayEndpoint(String marketPayEndpoint) {
        this.marketPayEndpoint = marketPayEndpoint;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getHppEndpoint() {
        return this.hppEndpoint;
    }

    public void setHppEndpoint(String hppEndpoint) {
        this.hppEndpoint = hppEndpoint;
    }

    public String getSkinCode() {
        return this.skinCode;
    }

    public void setSkinCode(String skinCode) {
        this.skinCode = skinCode;
    }

    public String getHmacKey() {
        return this.hmacKey;
    }

    public void setHmacKey(String hmacKey) {
        this.hmacKey = hmacKey;
    }

    public String getCheckoutEndpoint() {
        if (this.checkoutEndpoint == null || this.checkoutEndpoint.isEmpty()) {
            String message = "Please provide your unique live url prefix on the setEnvironment() call on the Client or provide checkoutEndpoint in your config object.";
            throw new IllegalArgumentException(message);
        }
        return this.checkoutEndpoint;
    }

    public void setCheckoutEndpoint(String checkoutEndpoint) {
        this.checkoutEndpoint = checkoutEndpoint;
    }

    public String getTerminalApiCloudEndpoint() {
        return this.terminalApiCloudEndpoint;
    }

    public void setTerminalApiCloudEndpoint(String terminalApiCloudEndpoint) {
        this.terminalApiCloudEndpoint = terminalApiCloudEndpoint;
    }

    public String getTerminalApiLocalEndpoint() {
        return this.terminalApiLocalEndpoint;
    }

    public void setTerminalApiLocalEndpoint(String terminalApiLocalEndpoint) {
        this.terminalApiLocalEndpoint = terminalApiLocalEndpoint;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public String getPosTerminalManagementApiEndpoint() {
        return this.posTerminalManagementApiEndpoint;
    }

    public void setPosTerminalManagementApiEndpoint(String posTerminalManagementApiEndpoint) {
        this.posTerminalManagementApiEndpoint = posTerminalManagementApiEndpoint;
    }

    public Certificate getTerminalCertificate() {
        return this.terminalCertificate;
    }

    public void setTerminalCertificate(Certificate terminalCertificate) {
        this.terminalCertificate = terminalCertificate;
    }

    public void setTerminalCertificate(String terminalCertificatePath) throws FileNotFoundException, CertificateException {
        this.terminalCertificate = CertificateUtil.loadCertificate(terminalCertificatePath);
    }

    public void setTerminalCertificate(InputStream terminalCertificateStream) throws CertificateException {
        this.terminalCertificate = CertificateUtil.loadCertificate(terminalCertificateStream);
    }

    public String getDataProtectionEndpoint() {
        return this.dataProtectionEndpoint;
    }

    public void setDataProtectionEndpoint(String dataProtectionEndpoint) {
        this.dataProtectionEndpoint = dataProtectionEndpoint;
    }

    public KeyStore getTrustKeyStore() {
        return this.trustKeyStore;
    }

    public void setTrustKeyStore(KeyStore trustKeyStore) {
        this.trustKeyStore = trustKeyStore;
    }

    public void setTrustKeyStore(String trustKeyStorePath, String keyStoreType, String password) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.trustKeyStore = CertificateUtil.loadKeyStore(trustKeyStorePath, keyStoreType, password);
    }

    public KeyStore getClientKeyStore() {
        return this.clientKeyStore;
    }

    public void setClientKeyStore(KeyStore clientKeyStore) {
        this.clientKeyStore = clientKeyStore;
    }

    public void setClientKeyStore(String clientKeyStorePath, String keyStoreType, String clientKeyStorePassword) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        this.clientKeyStorePassword = clientKeyStorePassword;
        this.clientKeyStore = CertificateUtil.loadKeyStore(clientKeyStorePath, keyStoreType, clientKeyStorePassword);
    }

    public String getClientKeyStorePassword() {
        return this.clientKeyStorePassword;
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    public String getBalancePlatformEndpoint() {
        return this.balancePlatformEndpoint;
    }

    public void setBalancePlatformEndpoint(String balancePlatformEndpoint) {
        this.balancePlatformEndpoint = balancePlatformEndpoint;
    }

    public String getLegalManagementEndpoint() {
        return this.legalEntityManagementEndpoint;
    }

    public void setLegalEntityManagementEndpoint(String legalEntityManagementEndpoint) {
        this.legalEntityManagementEndpoint = legalEntityManagementEndpoint;
    }

    public String getManagementEndpoint() {
        return this.managementEndpoint;
    }

    public void setManagementEndpoint(String managementEndpoint) {
        this.managementEndpoint = managementEndpoint;
    }
}

