/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout.details;

import com.adyen.model.checkout.PaymentMethodDetails;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class GooglePayDetails
implements PaymentMethodDetails {
    public static final String GOOGLEPAY = "googlepay";
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="googlePayToken")
    private String googlePayToken = null;
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference = null;
    @SerializedName(value="storedPaymentMethodId")
    private final String storedPaymentMethodId;
    @SerializedName(value="type")
    private String type = "googlepay";

    public GooglePayDetails() {
        this.storedPaymentMethodId = null;
    }

    public GooglePayDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public GooglePayDetails googlePayToken(String googlePayToken) {
        this.googlePayToken = googlePayToken;
        return this;
    }

    public String getGooglePayToken() {
        return this.googlePayToken;
    }

    public void setGooglePayToken(String googlePayToken) {
        this.googlePayToken = googlePayToken;
    }

    public GooglePayDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Schema(description="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public GooglePayDetails type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GooglePayDetails googlePayDetails = (GooglePayDetails)o;
        return Objects.equals((Object)this.fundingSource, (Object)googlePayDetails.fundingSource) && Objects.equals(this.googlePayToken, googlePayDetails.googlePayToken) && Objects.equals(this.recurringDetailReference, googlePayDetails.recurringDetailReference) && Objects.equals(this.storedPaymentMethodId, googlePayDetails.storedPaymentMethodId) && Objects.equals(this.type, googlePayDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fundingSource, this.googlePayToken, this.recurringDetailReference, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GooglePayDetails {\n");
        sb.append("    fundingSource: ").append(Util.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    googlePayToken: ").append(Util.toIndentedString(this.googlePayToken)).append("\n");
        sb.append("    recurringDetailReference: ").append(Util.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(Util.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(Util.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit");

        @JsonValue
        private final String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String text) {
            return Arrays.stream(FundingSourceEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

