/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.ThreeDSRequestData;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class AuthenticationData {
    @SerializedName(value="attemptAuthentication")
    private AttemptAuthenticationEnum attemptAuthentication = null;
    @SerializedName(value="authenticationOnly")
    private Boolean authenticationOnly = false;
    @SerializedName(value="threeDSRequestData")
    private ThreeDSRequestData threeDSRequestData = null;

    public AuthenticationData attemptAuthentication(AttemptAuthenticationEnum attemptAuthentication) {
        this.attemptAuthentication = attemptAuthentication;
        return this;
    }

    @Schema(description="Indicates when 3D Secure authentication should be attempted. This overrides all other rules, including [Dynamic 3D Secure settings](https://docs.adyen.com/risk-management/dynamic-3d-secure).  Possible values:  * **always**: Perform 3D Secure authentication. * **never**: Don't perform 3D Secure authentication. If PSD2 SCA or other national regulations require authentication, the transaction gets declined. * **preferNo**: Do not perform 3D Secure authentication if not required by PSD2 SCA or other national regulations.")
    public AttemptAuthenticationEnum getAttemptAuthentication() {
        return this.attemptAuthentication;
    }

    public void setAttemptAuthentication(AttemptAuthenticationEnum attemptAuthentication) {
        this.attemptAuthentication = attemptAuthentication;
    }

    public AuthenticationData authenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
        return this;
    }

    @Schema(description="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation. Default: *false**.")
    public Boolean isAuthenticationOnly() {
        return this.authenticationOnly;
    }

    public void setAuthenticationOnly(Boolean authenticationOnly) {
        this.authenticationOnly = authenticationOnly;
    }

    public AuthenticationData threeDSRequestData(ThreeDSRequestData threeDSRequestData) {
        this.threeDSRequestData = threeDSRequestData;
        return this;
    }

    @Schema(description="")
    public ThreeDSRequestData getThreeDSRequestData() {
        return this.threeDSRequestData;
    }

    public void setThreeDSRequestData(ThreeDSRequestData threeDSRequestData) {
        this.threeDSRequestData = threeDSRequestData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationData authenticationData = (AuthenticationData)o;
        return Objects.equals((Object)this.attemptAuthentication, (Object)authenticationData.attemptAuthentication) && Objects.equals(this.authenticationOnly, authenticationData.authenticationOnly) && Objects.equals(this.threeDSRequestData, authenticationData.threeDSRequestData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attemptAuthentication, this.authenticationOnly, this.threeDSRequestData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationData {\n");
        sb.append("    attemptAuthentication: ").append(this.toIndentedString((Object)this.attemptAuthentication)).append("\n");
        sb.append("    authenticationOnly: ").append(this.toIndentedString(this.authenticationOnly)).append("\n");
        sb.append("    threeDSRequestData: ").append(this.toIndentedString(this.threeDSRequestData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AttemptAuthenticationEnum {
        ALWAYS("always"),
        NEVER("never"),
        PREFERNO("preferNo");

        @JsonValue
        private final String value;

        private AttemptAuthenticationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AttemptAuthenticationEnum fromValue(String input) {
            for (AttemptAuthenticationEnum b : AttemptAuthenticationEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AttemptAuthenticationEnum> {
            public void write(JsonWriter jsonWriter, AttemptAuthenticationEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public AttemptAuthenticationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AttemptAuthenticationEnum.fromValue(value);
            }
        }
    }
}

