/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.Util;

import com.adyen.Util.Util;
import java.nio.charset.Charset;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.SortedMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class HMACValidator {
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final Charset C_UTF8 = Charset.forName("UTF8");

    public String calculateHMAC(String data, String key) throws SignatureException {
        try {
            byte[] rawKey = Hex.decodeHex((char[])key.toCharArray());
            SecretKeySpec signingKey = new SecretKeySpec(rawKey, HMAC_SHA256_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(C_UTF8));
            return new String(Base64.encodeBase64((byte[])rawHmac));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    public String getDataToSign(SortedMap<String, String> postParameters) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String key : postParameters.keySet()) {
            parts.add(HMACValidator.escapeVal(key));
        }
        for (String value : postParameters.values()) {
            parts.add(HMACValidator.escapeVal(value));
        }
        return Util.implode(":", parts);
    }

    private static String escapeVal(String val) {
        if (val == null) {
            return "";
        }
        return val.replace("\\", "\\\\").replace(":", "\\:");
    }
}

