/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.model.modification.AbstractModificationRequest;
import com.adyen.model.modification.CancelOrRefundRequest;
import com.adyen.model.modification.CancelRequest;
import com.adyen.model.modification.CaptureRequest;
import com.adyen.model.modification.ModificationResult;
import com.adyen.model.modification.RefundRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.modification.Cancel;
import com.adyen.service.resource.modification.CancelOrRefund;
import com.adyen.service.resource.modification.Capture;
import com.adyen.service.resource.modification.Refund;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public class Modification
extends Service {
    private CancelOrRefund cancelOrRefund;
    private Cancel cancel;
    private Capture capture = new Capture(this);
    private Refund refund;

    public Modification(Client client) {
        super(client);
        this.cancelOrRefund = new CancelOrRefund(this);
        this.cancel = new Cancel(this);
        this.refund = new Refund(this);
    }

    public ModificationResult capture(CaptureRequest captureRequest) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(captureRequest);
        String jsonResult = this.capture.request(jsonRequest);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult cancelOrRefund(CancelOrRefundRequest cancelOrRefundRequest) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(cancelOrRefundRequest);
        String jsonResult = this.cancelOrRefund.request(jsonRequest);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult refund(RefundRequest refundRequest) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(refundRequest);
        String jsonResult = this.refund.request(jsonRequest);
        return this.deserializeResponse(jsonResult);
    }

    public ModificationResult cancel(CancelRequest cancelRequest) throws IOException, ApiException {
        String jsonRequest = this.serializeRequest(cancelRequest);
        String jsonResult = this.cancel.request(jsonRequest);
        return this.deserializeResponse(jsonResult);
    }

    private String serializeRequest(AbstractModificationRequest modificationRequest) {
        String jsonRequest = GSON.toJson((Object)modificationRequest);
        return jsonRequest;
    }

    private ModificationResult deserializeResponse(String jsonResult) {
        ModificationResult modificationResult = (ModificationResult)GSON.fromJson(jsonResult, new TypeToken<ModificationResult>(){}.getType());
        return modificationResult;
    }
}

