/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import com.adyen.Config;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.codec.binary.Base64;

public class HttpURLConnectionClient
implements ClientInterface {
    private HttpURLConnection httpConnection;
    private static final String CHARSET = "UTF-8";
    private static final Gson GSON = new Gson();
    private static final Gson COMPLEX_MAP_KEY_GSON = new GsonBuilder().enableComplexMapKeySerialization().create();

    @Override
    public String request(String requestUrl, String requestBody, Config config) throws IOException, HTTPClientException {
        String response = this.createRequest(requestUrl, config.getApplicationName()).setBasicAuthentication(config.getUsername(), config.getPassword()).setContentType("application/json").doPostRequest(requestBody);
        return response;
    }

    private static String getResponseBody(InputStream responseStream) throws IOException {
        Scanner scanner = new Scanner(responseStream, CHARSET);
        scanner.useDelimiter("\\A");
        String rBody = scanner.useDelimiter("\\A").next();
        scanner.close();
        responseStream.close();
        return rBody;
    }

    @Override
    public String post(String requestUrl, Map<String, String> params, Config config) throws IOException, HTTPClientException {
        String postQuery = this.getQuery(params);
        String response = this.createRequest(requestUrl, config.getApplicationName()).doPostRequest(postQuery);
        return response;
    }

    private String getQuery(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> pair : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(pair.getKey(), CHARSET));
            result.append("=");
            result.append(URLEncoder.encode(pair.getValue(), CHARSET));
        }
        return result.toString();
    }

    private HttpURLConnectionClient createRequest(String requestUrl, String applicationName) throws IOException {
        URL targetUrl = new URL(requestUrl);
        this.httpConnection = (HttpURLConnection)targetUrl.openConnection();
        this.httpConnection.setUseCaches(false);
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setRequestMethod("POST");
        this.httpConnection.setRequestProperty("Accept-Charset", CHARSET);
        this.httpConnection.setRequestProperty("User-Agent", String.format("%s %s%s", applicationName, "adyen-java-api-library/", "1.1.0"));
        return this;
    }

    private HttpURLConnectionClient setBasicAuthentication(String username, String password) {
        String authString = username + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])authString.getBytes());
        String authStringEnc = new String(authEncBytes);
        this.httpConnection.setRequestProperty("Authorization", "Basic " + authStringEnc);
        return this;
    }

    private HttpURLConnectionClient setContentType(String contentType) {
        this.httpConnection.setRequestProperty("Content-Type", contentType);
        return this;
    }

    private String doPostRequest(String requestBody) throws IOException, HTTPClientException {
        String response = null;
        OutputStream outputStream = this.httpConnection.getOutputStream();
        outputStream.write(requestBody.getBytes());
        outputStream.flush();
        int responseCode = this.httpConnection.getResponseCode();
        if (responseCode != 200) {
            if (this.httpConnection.getErrorStream() != null) {
                response = HttpURLConnectionClient.getResponseBody(this.httpConnection.getErrorStream());
            }
            HTTPClientException httpClientException = new HTTPClientException(responseCode, "HTTP Exception", this.httpConnection.getHeaderFields(), response);
            throw httpClientException;
        }
        response = HttpURLConnectionClient.getResponseBody(this.httpConnection.getInputStream());
        this.httpConnection.disconnect();
        return response;
    }
}

