/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.os.Bundle;
import com.adpdigital.push.PushMessage;
import java.util.Map;

public class ChabokNotification {
    private String id;
    private String title;
    private String text;
    private PushMessage message;
    private Bundle extras;
    private int badge;
    private String sound;
    private boolean alert = true;
    private String topicName;
    private String trackId;

    public ChabokNotification(String string, String string2, String string3, int n) {
        this.id = string;
        this.title = string2;
        this.badge = n;
        this.text = string3;
    }

    public ChabokNotification(String string, String string2, String string3, int n, Map<String, String> map) {
        this.id = string;
        this.title = string2;
        this.badge = n;
        this.text = string3;
        if (map != null) {
            this.sound = map.get("sound");
        }
        this.extras = this.mapToBundle(map);
    }

    public ChabokNotification(String string, String string2, String string3, int n, Bundle bundle) {
        this.id = string;
        this.title = string2;
        this.badge = n;
        this.text = string3;
        if (bundle != null) {
            this.sound = bundle.getString("sound");
        }
        this.extras = bundle;
    }

    public ChabokNotification(PushMessage pushMessage, int n) {
        this.message = pushMessage;
        this.id = pushMessage.getId();
        this.title = pushMessage.getAlertTitle();
        if (this.title == null) {
            this.title = pushMessage.getAlertText();
        }
        this.text = pushMessage.getBody();
        if (pushMessage.getAlertText() != null && !pushMessage.getAlertText().trim().equalsIgnoreCase("")) {
            this.text = pushMessage.getAlertText();
        }
        this.badge = n;
        if (pushMessage.getSound() != null) {
            this.sound = pushMessage.getSound();
        }
    }

    private Bundle mapToBundle(Map<String, String> object) {
        Bundle bundle;
        if (object == null) {
            return null;
        }
        ChabokNotification chabokNotification = bundle;
        bundle = new Bundle();
        for (Map.Entry entry : object.entrySet()) {
            if (entry.getValue() == null) continue;
            chabokNotification.putString((String)entry.getKey(), (String)entry.getValue());
        }
        return chabokNotification;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int getBadge() {
        return this.badge;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage getMessage() {
        return this.message;
    }

    public Bundle getExtras() {
        return this.extras;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String string) {
        this.sound = string;
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setAlert(boolean bl) {
        this.alert = bl;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String string) {
        this.topicName = string;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String string) {
        this.trackId = string;
    }
}

