/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import NZV.NZV.OJW;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.adpdigital.push.AppListener;
import com.adpdigital.push.AppState;
import com.adpdigital.push.BadgeUpdate;
import com.adpdigital.push.Callback;
import com.adpdigital.push.ChabokCommunicateEvent;
import com.adpdigital.push.ChabokCommunicateStatus;
import com.adpdigital.push.ChabokEvent;
import com.adpdigital.push.ChabokFirebaseMessaging;
import com.adpdigital.push.ChabokMessage;
import com.adpdigital.push.ChabokNotification;
import com.adpdigital.push.ChabokNotificationAction;
import com.adpdigital.push.ConnectionStatus;
import com.adpdigital.push.DYH;
import com.adpdigital.push.Datetime;
import com.adpdigital.push.DeferredData;
import com.adpdigital.push.DeferredDataListener;
import com.adpdigital.push.DeviceToken;
import com.adpdigital.push.ForegroundManager;
import com.adpdigital.push.GcmMessage;
import com.adpdigital.push.HUI;
import com.adpdigital.push.IRK;
import com.adpdigital.push.IZX;
import com.adpdigital.push.LogLevel;
import com.adpdigital.push.MRR;
import com.adpdigital.push.NotificationHandler;
import com.adpdigital.push.OnDeeplinkResponseListener;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.RPN;
import com.adpdigital.push.VLN;
import com.adpdigital.push.VMB;
import com.adpdigital.push.XTU;
import com.adpdigital.push.YCE;
import com.adpdigital.push.config.Environment;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.leolin.shortcutbadger.ShortcutBadger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdpPushClient {
    public static final String TAG = "com.adpdigital.push.AdpPushClient";
    public static final String SDK_VERSION = "3.7.2";
    public static final String PUSH_DELIVERY_RECEIVED_INTENT = "com.adpdigital.push.client.DLVRECEIVE";
    public static final String PUSH_MSG_RECEIVED_INTENT = "com.adpdigital.push.client.MSGRECEIVE";
    public static final String PUSH_MSG_RECEIVED_TOPIC = "com.adpdigital.push.client.MSGRECVD_TOPIC";
    public static final String PUSH_MSG_RECEIVED_MSG = "com.adpdigital.push.client.MSGRECVD_MSGBODY";
    public static final String USE_BADGE_COUNT = "com.adpdigital.push.client.BadgeCount";
    public static final String ADVERTISING_ID_ENABLED = "com.adpdigital.push.client.ADVERTISING_ID_ENABLED";
    public static final String FB_DEFAULT_NOTIFICATION_ICON = "com.google.firebase.messaging.default_notification_icon";
    public static final String CHABOK_DEFAULT_NOTIFICATION_ICON = "com.adpdigital.push.client.default_notification_icon";
    public static final String FB_DEFAULT_NOTIFICATION_COLOR = "com.google.firebase.messaging.default_notification_color";
    public static final String CHABOK_DEFAULT_NOTIFICATION_COLOR = "com.adpdigital.push.client.default_notification_color";
    public static final String SHOW_ONLY_CHABOK_NOTIFICATIONS = "com.adpdigital.push.client.SHOW_ONLY_CHABOK_NOTIFICATIONS";
    public static final String DISABLE_REALTIME = "com.adpdigital.push.client.DISABLE_REALTIME";
    public static final int PUSH_NOTIFICATION_UPDATE = 2;
    public static final String APPLICATION_LAUNCH = "AppLaunched";
    public static final String APPLICATION_LAUNCH_TS = "AppLaunchTs";
    public static final String ACTIVITY_KEY = "MainActivityClassName";
    public static final String PURCHASE_EVENT_NAME = "purchase";
    private static final int TOTAL_RETRIES = 10;
    private static final ScheduledExecutorService worker = Executors.newSingleThreadScheduledExecutor();
    public static String packageName;
    private static boolean FORCE_STICKY;
    private static int installationRetries;
    private static int tokenRetries;
    private static Collection<String> notifs;
    private static AdpPushClient pushClientInstance;
    private static boolean disableSdk;
    private static Environment chabokEnvironment;
    private static Context context;
    private static Class activityClass;
    private static Application.ActivityLifecycleCallbacks lifecycleCallbacks;
    private static final ScheduledExecutorService tokenWorker;
    private static String defaultTracker;
    private static final String GUEST_TAG = "CHABOK_GUEST";
    private static final String META_DATA = "__meta";
    private Set<NotificationHandler> handlers = new HashSet<NotificationHandler>();
    private boolean restartServiceState = false;
    private boolean isFreshStart = false;
    private boolean registeredOnce = false;
    private boolean registering = false;
    private boolean isNewInstall = false;
    private long lastLaunchTime;
    private long installDate;
    private boolean isLaunched = false;
    private MRR.NZV.NZV.OJW eventBus = MRR.NZV.NZV.OJW.MRR();
    private WeakReference<Activity> currentActivity;
    private ChabokNotificationAction lastNotificationAction;
    private ChabokNotification lastNotificationData;
    private OnDeeplinkResponseListener onDeeplinkResponseListener;
    private DeferredDataListener deferredDataListener;
    private com.adpdigital.push.config.NZV config;
    private String userHash;
    private boolean _isLoggedInNow = false;
    private final Object _installationLock = new Object();
    private final Object _tokenLock = new Object();
    private com.adpdigital.push.WFM userId;
    private String appId;
    private String apiKey;
    private HashMap<String, Object> userInfo = new HashMap();
    private String[] channels = new String[]{"default"};
    private JSONObject notificationSettings;
    private ForegroundManager foreground;
    private boolean useSecure = true;
    private boolean useDev = true;
    private int notificationIcon = -1;
    private int notificationIconSilhouette = -1;
    private YCE communicateFallbackMachine = YCE.MRR();
    private Callback<String> registerCallback;

    public static void setLogLevel(LogLevel logLevel) {
        IRK.NZV = logLevel;
    }

    public static void setApplicationContext(Context context) {
        IRK.MRR(TAG, "setApplicationContext is called with context = " + context);
        AdpPushClient.context = context.getApplicationContext() == null ? context : context.getApplicationContext();
        if (AdpPushClient.context instanceof Application) {
            AdpPushClient.registerOnActivityLifeCycle((Application)context);
        }
        activityClass = AdpPushClient.getActivityClass(AdpPushClient.context);
    }

    private static void registerOnActivityLifeCycle(Application application) {
        block3: {
            if (lifecycleCallbacks != null) break block3;
            try {
                lifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                    public void onActivityCreated(Activity activity, Bundle bundle) {
                    }

                    public void onActivityStarted(Activity activity) {
                    }

                    public void onActivityResumed(Activity activity) {
                        AdpPushClient.access$002(AdpPushClient.get(), new WeakReference<Activity>(activity));
                    }

                    public void onActivityPaused(Activity activity) {
                    }

                    public void onActivityStopped(Activity activity) {
                    }

                    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                    }

                    public void onActivityDestroyed(Activity activity) {
                    }
                };
                application.registerActivityLifecycleCallbacks(lifecycleCallbacks);
            }
            catch (Exception exception) {
                IRK.NZV(TAG, "can not register activity life cycle listener", exception);
            }
        }
    }

    static Class getActivityClass(Context context) {
        try {
            return Class.forName(context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()).getComponent().getClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IRK.XTU(TAG, "Could not find main activity class. Please before calling Chabok init method call AdpPushClient.setActivityClass(MainActivity.getClass())");
            return null;
        }
    }

    private AdpPushClient(String string, String string2, String string3, String string4) {
        IRK.HUI(TAG, "Creating a new AdpPushClient instance");
        try {
            Class.forName("android.os.AsyncTask");
        }
        catch (Throwable throwable) {}
        AdpPushClient adpPushClient = this;
        this.isFreshStart = true;
        adpPushClient.validateAndPopulate(string, string2, string3, string4);
        adpPushClient.eventBus.OJW(this);
        if (!adpPushClient.checkPlayServices()) {
            DYH.NZV(this.getApplicationContext(), true);
            IRK.XTU(TAG, "No valid Google Play Services found.");
        } else {
            DYH.NZV(this.getApplicationContext(), false);
        }
        if (this.shouldBeSticky() && this.hasProtectedAppSupport()) {
            this.eventBus.MRR((Object)AppState.PROTECTED_GRANT_NEEDED);
        }
        AdpPushClient adpPushClient2 = this;
        this.foreground = ForegroundManager.get(adpPushClient2.getApplicationContext());
        this.foreground.addListener(new AppListener(){

            @Override
            public void onBecameForeground(Class clazz) {
                if (AdpPushClient.this.isFreshStart) {
                    VIN vIN = this;
                    IRK.HUI(TAG, "Application Launch");
                    vIN.AdpPushClient.this.updateLaunchStats();
                    vIN.AdpPushClient.this.eventBus.MRR((Object)AppState.LAUNCH);
                    if (vIN.AdpPushClient.this.isNewInstall) {
                        AdpPushClient.this.eventBus.MRR((Object)AppState.INSTALL);
                    }
                    VIN vIN2 = this;
                    vIN2.AdpPushClient.this.doRegister();
                    AdpPushClient.access$102(vIN2.AdpPushClient.this, false);
                }
                if (AdpPushClient.this.isAutoResetBadge()) {
                    AdpPushClient.this.resetBadge();
                }
                VIN vIN = this;
                PushService.NZV(vIN.AdpPushClient.this.getApplicationContext(), "START");
                if (!vIN.AdpPushClient.this.shouldBeSticky()) {
                    AdpPushClient.this.resetBackgroundTimer();
                }
                AdpPushClient.this.eventBus.MRR((Object)AppState.FOREGROUND);
            }

            @Override
            public void onBecameBackground() {
                if (!AdpPushClient.this.shouldBeSticky()) {
                    AdpPushClient.this.startBackgroundTimer();
                }
                AdpPushClient.this.eventBus.MRR((Object)AppState.BACKGROUND);
            }
        });
        adpPushClient2.initializeAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static AdpPushClient init(Context object, Class clazz, String string, String string2, String string3, String string4) {
        if (pushClientInstance != null) return pushClientInstance;
        Class<AdpPushClient> clazz2 = AdpPushClient.class;
        synchronized (AdpPushClient.class) {
            void var5_6;
            void var4_5;
            void var3_4;
            void var2_3;
            if (pushClientInstance != null) return pushClientInstance;
            packageName = context.getPackageName();
            pushClientInstance = new AdpPushClient((String)var2_3, (String)var3_4, (String)var4_5, (String)var5_6);
            MRR.NZV.NZV.OJW.MRR().MRR((Object)AppState.INITIALIZED);
            // ** MonitorExit[var0_1] (shouldn't be in output)
            return pushClientInstance;
        }
    }

    private static AdpPushClient init(String string, String string2, String string3, String string4) {
        return AdpPushClient.init(context, activityClass, string, string2, string3, string4);
    }

    public static void setDisableSdk(boolean bl) {
        disableSdk = bl;
        if (disableSdk) {
            IRK.XTU(TAG, "Chabok has been disabled.");
        }
    }

    public static boolean isDisabledSdk() {
        if (disableSdk) {
            IRK.XTU(TAG, "Chabok has been disabled by calling setDisableSdk(boolean) method.");
            return true;
        }
        return false;
    }

    public static synchronized AdpPushClient get() {
        AdpPushClient adpPushClient = pushClientInstance;
        if (adpPushClient != null) {
            return adpPushClient;
        }
        throw new IllegalStateException("AdpPushClient not initialized, Make sure to call AdpPushClient.configureEnvironment(Environment) in onCreate() method of your Application class. Please see http://bit.ly/32x1Tsn");
    }

    public static Context getContext() {
        return context;
    }

    static boolean hasNotified(String string) {
        return notifs.contains(string);
    }

    private void initializeAdapter() {
        AdpPushClient adpPushClient = this;
        String string = "https://" + "push.adpdigital.com" + ":80" + "/api/";
        String string2 = "push.adpdigital.com";
        String string3 = ":1880";
        adpPushClient.useDev = adpPushClient.getSharedPreferences().getBoolean("useDev", true);
        if (adpPushClient.useSecure) {
            string = "";
            if (!(this.appId.equalsIgnoreCase("chabok-demo") || this.appId.equalsIgnoreCase("adp-nms-push") || this.appId.equalsIgnoreCase("chabok-demo"))) {
                string = this.appId.split("-demo")[0] + ".";
            }
            string2 = "https://" + string + "push.adpdigital.com" + ":443" + "/api/";
            string = string + "push.adpdigital.com";
            string3 = ":4443";
        } else {
            String string4 = string;
            string = string2;
            string2 = string4;
        }
        if (this.useDev) {
            string = "https://sandbox.push.adpdigital.com:80/api/";
            string2 = "sandbox.push.adpdigital.com";
            string3 = ":1880";
        } else {
            String string5 = string2;
            string2 = string;
            string = string5;
        }
        if (this.useDev && this.useSecure) {
            if (chabokEnvironment == null) {
                string = "https://dev.push.adpdigital.com:443/api/";
                string2 = "dev.push.adpdigital.com";
            } else {
                string = "https://sandbox.push.adpdigital.com:443/api/";
                string2 = "sandbox.push.adpdigital.com";
            }
            string3 = ":4443";
        }
        this.getSharedPreferences().edit().putString("host", string2).putString("port", string3).putBoolean("useSecure", this.useSecure).apply();
        NZV.NZV.YCE.OJW().MRR(string);
        NZV.NZV.YCE.OJW().NZV(this.apiKey);
    }

    private void validateAndPopulate(String object, String string, String stringArray, String string2) {
        if (context != null) {
            if (stringArray != null) {
                DYH.NZV(this.getApplicationContext(), com.adpdigital.push.WFM.NZV((String)stringArray), "757365726e616d65");
                if (string2 != null) {
                    DYH.NZV(this.getApplicationContext(), com.adpdigital.push.WFM.NZV(string2), "70617373776f7264");
                    if (object != null) {
                        long l;
                        HashSet<String> hashSet;
                        stringArray = ((String)object).split("/");
                        if (stringArray.length > 1) {
                            object = stringArray[0];
                            if (stringArray.length == 2) {
                                IRK.HUI(IRK.MRR, "SenderId is removed from Chabok SDK v3.0.0. Remove it from appId.");
                            }
                        }
                        AdpPushClient adpPushClient = this;
                        this.apiKey = string;
                        adpPushClient.appId = object;
                        DYH.NZV(adpPushClient.getApplicationContext(), com.adpdigital.push.WFM.NZV(this.appId), "6170706c69636174696f6e4964");
                        object = hashSet;
                        hashSet = new HashSet<String>(Arrays.asList(this.channels));
                        Set set = DYH.VMB(adpPushClient.getApplicationContext()).getStringSet("topics", (Set)object);
                        adpPushClient.channels = set.toArray(new String[set.size()]);
                        object = adpPushClient.getSharedPreferences().getString("notificationSettings", null);
                        if (object != null) {
                            try {
                                this.notificationSettings = new JSONObject((String)object);
                            }
                            catch (JSONException jSONException) {
                                IRK.NZV(TAG, jSONException.getMessage(), jSONException);
                            }
                        }
                        if ((object = this.getSharedPreferences().getStringSet("notifs", null)) != null) {
                            notifs.addAll((Collection<String>)object);
                        }
                        AdpPushClient adpPushClient2 = this;
                        adpPushClient2.isNewInstall = adpPushClient2.getSharedPreferences().getBoolean("chabokInstallation", false) ^ true;
                        this.installDate = l = adpPushClient2.getSharedPreferences().getLong("installDate", -1L);
                        if (l == -1L) {
                            l = System.currentTimeMillis();
                            this.getSharedPreferences().edit().putLong("installDate", l).apply();
                            this.installDate = l;
                        }
                        return;
                    }
                    throw new IllegalArgumentException("Pleas provide your application ID");
                }
                throw new IllegalArgumentException("Please provide your password");
            }
            throw new IllegalArgumentException("Please provide your username");
        }
        throw new IllegalArgumentException("No Context passed, Please call AdpPushClient.setApplicationContext(getApplicationContext()) method before Chabok init method.");
    }

    private void resetBackgroundTimer() {
        AlarmManager alarmManager = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        if (alarmManager == null) {
            return;
        }
        alarmManager.cancel(this.getBackgroundIntent());
    }

    private void startBackgroundTimer() {
        AlarmManager alarmManager = (AlarmManager)adpPushClient.getApplicationContext().getSystemService("alarm");
        if (alarmManager == null) {
            return;
        }
        long l = 170000L;
        AdpPushClient adpPushClient = adpPushClient.getBackgroundIntent();
        if (Build.VERSION.SDK_INT < 19) {
            long l2 = SystemClock.elapsedRealtime() + l;
            alarmManager.set(2, l2, (PendingIntent)adpPushClient);
        } else {
            long l3 = SystemClock.elapsedRealtime() + l;
            alarmManager.setExact(2, l3, (PendingIntent)adpPushClient);
        }
    }

    private PendingIntent getBackgroundIntent() {
        Intent intent;
        Intent intent2 = intent;
        intent2();
        intent.setClass(this.getApplicationContext(), PushService.class);
        intent.setAction("BackgroundTimeExceeded");
        if (Build.VERSION.SDK_INT >= 31) {
            return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)intent2, (int)0x4000000);
        }
        return PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)intent2, (int)0);
    }

    private void emit(com.adpdigital.push.QHG qHG, String string, String string2, JSONObject jSONObject, boolean bl, boolean bl2) {
        com.adpdigital.push.WFM wFM = null;
        if (jSONObject != null) {
            wFM = com.adpdigital.push.WFM.NZV(jSONObject.toString());
            IRK.MRR(TAG, "emit: data: " + wFM + " , subject: " + string2);
        }
        com.adpdigital.push.CVA.NZV(this.getApplicationContext()).NZV(qHG, string, string2, wFM, bl, bl2);
    }

    private void isReceivedMessage(String string, Callback callback) {
        com.adpdigital.push.CVA.NZV(this.getApplicationContext());
        callback.onSuccess(com.adpdigital.push.CVA.VMB(string));
    }

    private boolean isEnabledAlertForNotSupportingGcm() {
        return this.getSharedPreferences().getBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", true);
    }

    private String convertChannelName2OldConvention(String string) {
        if (string.startsWith("private/")) {
            String string2 = string;
            return string2.substring(string2.indexOf("/") + 1);
        }
        if (string.startsWith("public/")) {
            return string;
        }
        return "public/" + string;
    }

    private AdpPushClient register(String string) {
        return this.register(string, new String[0], null);
    }

    private AdpPushClient register(String string, Callback<String> callback) {
        return this.register(string, new String[0], callback);
    }

    private AdpPushClient register(String string, String[] stringArray, Callback<String> callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        if (string != null && !string.trim().equals("") && !string.trim().equals("null")) {
            if (!this.isValid(string)) {
                IRK.OJW(TAG, "User ID is not valid: " + string);
                if (callback != null) {
                    callback.onFailure(new IllegalArgumentException("User ID is not valid: " + string));
                }
                return pushClientInstance;
            }
            String string2 = this.getGuestUserId();
            if (string2 != null && !string.contentEquals(string2)) {
                this._isLoggedInNow = true;
                this.setGuestUserId(null);
            }
            return this._register(string, stringArray, callback);
        }
        IRK.OJW(TAG, "Please provide a user ID to register with ADP server: " + string);
        if (callback != null) {
            callback.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + string));
        }
        return pushClientInstance;
    }

    private AdpPushClient registerAsGuest() {
        return this._registerAsGuest(null, null);
    }

    private AdpPushClient registerAsGuest(Callback<String> callback) {
        return this._registerAsGuest(null, callback);
    }

    private AdpPushClient registerAsGuest(String string) {
        return this._registerAsGuest(string, null);
    }

    private AdpPushClient registerAsGuest(String string, Callback<String> callback) {
        return this._registerAsGuest(string, callback);
    }

    private AdpPushClient _registerAsGuest(String string, Callback<String> callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        String string2 = this.getGuestUserId();
        if (string != null && string2 == null || string != null && !string.contentEquals(string2)) {
            this.setGuestUserId(string);
            string2 = string;
        }
        if (string2 == null) {
            string2 = UUID.randomUUID().toString().replace("-", "");
            this.setGuestUserId(string2);
        }
        AdpPushClient adpPushClient = this;
        adpPushClient._isLoggedInNow = false;
        adpPushClient.userHash = "";
        return this._register(string2, new String[0], callback);
    }

    private AdpPushClient reRegister(String string) {
        return this.reRegister(string, new String[0]);
    }

    private AdpPushClient reRegister(String string, String[] stringArray) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        AdpPushClient adpPushClient = this;
        AdpPushClient adpPushClient2 = this;
        DYH.NZV(adpPushClient2.getApplicationContext(), this.userId, "72657265676973746572656446726f6d");
        adpPushClient2.unregister(true);
        adpPushClient._register(string, stringArray, adpPushClient2.registerCallback);
        return adpPushClient;
    }

    private AdpPushClient _register(String object, String[] stringArray, Callback<String> object2) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        if (object != null && !((String)object).trim().equals("") && !((String)object).trim().equals("null")) {
            ArrayList arrayList;
            HashSet<String> hashSet;
            if (!this.isValid((String)object)) {
                IRK.OJW(TAG, "User ID is not valid: " + (String)object);
                if (object2 != null) {
                    object2.onFailure(new IllegalArgumentException("User ID is not valid: " + (String)object));
                }
                return pushClientInstance;
            }
            if (this.registering) {
                AdpPushClient adpPushClient = this;
                IRK.XTU(TAG, "Already in registering...");
                adpPushClient.eventBus.OJW(new Object((String)object, stringArray, (Callback)object2){
                    final /* synthetic */ String NZV;
                    final /* synthetic */ String[] MRR;
                    final /* synthetic */ Callback OJW;
                    {
                        this.NZV = string;
                        this.MRR = stringArray;
                        this.OJW = callback;
                    }

                    public void onEvent(AppState stringArray) {
                        if (stringArray == AppState.REGISTERED) {
                            JAZ jAZ = string;
                            jAZ.AdpPushClient.this.eventBus.HUI(string);
                            JAZ jAZ2 = string;
                            String string = jAZ2.NZV;
                            stringArray = jAZ2.MRR;
                            Callback callback = jAZ2.OJW;
                            jAZ.AdpPushClient.this._register(string, stringArray, callback);
                        }
                    }
                });
                return adpPushClient;
            }
            AdpPushClient adpPushClient = this;
            adpPushClient.registerCallback = object2;
            if (adpPushClient.hasNotificationChannel(adpPushClient.getInstallationId())) {
                AdpPushClient adpPushClient2 = this;
                adpPushClient2.deleteNotificationChannel(adpPushClient2.getInstallationId());
            }
            if (!((String)object).equalsIgnoreCase(((com.adpdigital.push.WFM)(object2 = this.getSecureUserId())).NZV())) {
                this.setRegisterTs(System.currentTimeMillis());
            }
            if (((com.adpdigital.push.WFM)object2).NZV() != null && !((String)object).equalsIgnoreCase(((com.adpdigital.push.WFM)object2).NZV())) {
                return this.reRegister((String)object, stringArray);
            }
            this.registeredOnce = false;
            object = com.adpdigital.push.WFM.NZV((String)object);
            this.userId = object;
            DYH.NZV(context, (com.adpdigital.push.WFM)object, "757365724964");
            object = hashSet;
            hashSet = new HashSet<String>(Arrays.asList(this.channels));
            object2 = arrayList;
            arrayList = new ArrayList();
            boolean bl = false;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = this.convertChannelName2OldConvention(stringArray[i]);
                ((ArrayList)object2).add(string);
                if (((HashSet)object).contains(string)) continue;
                bl = true;
            }
            ((AbstractCollection)object).addAll(object2);
            if (bl) {
                this.makeSubsDirty();
            }
            Object object3 = object;
            DYH.NZV(this.getApplicationContext(), (Set<String>)object);
            this.channels = ((AbstractCollection)object3).toArray(new String[((HashSet)object3).size()]);
            installationRetries = 0;
            if (!this.checkPlayServices()) {
                DYH.NZV(this.getApplicationContext(), true);
                IRK.XTU(TAG, "No valid Google Play Services found.");
            } else {
                DYH.NZV(this.getApplicationContext(), false);
            }
            AdpPushClient adpPushClient3 = this;
            adpPushClient3.getApplicationInstallReferrer();
            adpPushClient3.doRegister();
            return adpPushClient3;
        }
        IRK.OJW(TAG, "Please provide a user ID to register with ADP server: " + (String)object);
        if (object2 != null) {
            object2.onFailure(new IllegalArgumentException("Please provide a user ID to register with ADP server: " + (String)object));
        }
        return pushClientInstance;
    }

    private boolean isValid(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (string.length() >= 1 && string.length() <= 64) {
            return string.matches(".*(\\s|#|\\+|/|\\*|\\\\).*") ^ true;
        }
        return false;
    }

    private void doRegister() {
        this.doRegister(false);
    }

    private void doRegister(final boolean bl) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (object.userId.NZV() == null) {
            IRK.OJW(TAG, "userId not initialized yet");
            return;
        }
        if (object.registering) {
            IRK.MRR(TAG, "Register already in progress for " + object.userId);
            return;
        }
        AdpPushClient adpPushClient = object;
        adpPushClient.registering = true;
        IRK.MRR(TAG, "-- Post Event REGISTERING");
        adpPushClient.eventBus.MRR((Object)AppState.REGISTERING);
        adpPushClient.initializeAdapter();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (AdpPushClient.this.registeredOnce) {
                    IRK.XTU(TAG, "Already Registered Once!");
                    AdpPushClient.access$1202(AdpPushClient.this, false);
                    return;
                }
                if (!AdpPushClient.this.foreground.isForeground()) {
                    IRK.XTU(TAG, "Don't register in non-foreground mode!");
                    AdpPushClient.access$1202(AdpPushClient.this, false);
                    return;
                }
                IRK.HUI(TAG, "Registering to Chabok, foreground:" + AdpPushClient.this.isForeground());
                AdpPushClient.this.updateRegistration(bl);
            }
        };
        Object object = TimeUnit.MILLISECONDS;
        worker.schedule(runnable, 250L, (TimeUnit)((Object)object));
    }

    private void cleanData() {
        this.getSharedPreferences().edit().clear().apply();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkPlayServices() {
        block8: {
            int n;
            GoogleApiAvailability googleApiAvailability;
            try {
                googleApiAvailability = GoogleApiAvailability.getInstance();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                IRK.HUI(TAG, "This device is not supported and google api is not available");
                return false;
            }
            {
                n = googleApiAvailability.isGooglePlayServicesAvailable(this.getApplicationContext());
                if (n == 0 || n == 2) break block8;
            }
            {
                if (googleApiAvailability.isUserResolvableError(n) && this.currentActivity != null && this.currentActivity.get() != null) {
                    try {
                        if (this.isEnabledAlertForNotSupportingGcm() && !AdpPushClient.isDisabledSdk()) {
                            googleApiAvailability.getErrorDialog((Activity)this.currentActivity.get(), n, 9000).show();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                IRK.HUI(TAG, "This device is not supported, but google api is available");
                return false;
            }
        }
        return true;
    }

    private AdpPushClient updateRegistration(boolean bl) {
        OJW oJW;
        OJW oJW2;
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        AdpPushClient adpPushClient = this;
        OJW oJW3 = oJW2 = oJW;
        oJW2(this.getApplicationContext());
        oJW3.MRR(this.getAppId());
        oJW3.OJW(SDK_VERSION);
        oJW2.MRR(this.getSecureUserId());
        oJW.NZV(this.channels);
        adpPushClient.restartServiceState = bl;
        adpPushClient.registerInBackground(oJW2);
        return adpPushClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchAndSetAdId(OJW oJW) {
        if (this.isAdvertisingIdEnabled() && Boolean.valueOf(this.checkPlayServices()).booleanValue()) {
            IRK.MRR(IRK.MRR, "\n\n ==================================== \n\nStart getting AdvertisingId at " + System.currentTimeMillis() + "\n\n ==================================== \n\n");
            try {
                String string = this.getPlayAdId(context);
                if (string != null) {
                    oJW.NZV(string);
                }
                oJW.NZV(this.isPlayTrackingEnabled(context));
            }
            catch (Exception exception) {
                IRK.NZV(TAG, "Exception happen for get advertisingId doInBackground: -----> ", exception);
                exception.printStackTrace();
            }
            IRK.MRR(IRK.MRR, "\n\n ==================================== \n\nGet AdvertisingId = " + oJW.NZV() + " at " + System.currentTimeMillis() + "\n\n ==================================== \n\n");
        }
    }

    private synchronized void registerInBackground(OJW objectArray) {
        AdpPushClient adpPushClient = deviceToken2;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[2];
        objectArray = objectArray3;
        objectArray3[0] = Thread.currentThread().getName();
        objectArray3[1] = Thread.currentThread().getId();
        IRK.MRR(TAG, String.format(Locale.getDefault(), "registerInBackground called in `%s` Thread (%d)", objectArray));
        adpPushClient.fetchAndSetAdId((OJW)objectArray2);
        if (!adpPushClient.isEnabledPushNotification()) {
            DeviceToken deviceToken;
            DeviceToken deviceToken2 = deviceToken;
            new DeviceToken(com.adpdigital.push.WFM.NZV("disabled")).NZV(AdpPushClient.class.getCanonicalName());
            MRR.NZV.NZV.OJW.MRR().MRR(deviceToken2);
            return;
        }
        IRK.MRR(TAG, "registerInBackground...");
        ((AdpPushClient)((Object)deviceToken2)).getToken(true);
    }

    private synchronized void getToken(final boolean bl) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = Thread.currentThread().getName();
        objectArray[1] = Thread.currentThread().getId();
        IRK.MRR(TAG, String.format(Locale.getDefault(), "getToken called in `%s` Thread (%d)", objectArray2));
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

            public void onComplete(@NonNull Task<String> object) {
                if (!object.isSuccessful()) {
                    DeviceToken deviceToken;
                    DeviceToken deviceToken2;
                    String string = "";
                    if (object.getException() != null) {
                        string = object.getException().getMessage();
                    }
                    DeviceToken deviceToken3 = deviceToken2 = deviceToken;
                    deviceToken3(com.adpdigital.push.WFM.NZV("---"), string, 201);
                    deviceToken3.NZV(AdpPushClient.class.getCanonicalName());
                    deviceToken.NZV(bl ^ true);
                    MRR.NZV.NZV.OJW.MRR().MRR(deviceToken2);
                    IRK.NZV(TAG, "ERROR DeviceToken ", object.getException());
                } else if (object.getResult() == null) {
                    DeviceToken deviceToken;
                    object = deviceToken;
                    Task<String> task = object;
                    task(com.adpdigital.push.WFM.NZV("---"), "Token is null for unknown reason.", 200);
                    task.NZV(AdpPushClient.class.getCanonicalName());
                    deviceToken.NZV(bl ^ true);
                    MRR.NZV.NZV.OJW.MRR().MRR(object);
                } else {
                    DeviceToken deviceToken;
                    DeviceToken deviceToken4;
                    object = com.adpdigital.push.WFM.NZV((String)object.getResult());
                    DeviceToken deviceToken5 = deviceToken4 = deviceToken;
                    deviceToken5((com.adpdigital.push.WFM)object);
                    deviceToken5.NZV(AdpPushClient.class.getCanonicalName());
                    deviceToken.NZV(bl ^ true);
                    MRR.NZV.NZV.OJW.MRR().MRR(deviceToken4);
                    IRK.MRR(TAG, "DeviceToken task is successful ~> " + object);
                }
            }
        }).addOnCanceledListener(new OnCanceledListener(){

            public void onCanceled() {
                DeviceToken deviceToken;
                DeviceToken deviceToken2;
                DeviceToken deviceToken3 = deviceToken2 = deviceToken;
                deviceToken3(com.adpdigital.push.WFM.NZV("---"), "CANCELED", 202);
                deviceToken3.NZV(AdpPushClient.class.getCanonicalName());
                deviceToken.NZV(bl ^ true);
                MRR.NZV.NZV.OJW.MRR().MRR(deviceToken2);
                IRK.XTU(TAG, "Canceled get DeviceToken ");
            }
        });
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveInstallation(OJW objectArray, boolean bl) {
        Object object;
        void var5_15;
        String string;
        HashMap<String, Object> hashMap;
        block36: {
            block38: {
                block35: {
                    HashMap<String, Object> hashMap2;
                    hashMap = hashMap2;
                    hashMap();
                    hashMap.put("launchCount", ((AdpPushClient)((Object)executor)).getAppLaunchCount());
                    hashMap.put("launchTime", ((AdpPushClient)((Object)executor)).getAppLaunchTime());
                    hashMap2.put("realtime", ((AdpPushClient)((Object)executor)).isEnabledRealtime());
                    if (((AdpPushClient)((Object)executor)).getLastAppLaunchTime() > 0L) {
                        hashMap.put("lastLaunchTime", ((AdpPushClient)((Object)executor)).getLastAppLaunchTime());
                    }
                    if (((AdpPushClient)((Object)executor)).hasInstallReferrerData() && (string = ((AdpPushClient)((Object)executor)).getInstallReferrer()) != null) {
                        hashMap.put("referrer", string);
                        hashMap.put("refClickTs", ((AdpPushClient)((Object)executor)).getInstallReferrerClickTs());
                        hashMap.put("refBeginTs", ((AdpPushClient)((Object)executor)).getInstallReferrerInstallBeginTs());
                    }
                    if (((AdpPushClient)((Object)executor)).getRawInstallReferrer() != null) {
                        hashMap.put("rawReferrer", ((AdpPushClient)((Object)executor)).getRawInstallReferrer());
                        hashMap.put("rawRefClickTs", ((AdpPushClient)((Object)executor)).getRawInstallReferrerClickTs());
                    }
                    if ((string = defaultTracker) != null && !string.trim().isEmpty()) {
                        hashMap.put("defaultTracker", defaultTracker);
                    }
                    if ((string = ((AdpPushClient)((Object)executor)).communicateFallbackMachine.NZV()) != null) {
                        hashMap.put("eventData", string);
                    }
                    hashMap.put("deviceId", ((AdpPushClient)((Object)executor)).getDeviceId());
                    string = ((AdpPushClient)((Object)executor)).getUniqueID();
                    if (string != null && string.trim() != "") {
                        hashMap.put("uniqueId", string);
                    }
                    try {
                        string = DYH.HUI(context);
                        String string2 = string != null ? hashMap.put("appSessionId", string) : hashMap.put("appSessionId", "INVALID");
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        nameNotFoundException.printStackTrace();
                    }
                    HashMap<String, Object> hashMap3 = hashMap;
                    hashMap3.put("appTokenId", DYH.NZV(context));
                    hashMap3.put("mobileOperator", DYH.YCE(context));
                    if (!((AdpPushClient)((Object)executor)).checkPlayServices()) {
                        hashMap.put("gpsVersionFound", -1);
                    } else {
                        if (context == null || context.getPackageManager() == null) break block35;
                        string = "gpsVersionFound";
                        hashMap.put(string, AdpPushClient.context.getPackageManager().getPackageInfo((String)"com.google.android.gms", (int)0).versionCode);
                    }
                    break block35;
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                hashMap.put("gpsVersionRequired", GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE);
                string = "connection";
                NetworkInfo networkInfo = ((ConnectivityManager)((AdpPushClient)((Object)executor)).getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
                if (networkInfo == null || !networkInfo.isConnected()) break block38;
                if (networkInfo.getType() == 1) {
                    String string3 = "WiFi";
                    break block36;
                } else if (networkInfo.getType() == 0) {
                    switch (networkInfo.getSubtype()) {
                        default: {
                            String string4 = "N:" + networkInfo.getSubtype();
                            break;
                        }
                        case 13: {
                            String string5 = "4G";
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 14: 
                        case 15: {
                            String string6 = "3G";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 7: 
                        case 11: {
                            String string7 = "2G";
                            break;
                        }
                    }
                    break block36;
                } else {
                    String string8 = "T:" + networkInfo.getType();
                }
                break block36;
            }
            String string9 = "-";
        }
        HashMap<String, Object> hashMap4 = hashMap;
        hashMap4.put(string, var5_15);
        hashMap4.put("osVersion", Build.VERSION.RELEASE);
        hashMap4.put("deviceManufacturer", Build.MANUFACTURER);
        hashMap4.put("deviceModel", Build.MODEL);
        hashMap4.put("osBuild", Build.ID);
        hashMap4.put("locale", Locale.getDefault());
        hashMap.put("clientVersion", ((AdpPushClient)((Object)executor)).getClientVersion());
        hashMap.put("launched", ((AdpPushClient)((Object)executor)).isLaunched);
        hashMap.put("newInstall", ((AdpPushClient)((Object)executor)).isNewInstall);
        boolean bl2 = ((AdpPushClient)((Object)executor))._isLoggedInNow;
        if (bl2) {
            hashMap.put("isLoggedIn", bl2);
        }
        if ((object = ((AdpPushClient)((Object)executor)).userHash) != null && !((String)object).isEmpty()) {
            hashMap.put("userHash", ((AdpPushClient)((Object)executor)).userHash);
        }
        if ((object = ((AdpPushClient)((Object)executor)).userInfo) != null && !((HashMap)object).isEmpty()) {
            hashMap.put("userInfo", ((AdpPushClient)((Object)executor)).userInfo);
        }
        if ((object = ((AdpPushClient)((Object)executor)).getNotificationSettings()) != null) {
            hashMap.put("notificationSettings", object);
        }
        hashMap.put("installSource", ((AdpPushClient)((Object)executor)).getInstallSource());
        hashMap.put("installDate", ((AdpPushClient)((Object)executor)).installDate);
        object = ((AdpPushClient)((Object)executor)).getDeviceScreenResolution();
        if (object != null) {
            hashMap.put("screenResolution", object);
        }
        if (((com.adpdigital.push.WFM)(object = ((AdpPushClient)((Object)executor)).getReregisteredFrom())).NZV() != null) {
            hashMap.put("reregisteredFrom", ((com.adpdigital.push.WFM)object).NZV());
        }
        if ((object = context) != null && object.getPackageName() != null) {
            hashMap.put("appBundleId", context.getPackageName());
        }
        if (objectArray.YCE() == null) {
            try {
                if (NotificationManagerCompat.from((Context)context).areNotificationsEnabled()) {
                    objectArray.HUI("ALLOWED");
                } else {
                    objectArray.HUI("DENIED");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        hashMap.put("isProduction", true);
        AsyncTask<Void, Void, Boolean> asyncTask = new AsyncTask<Void, Void, Boolean>((OJW)objectArray, hashMap, (AdpPushClient)((Object)executor), bl){
            final /* synthetic */ OJW NZV;
            final /* synthetic */ HashMap MRR;
            final /* synthetic */ AdpPushClient OJW;
            final /* synthetic */ boolean HUI;
            {
                this.NZV = oJW;
                this.MRR = hashMap;
                this.OJW = adpPushClient2;
                this.HUI = bl;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Boolean NZV() {
                IRK.MRR(TAG, "saveInstallation.doInBackground()");
                Object object = AdpPushClient.this._installationLock;
                synchronized (object) {
                    CountDownLatch countDownLatch;
                    IRK.MRR(TAG, "_installationLock acquired");
                    IRK.HUI(TAG, "Saving installation " + this.NZV.OJW());
                    String string = TAG;
                    Locale locale = Locale.getDefault();
                    Object[] objectArray = new Object[2];
                    objectArray[0] = Thread.currentThread().getName();
                    objectArray[1] = Thread.currentThread().getId();
                    IRK.MRR(string, String.format(locale, "installation doInBackground called in `%s` Thread (%d)", objectArray));
                    CountDownLatch countDownLatch2 = countDownLatch;
                    countDownLatch2(1);
                    NZV.NZV.XTU.NZV(this.NZV, (Map<String, Object>)this.MRR, this.NZV.HUI(), (Callback)new com.adpdigital.push.NZV(this, countDownLatch2));
                    IRK.MRR(TAG, "_installationLatch await");
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        IRK.OJW(TAG, "_installationLatch interrupted");
                    }
                    IRK.MRR(TAG, "_installationLock released");
                    return true;
                }
            }

            protected void onPostExecute(Object object) {
                Boolean cfr_ignored_0 = (Boolean)object;
            }
        };
        Executor executor = AsyncTask.THREAD_POOL_EXECUTOR;
        Void[] voidArray = new Void[3];
        objectArray = voidArray;
        voidArray[0] = null;
        voidArray[1] = null;
        voidArray[2] = null;
        asyncTask.executeOnExecutor(executor, objectArray);
    }

    public static Map<String, Object> beforeSend(Map<String, Object> map) {
        return AdpPushClient.get()._beforeSend(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> _beforeSend(Map<String, Object> map) {
        String string;
        String string2;
        Integer n;
        long l;
        block11: {
            Map<String, Object> map2 = map;
            map2.put("isGuest", ((AdpPushClient)((Object)string3)).isGuestUser());
            map2.put("registerTs", ((AdpPushClient)((Object)string3)).getRegisterTs());
            l = ((AdpPushClient)((Object)string3)).getAppLaunchTime();
            n = String.valueOf(DYH.MRR(map)).replaceAll("(\\\\.)", "/").length();
            string2 = map.get("deviceType") + "";
            string = ((AdpPushClient)((Object)string3)).getUniqueID();
            if (string != null) break block11;
            string = "";
        }
        String string3 = DYH.NZV(((AdpPushClient)((Object)string3)).getSecureUserId(), string, string2, l, n);
        if (string3 == null) return map;
        try {
            map.put("manufacturerId", string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return map;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return map;
    }

    private String getPlayAdId(Context context) {
        Object object = null;
        long l = 11000;
        for (int i = 0; i < 3; ++i) {
            try {
                object = DYH.NZV(context, l).NZV();
                if (object != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((object = DYH.XTU(context)) != null) break;
        }
        return object;
    }

    private boolean isPlayTrackingEnabled(Context context) {
        Object object = null;
        long l = 11000;
        for (int i = 0; i < 3; ++i) {
            try {
                object = DYH.NZV(context, l).MRR();
                if (object != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            if ((object = DYH.AOP(context)) != null) break;
        }
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    private String getInstallSource() {
        block7: {
            if (context == null) break block7;
            if (context.getPackageManager() == null) break block7;
            Object object = context.getPackageManager();
            if (context.getPackageName() == null) break block7;
            try {
                object = object.getInstallerPackageName(context.getPackageName());
                if (object != null) {
                    return object;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "notSet";
    }

    @Nullable
    private String getDeviceScreenResolution() {
        WeakReference<Activity> weakReference = adpPushClient.currentActivity;
        if (weakReference != null && weakReference.get() != null) {
            AdpPushClient adpPushClient = ((Activity)adpPushClient.currentActivity.get()).getWindowManager().getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            adpPushClient.getMetrics(displayMetrics);
            int n = displayMetrics.widthPixels;
            int n2 = displayMetrics.heightPixels;
            int n3 = Build.VERSION.SDK_INT;
            if (n3 >= 14 && n3 < 17) {
                Class<Display> clazz;
                try {
                    clazz = Display.class;
                }
                catch (Exception exception) {}
                n = (Integer)clazz.getMethod("getRawWidth", new Class[0]).invoke((Object)adpPushClient, new Object[0]);
                Class<Display> clazz2 = Display.class;
                n2 = (Integer)clazz2.getMethod("getRawHeight", new Class[0]).invoke((Object)adpPushClient, new Object[0]);
            }
            if (Build.VERSION.SDK_INT >= 17) {
                Class<Display> clazz;
                Point point;
                Point point2 = point;
                try {
                    point = new Point();
                    clazz = Display.class;
                }
                catch (Exception exception) {}
                Class[] classArray = new Class[1];
                classArray[0] = Point.class;
                clazz.getMethod("getRealSize", classArray).invoke((Object)adpPushClient, point2);
                n = point.x;
                n2 = point.y;
            }
            return n + "x" + n2;
        }
        return null;
    }

    private void retryRegistrationBackoff() {
        if (++installationRetries <= 10) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = objectArray3;
                    IRK.MRR(TAG, "retryRegistration started");
                    Object[] objectArray2 = new Object[2];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = Thread.currentThread().getName();
                    objectArray2[1] = Thread.currentThread().getId();
                    IRK.MRR(TAG, String.format(Locale.getDefault(), "retryRegistration called in `%s` Thread (%d)", objectArray3));
                    objectArray.AdpPushClient.this.doRegister();
                }
            };
            double d = installationRetries;
            long l = (long)Math.max(Math.pow(2.0, d), 32.0);
            Object[] objectArray = new Object[1];
            Object object = objectArray;
            objectArray[0] = l;
            IRK.MRR(TAG, String.format(Locale.getDefault(), "retryRegistration with `%d` seconds Backoff", object));
            object = TimeUnit.SECONDS;
            worker.schedule(runnable2, l, (TimeUnit)((Object)object));
        }
    }

    private void retryGetTokenBackoff() {
        if (++tokenRetries <= 5) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = objectArray3;
                    IRK.MRR(TAG, "retryGetToken started");
                    Object[] objectArray2 = new Object[2];
                    Object[] objectArray3 = objectArray2;
                    objectArray2[0] = Thread.currentThread().getName();
                    objectArray2[1] = Thread.currentThread().getId();
                    IRK.MRR(TAG, String.format(Locale.getDefault(), "retryGetToken called in `%s` Thread (%d)", objectArray3));
                    objectArray.AdpPushClient.this.getToken(false);
                }
            };
            double d = tokenRetries;
            long l = (long)Math.max(Math.pow(2.0, d), 10.0);
            Object[] objectArray = new Object[1];
            Object object = objectArray;
            objectArray[0] = l;
            IRK.MRR(TAG, String.format(Locale.getDefault(), "retryGetToken with `%d` seconds Backoff", object));
            object = TimeUnit.SECONDS;
            tokenWorker.schedule(runnable2, l, (TimeUnit)((Object)object));
        }
    }

    @Deprecated
    private String getDeviceId() {
        return Build.SERIAL;
    }

    private String getUniqueID() {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    private void updateLaunchStats() {
        AdpPushClient adpPushClient = this;
        adpPushClient.lastLaunchTime = adpPushClient.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, -1L);
        int n = adpPushClient.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
        adpPushClient.getSharedPreferences().edit().putInt(APPLICATION_LAUNCH, n + 1).apply();
        long l = System.currentTimeMillis();
        adpPushClient.getSharedPreferences().edit().putLong(APPLICATION_LAUNCH_TS, l).apply();
        adpPushClient.isLaunched = true;
    }

    private void unregister(boolean bl) {
        block8: {
            block7: {
                Object object;
                if (!bl) {
                    Callback<OJW> callback;
                    object = callback;
                    callback = new Callback<OJW>(this){

                        @Override
                        public void onFailure(Throwable throwable) {
                            IRK.OJW(TAG, "Delete Error " + throwable);
                        }

                        @Override
                        public void onSuccess(Object object) {
                            OJW oJW = (OJW)object;
                            IRK.XTU(TAG, "Deleted " + oJW.OJW() + ": " + oJW);
                        }
                    };
                    this.deleteInstallation((Callback)object);
                }
                object = XTU.NZV("757365724964");
                DYH.VMB(context).edit().remove((String)object).apply();
                if (this.getGuestUserId() == null) break block7;
                if (this.userId.NZV() == null) break block7;
                if (!this.userId.NZV().equalsIgnoreCase(this.getGuestUserId())) break block8;
            }
            try {
                this.getSharedPreferences().edit().remove("CHK_GUI").apply();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            AdpPushClient adpPushClient = this;
            adpPushClient.getSharedPreferences().edit().remove("deviceToken").apply();
            adpPushClient.getSharedPreferences().edit().remove("installationId").apply();
        }
        AdpPushClient adpPushClient = this;
        DYH.VMB(adpPushClient.getApplicationContext()).edit().remove("topics").apply();
        adpPushClient.getSharedPreferences().edit().remove("subscriptionDirty").apply();
        adpPushClient.getSharedPreferences().edit().remove("offlineCache").apply();
        adpPushClient.getSharedPreferences().edit().remove("pendingInAppMsgs").apply();
        adpPushClient.getSharedPreferences().edit().remove("dataCache").apply();
        adpPushClient.channels = new String[]{"default"};
        PushService.NZV(adpPushClient.getApplicationContext(), "DISCONNECT");
    }

    private void deleteInstallation(final Callback callback) {
        Callback callback2;
        OJW oJW;
        final OJW oJW2 = oJW;
        if (new OJW(this.getApplicationContext()).OJW() == null) {
            IRK.XTU(TAG, "------ Warning : Device was unregistered before!! -------");
            return;
        }
        Callback callback3 = callback2;
        callback2 = new Callback(){

            public void onSuccess(Object object) {
                object = callback;
                if (object != null) {
                    object.onSuccess(oJW2);
                }
            }

            @Override
            public void onFailure(Throwable throwable) {
                Callback callback2 = callback2.callback;
                if (callback2 != null) {
                    callback2.onFailure(throwable);
                }
            }
        };
        NZV.NZV.XTU.NZV(oJW2, callback3);
    }

    private void updateInstallation(Map<String, Object> map) {
        Callback<OJW> callback;
        Callback<OJW> callback2 = callback;
        callback = new Callback<OJW>(this){

            @Override
            public void onFailure(Throwable throwable) {
            }

            @Override
            public void onSuccess(Object object) {
                OJW cfr_ignored_0 = (OJW)object;
            }
        };
        this.updateInstallation(map, callback2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateInstallation(Map<String, Object> map, Callback<OJW> callback) {
        Object object;
        OJW oJW;
        OJW oJW2;
        AdpPushClient adpPushClient = this;
        adpPushClient.eventBus.MRR((Object)ChabokCommunicateStatus.UpdatingInstallation);
        OJW oJW3 = oJW2 = oJW;
        oJW2(this.getApplicationContext());
        oJW3.MRR(this.getAppId());
        oJW3.OJW(SDK_VERSION);
        oJW2.MRR(this.getSecureUserId());
        oJW.NZV(this.channels);
        map.put("launched", adpPushClient.isLaunched);
        map.put("newInstall", this.isNewInstall);
        map.put("launchTime", this.getAppLaunchTime());
        map.put("realtime", this.isEnabledRealtime());
        if (this.getLastAppLaunchTime() > 0L) {
            map.put("lastLaunchTime", this.getLastAppLaunchTime());
        }
        if ((object = this.getUniqueID()) != null && !((String)object).isEmpty()) {
            map.put("uniqueId", object);
        }
        try {
            object = DYH.HUI(context);
            Object object2 = object != null ? map.put("appSessionId", object) : map.put("appSessionId", "INVALID");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        Map<String, Object> map2 = map;
        map2.put("appTokenId", DYH.NZV(context));
        map2.put("mobileOperator", DYH.YCE(context));
        object = this.communicateFallbackMachine.NZV();
        if (object != null) {
            map.put("eventData", object);
        }
        if ((object = this.userInfo) != null && !((HashMap)object).isEmpty()) {
            map.put("userInfo", this.userInfo);
        }
        this.updateInstallation(oJW2, map, callback);
    }

    private OJW getInstallationModel() {
        OJW oJW;
        OJW oJW2;
        OJW oJW3 = oJW2 = oJW;
        oJW2(this.getApplicationContext());
        oJW3.MRR(this.getAppId());
        oJW3.OJW(SDK_VERSION);
        oJW2.MRR(this.getSecureUserId());
        oJW.NZV(this.channels);
        return oJW;
    }

    private void updateInstallation(OJW objectArray, Map<String, Object> map, Callback<OJW> callback) {
        AsyncTask<Void, Void, Boolean> asyncTask = new AsyncTask<Void, Void, Boolean>((OJW)objectArray, map, callback){
            final /* synthetic */ OJW NZV;
            final /* synthetic */ Map MRR;
            final /* synthetic */ Callback OJW;
            {
                this.NZV = oJW;
                this.MRR = map;
                this.OJW = callback;
            }

            protected void onPostExecute(Object object) {
                Boolean cfr_ignored_0 = (Boolean)object;
            }

            protected Object doInBackground(Object[] object) {
                Void[] cfr_ignored_0 = (Void[])object;
                OJW oJW = this.NZV;
                object = this.MRR;
                NZV.NZV.XTU.MRR(oJW, (Map<String, Object>)object, oJW.HUI(), new MRR(this));
                return true;
            }
        };
        Executor executor = AsyncTask.THREAD_POOL_EXECUTOR;
        Object[] objectArray2 = new Void[3];
        objectArray = objectArray2;
        objectArray2[0] = null;
        objectArray2[1] = null;
        objectArray2[2] = null;
        asyncTask.executeOnExecutor(executor, objectArray);
    }

    private void requestCode(String string, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string == null) {
            IRK.OJW(IRK.MRR, "userId is null. Please provide a userId for request code");
            return;
        }
        NZV.NZV.XTU.NZV(com.adpdigital.push.WFM.NZV(string).NZV(), null, null, callback);
    }

    private ForegroundManager getForegroundManager() {
        return this.foreground;
    }

    private Context getApplicationContext() {
        return context;
    }

    private com.adpdigital.push.WFM getSecureUserId() {
        return DYH.NZV(this.getApplicationContext(), "757365724964");
    }

    private long getRegisterTs() {
        return this.getSharedPreferences().getLong("CHK_REGISTER_TS", 0L);
    }

    private void setRegisterTs(long l) {
        this.getSharedPreferences().edit().putLong("CHK_REGISTER_TS", l).apply();
    }

    private boolean isGuestUser() {
        return this.getGuestUserId() != null;
    }

    private void setGuestUserId(String string) {
        if (string == null) {
            this.getSharedPreferences().edit().remove("CHK_GUI").apply();
        } else {
            this.getSharedPreferences().edit().putString("CHK_GUI", XTU.MRR(context, string)).apply();
        }
    }

    private String getGuestUserId() {
        if ((this = ((AdpPushClient)this).getSharedPreferences().getString("CHK_GUI", null)) != null) {
            return XTU.NZV(context, (String)this);
        }
        return null;
    }

    private void addToUserAttributeArray(String string, Integer n) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Integer[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = n;
        super.addToUserAttributeArrayInternal(string, objectArray3, null);
    }

    private void addToUserAttributeArray(String string, Integer[] integerArray) {
        this.addToUserAttributeArrayInternal(string, integerArray, null);
    }

    private void removeFromUserAttributeArray(String string, Integer n) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Integer[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = n;
        super.removeFromUserAttributeArrayInternal(string, objectArray3, null);
    }

    private void removeFromUserAttributeArray(String string, Integer[] integerArray) {
        this.removeFromUserAttributeArrayInternal(string, integerArray, null);
    }

    private void addToUserAttributeArrayInternal(String string, Object[] objectArray, Callback callback) {
        block5: {
            block6: {
                HashMap hashMap;
                JSONObject jSONObject;
                if (AdpPushClient.isDisabledSdk()) {
                    return;
                }
                if (string == null || string.isEmpty()) break block5;
                if (objectArray == null || objectArray.length <= 0) break block6;
                JSONObject jSONObject2 = jSONObject;
                String string2 = string;
                JSONObject jSONObject3 = new JSONObject();
                JSONObject jSONObject4 = new JSONObject().put("operation", (Object)"addToArray").put("type", (Object)"array");
                string = "value";
                try {
                    new JSONObject().put("keys", (Object)jSONObject3.put(string2, (Object)jSONObject4.put(string, (Object)DYH.OJW(objectArray))));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                AdpPushClient adpPushClient = hashMap2;
                HashMap hashMap2 = hashMap;
                hashMap = new HashMap();
                adpPushClient.setUserAttributesInternal(hashMap2, jSONObject2, callback);
                return;
            }
            IRK.OJW(TAG, "attribute values parameter should have a value.");
            return;
        }
        IRK.OJW(TAG, "attribute key parameter should has a value.");
    }

    private void removeFromUserAttributeArrayInternal(String string, Object[] objectArray, Callback callback) {
        block5: {
            block6: {
                HashMap hashMap;
                JSONObject jSONObject;
                if (AdpPushClient.isDisabledSdk()) {
                    return;
                }
                if (string == null || string.isEmpty()) break block5;
                if (objectArray == null || objectArray.length <= 0) break block6;
                JSONObject jSONObject2 = jSONObject;
                String string2 = string;
                JSONObject jSONObject3 = new JSONObject();
                JSONObject jSONObject4 = new JSONObject().put("operation", (Object)"removeFromArray").put("type", (Object)"array");
                string = "value";
                try {
                    new JSONObject().put("keys", (Object)jSONObject3.put(string2, (Object)jSONObject4.put(string, (Object)DYH.OJW(objectArray))));
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                AdpPushClient adpPushClient = hashMap2;
                HashMap hashMap2 = hashMap;
                hashMap = new HashMap();
                adpPushClient.setUserAttributesInternal(hashMap2, jSONObject2, callback);
                return;
            }
            IRK.OJW(TAG, "attribute values parameter should have a value.");
            return;
        }
        IRK.OJW(TAG, "attribute key parameter should has a value.");
    }

    private void setUserAttributesInternal(HashMap<String, Object> object, JSONObject jSONObject, final Callback callback) {
        if (this.isRegistered()) {
            Callback callback2;
            HashMap<String, Object> hashMap = object;
            object = callback2;
            callback2 = new Callback(){

                public void onSuccess(Object object) {
                    JSONObject jSONObject;
                    IRK.MRR(TAG, "Successfully send attribute data.");
                    JSONObject jSONObject2 = jSONObject;
                    try {
                        jSONObject = new JSONObject(object.toString());
                        callback2.AdpPushClient.this.saveUserAttributes(DYH.NZV(jSONObject2));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    Callback callback2 = callback2.callback;
                    if (callback2 != null) {
                        callback2.onSuccess(object);
                    }
                }

                @Override
                public void onFailure(Throwable throwable) {
                    IRK.NZV(TAG, "Fail to send attribute data. ", throwable);
                    Callback callback2 = callback2.callback;
                    if (callback2 != null) {
                        callback2.onFailure(throwable);
                    }
                }
            };
            NZV.NZV.XTU.NZV(this.getInstallationId(), hashMap, jSONObject, (Callback)object);
        }
    }

    private void saveUserAttributes(HashMap<String, Object> jSONObject) {
        JSONObject jSONObject2;
        if (jSONObject == null) {
            return;
        }
        this.userInfo = jSONObject;
        jSONObject = jSONObject2;
        jSONObject2 = new JSONObject(this.userInfo);
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        try {
            editor.putString("CHK_USER_INFO", XTU.MRR(context, jSONObject.toString())).apply();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setUserAttributes(Bundle bundle, Callback callback) {
        HashMap<String, Object> hashMap;
        Object object;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (bundle == null) {
            IRK.OJW(TAG, "attributes parameter should have a value. To removing attributes data, provide an empty Bundle");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attributes parameter should have a value. To removing attributes data, provide an empty Bundle");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        JSONObject jSONObject = ((AdpPushClient)object).prepareMetaData(bundle);
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap = new HashMap<String, Object>();
        for (String string : bundle.keySet()) {
            Object object2 = bundle.get(string);
            if (object2 instanceof Datetime) {
                hashMap2.put(string, ((Datetime)object2).getTime());
                continue;
            }
            hashMap2.put(string, object2);
        }
        if (hashMap2 == null) {
            IRK.OJW(TAG, "cannot convert attributes parameter to map.");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("cannot convert attributes parameter to map.");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        Object object3 = object;
        super.saveUserAttributes(hashMap2);
        super.setUserAttributesInternal(hashMap2, jSONObject, callback);
    }

    private void setUserAttributes(HashMap<String, Object> hashMap, Callback callback) {
        Object object;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (hashMap == null) {
            IRK.OJW(TAG, "attribute parameter should has a value. To removing attribute data, provide an empty HashMap");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attribute parameter should has a value. To removing attribute data, provide an empty HashMap");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        AdpPushClient adpPushClient = object;
        object = adpPushClient.prepareMetaData(hashMap);
        adpPushClient.saveUserAttributes(hashMap);
        adpPushClient.setUserAttributesInternal(hashMap, (JSONObject)object, callback);
    }

    private void incrementUserAttribute(String string, Callback callback) {
        this.incrementUserAttribute(string, 1.0, callback);
    }

    private void incrementUserAttribute(String string, double d, Callback callback) {
        HashMap hashMap;
        HashMap<String, Double> hashMap2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string == null) {
            IRK.OJW(TAG, "attributeName is null. Please provide an attributeName");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                hashMap2 = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attributeName is null. Please provide an attributeName");
                callback.onFailure((Throwable)((Object)hashMap2));
            }
            return;
        }
        AdpPushClient adpPushClient = hashMap2;
        hashMap2 = hashMap;
        hashMap2();
        hashMap.put(string, d);
        adpPushClient.incrementUserAttribute(hashMap2, callback);
    }

    private void incrementUserAttribute(ArrayList<String> cloneable, Callback callback) {
        HashMap hashMap;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (cloneable == null) {
            IRK.OJW(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attributes is null. Please provide an attribute");
                callback.onFailure(illegalArgumentException2);
            }
            return;
        }
        ArrayList<String> arrayList = cloneable;
        cloneable = hashMap;
        hashMap = new HashMap();
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((HashMap)cloneable).put(iterator.next(), 1.0);
        }
        super.incrementUserAttribute((HashMap<String, Double>)cloneable, callback);
    }

    private void incrementUserAttribute(final HashMap<String, Double> hashMap, final Callback callback) {
        JSONArray jSONArray;
        IllegalArgumentException illegalArgumentException2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (hashMap == null) {
            IRK.OJW(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                illegalArgumentException2 = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attributes parameter is null. please, provide an attribute");
                callback.onFailure(illegalArgumentException2);
            }
            return;
        }
        Object object = jSONArray;
        jSONArray = new JSONArray();
        for (Map.Entry<String, Double> entry : hashMap.entrySet()) {
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject2();
            String string = "attribute";
            try {
                jSONObject2.put(string, (Object)entry.getKey());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                continue;
            }
            String string2 = "value";
            jSONObject.put(string2, (Object)entry.getValue());
            object.put((Object)jSONObject);
        }
        if (((AdpPushClient)((Object)illegalArgumentException2)).isRegistered()) {
            Callback callback2;
            JSONArray jSONArray2 = object;
            object = callback2;
            callback2 = new Callback(){

                public void onSuccess(Object object) {
                    IRK.MRR(TAG, "Successfully increment attribute " + callback2.hashMap.toString());
                    Callback callback2 = callback2.callback;
                    if (callback2 != null) {
                        callback2.onSuccess(object);
                    }
                }

                @Override
                public void onFailure(Throwable throwable) {
                    IRK.NZV(TAG, "Fail to increment attribute " + callback2.hashMap.toString(), throwable);
                    Callback callback2 = callback2.callback;
                    if (callback2 != null) {
                        callback2.onFailure(throwable);
                    }
                }
            };
            NZV.NZV.XTU.NZV(((AdpPushClient)((Object)illegalArgumentException2)).getInstallationId(), jSONArray2, (Callback)object);
        } else {
            IRK.MRR(TAG, "User not registered yet, try to increment attributes (" + hashMap.toString() + ") after send successfully installation request");
            ((AdpPushClient)((Object)illegalArgumentException2)).eventBus.OJW(new Object(){

                public void onEvent(ChabokCommunicateStatus chabokCommunicateStatus) {
                    if (chabokCommunicateStatus == ChabokCommunicateStatus.InstallationSuccessfullySent) {
                        HXH hXH = this;
                        hXH.AdpPushClient.this.incrementUserAttribute(hashMap);
                        IRK.MRR(TAG, "Installation successfully sent, Start incrementing attributes (" + hashMap.toString() + ")");
                        hXH.AdpPushClient.this.eventBus.HUI(this);
                    }
                }
            });
        }
    }

    private void decrementUserAttribute(ArrayList<String> cloneable, Callback callback) {
        HashMap hashMap;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (cloneable == null) {
            IRK.OJW(TAG, "attributes is null. Please provide an attribute");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attributes is null. Please provide an attribute");
                callback.onFailure(illegalArgumentException2);
            }
            return;
        }
        ArrayList<String> arrayList = cloneable;
        cloneable = hashMap;
        hashMap = new HashMap();
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((HashMap)cloneable).put(iterator.next(), -1.0);
        }
        super.incrementUserAttribute((HashMap<String, Double>)cloneable, callback);
    }

    private void decrementUserAttribute(final HashMap<String, Double> hashMap, final Callback callback) {
        JSONArray jSONArray;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (hashMap == null) {
            IRK.OJW(TAG, "attributes parameter is null. please, provide an attribute");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("attributes parameter is null. please, provide an attribute");
                callback.onFailure(illegalArgumentException2);
            }
            return;
        }
        Object object = jSONArray;
        jSONArray = new JSONArray();
        for (Map.Entry<String, Double> entry : hashMap.entrySet()) {
            JSONObject jSONObject = new JSONObject();
            String string = "attribute";
            try {
                jSONObject.put(string, (Object)entry.getKey());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                continue;
            }
            double d = -entry.getValue().doubleValue();
            jSONObject.put("value", d);
            object.put((Object)jSONObject);
        }
        if (((AdpPushClient)((Object)illegalArgumentException2)).isRegistered()) {
            Callback callback2;
            JSONArray jSONArray2 = object;
            object = callback2;
            callback2 = new Callback(){

                public void onSuccess(Object object) {
                    IRK.MRR(TAG, "Successfully increment attribute " + callback2.hashMap.toString());
                    Callback callback2 = callback2.callback;
                    if (callback2 != null) {
                        callback2.onSuccess(object);
                    }
                }

                @Override
                public void onFailure(Throwable throwable) {
                    IRK.NZV(TAG, "Fail to increment attribute " + callback2.hashMap.toString(), throwable);
                    Callback callback2 = callback2.callback;
                    if (callback2 != null) {
                        callback2.onFailure(throwable);
                    }
                }
            };
            NZV.NZV.XTU.NZV(((AdpPushClient)((Object)illegalArgumentException2)).getInstallationId(), jSONArray2, (Callback)object);
        } else {
            IRK.MRR(TAG, "User not registered yet, try to increment attributes (" + hashMap.toString() + ") after send successfully installation request");
            ((AdpPushClient)((Object)illegalArgumentException2)).eventBus.OJW(new Object(){

                public void onEvent(ChabokCommunicateStatus chabokCommunicateStatus) {
                    if (chabokCommunicateStatus == ChabokCommunicateStatus.InstallationSuccessfullySent) {
                        LMH lMH = this;
                        lMH.AdpPushClient.this.incrementUserAttribute(hashMap);
                        IRK.MRR(TAG, "Installation successfully sent, Start incrementing attributes (" + hashMap.toString() + ")");
                        lMH.AdpPushClient.this.eventBus.HUI(this);
                    }
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HashMap<String, Object> loadMap(String object) {
        JSONObject jSONObject;
        HashMap hashMap;
        AdpPushClient adpPushClient = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        object = adpPushClient.getSharedPreferences().getString((String)object, null);
        if (object == null) return hashMap2;
        JSONObject jSONObject2 = jSONObject;
        try {
            object = new JSONObject(XTU.NZV(context, (String)object)).keys();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        while (true) {
            if (!object.hasNext()) return hashMap2;
            HashMap hashMap3 = hashMap2;
            JSONObject jSONObject3 = jSONObject2;
            String string = (String)object.next();
            hashMap3.put(string, jSONObject3.get(string));
        }
        return hashMap2;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject prepareMetaData(JSONObject jSONObject) {
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        if (jSONObject == null) {
            return null;
        }
        JSONObject jSONObject4 = jSONObject;
        AdpPushClient adpPushClient = jSONObject3;
        jSONObject3 = new JSONObject();
        Iterator iterator = jSONObject4.keys();
        while (true) {
            if (!iterator.hasNext()) break;
            JSONObject jSONObject5 = jSONObject;
            String string = (String)iterator.next();
            if (!(jSONObject5.get(string) instanceof Datetime)) continue;
            JSONObject jSONObject6 = jSONObject;
            String string2 = string;
            JSONObject jSONObject7 = jSONObject;
            String string3 = string;
            adpPushClient.put(string, new JSONObject().put("type", (Object)"date"));
            jSONObject6.put(string2, ((Datetime)jSONObject7.get(string3)).getTime());
        }
        if (adpPushClient.length() <= 0) return null;
        try {
            JSONObject jSONObject8 = new JSONObject();
            jSONObject2 = jSONObject8;
            jSONObject8.put("keys", (Object)adpPushClient);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject2;
        return null;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject prepareMetaData(HashMap<String, Object> hashMap) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        if (hashMap == null) {
            return null;
        }
        HashMap<String, Object> hashMap2 = hashMap;
        AdpPushClient adpPushClient = jSONObject2;
        jSONObject2 = new JSONObject();
        Iterator<String> iterator = hashMap2.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            HashMap<String, Object> hashMap3 = hashMap;
            String string = iterator.next();
            if (!(hashMap3.get(string) instanceof Datetime)) continue;
            HashMap<String, Object> hashMap4 = hashMap;
            String string2 = string;
            HashMap<String, Object> hashMap5 = hashMap;
            String string3 = string;
            adpPushClient.put(string, new JSONObject().put("type", (Object)"date"));
            hashMap4.put(string2, ((Datetime)hashMap5.get(string3)).getTime());
        }
        if (adpPushClient.length() <= 0) return null;
        try {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject = jSONObject3;
            jSONObject3.put("keys", (Object)adpPushClient);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
        return null;
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JSONObject prepareMetaData(Bundle bundle) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        if (bundle == null) {
            return null;
        }
        Bundle bundle2 = bundle;
        AdpPushClient adpPushClient = jSONObject2;
        jSONObject2 = new JSONObject();
        Iterator iterator = bundle2.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) break;
            Bundle bundle3 = bundle;
            String string = (String)iterator.next();
            if (!(bundle3.get(string) instanceof Datetime)) continue;
            adpPushClient.put(string, new JSONObject().put("type", (Object)"date"));
        }
        if (adpPushClient.length() <= 0) return null;
        try {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject = jSONObject3;
            jSONObject3.put("keys", (Object)adpPushClient);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jSONObject;
        return null;
    }

    public static void setDefaultTracker(String string) {
        defaultTracker = string;
    }

    public static void setEnvironment(Environment environment) {
        chabokEnvironment = environment;
    }

    private void track(String string, Bundle bundle, Callback callback) {
        Object object;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string == null) {
            IRK.OJW(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("eventName is null, please provide an eventName.");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        if (string.isEmpty()) {
            IRK.OJW(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("eventName is null, please provide an eventName.");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        AdpPushClient adpPushClient = object;
        object = ((AdpPushClient)object).prepareMetaData(bundle);
        adpPushClient.trackInternal(string, DYH.NZV(bundle), (JSONObject)object);
    }

    private void track(String string, JSONObject jSONObject, Callback callback) {
        Object object;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string == null) {
            IRK.OJW(TAG, "eventName is null, please provide an eventName.");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("eventName is null, please provide an eventName.");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        if (string.isEmpty()) {
            IRK.OJW(TAG, "eventName is empty, please provide an eventName.");
            if (callback != null) {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException("eventName is null, please provide an eventName.");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        AdpPushClient adpPushClient = object;
        object = adpPushClient.prepareMetaData(jSONObject);
        adpPushClient.trackInternal(string, jSONObject, (JSONObject)object);
    }

    private void trackInternal(final String string, JSONObject object, JSONObject jSONObject) {
        JSONObject jSONObject2;
        block12: {
            block13: {
                JSONObject jSONObject3;
                jSONObject2 = jSONObject3;
                new JSONObject().put("id", (Object)UUID.randomUUID().toString());
                jSONObject2.put("createdAt", System.currentTimeMillis());
                if (object != null) {
                    if (jSONObject != null) {
                        jSONObject2.put(META_DATA, (Object)jSONObject);
                    }
                    jSONObject2.put("data", object);
                }
                object = VMB.OJW();
                if (object == null) break block12;
                if (!VMB.YCE()) break block13;
                object.put("direct", VMB.YCE());
            }
            try {
                jSONObject2.put("influence", object);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (object2.getInstallationId() == null) {
            object2.eventBus.OJW(new Object(){

                public void onEvent(ConnectionStatus enum_) {
                    if (enum_ == ConnectionStatus.CONNECTED) {
                        SUU sUU = this;
                        AdpPushClient adpPushClient = sUU.AdpPushClient.this;
                        enum_ = com.adpdigital.push.QHG.track;
                        String string3 = string;
                        String string2 = adpPushClient.getInstallationId();
                        JSONObject jSONObject = jSONObject2;
                        adpPushClient.emit((com.adpdigital.push.QHG)enum_, string3, string2, jSONObject, true, false);
                        sUU.AdpPushClient.this.eventBus.HUI(this);
                    }
                }
            });
            return;
        }
        AdpPushClient adpPushClient = object2;
        IRK.MRR(TAG, "Track event: " + string);
        Object object2 = com.adpdigital.push.QHG.track;
        object = adpPushClient.getInstallationId();
        adpPushClient.emit((com.adpdigital.push.QHG)((Object)object2), string, (String)object, jSONObject2, true, false);
    }

    private AdpPushClient setSecure(boolean bl) {
        AdpPushClient adpPushClient = this;
        adpPushClient.useSecure = bl;
        adpPushClient.initializeAdapter();
        return adpPushClient;
    }

    private String convertChannelName2newConvention(String string) {
        if (string.startsWith("private/")) {
            return string;
        }
        if (string.startsWith("public/")) {
            String string2 = string;
            return string2.substring(string2.indexOf("/") + 1);
        }
        return "private/" + string;
    }

    public static void setActivityClass(Class clazz) {
        activityClass = clazz;
    }

    private void getDeferredDeepLink() {
        NZV.NZV.XTU.NZV(this.getInstallationId(), (Callback)new Callback<DeferredData>(){

            @Override
            public void onFailure(Throwable throwable) {
                IRK.NZV(TAG, "unable to get deferred data. error = ", throwable);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onSuccess(Object object) {
                Exception exception2;
                block7: {
                    block5: {
                        if ((object = (DeferredData)object) != null) {
                            boolean bl;
                            block6: {
                                try {
                                    if (((DeferredData)object).getDeepLink() == null) break block5;
                                    IRK.MRR(TAG, "Get deferred deep-link (" + ((DeferredData)object).getDeepLink() + ")");
                                    bl = false;
                                    if (AdpPushClient.this.onDeeplinkResponseListener == null || !(bl = AdpPushClient.this.onDeeplinkResponseListener.launchReceivedDeeplink(((DeferredData)object).getDeepLink()))) break block6;
                                }
                                catch (Exception exception2) {
                                    break block7;
                                }
                                AdpPushClient.this.launchSingleTaskUri(((DeferredData)object).getDeepLink().toString(), "Open deferred deep link");
                            }
                            if (AdpPushClient.this.deferredDataListener != null && !bl && AdpPushClient.this.deferredDataListener.launchReceivedDeeplink(((DeferredData)object).getDeepLink())) {
                                AdpPushClient.this.launchSingleTaskUri(((DeferredData)object).getDeepLink().toString(), "Open deferred deep link");
                            }
                        }
                    }
                    if (object == null) return;
                    if (((DeferredData)object).getLabel() == null) return;
                    if (AdpPushClient.this.deferredDataListener == null) return;
                    IRK.MRR(TAG, "Get referral (" + ((DeferredData)object).getLabel() + ")");
                    AdpPushClient.this.deferredDataListener.onReferralReceived(((DeferredData)object).getLabel());
                    return;
                }
                exception2.printStackTrace();
            }
        });
    }

    private String getDeviceManufacturer() {
        String string = Build.MANUFACTURER;
        IRK.MRR("deviceMan", "" + string);
        return string;
    }

    private void showGuide(Activity object, String string, String string2) {
        this.getApplicationContext();
        SharedPreferences sharedPreferences = object.getSharedPreferences("ProtectedApps", 0);
        if (!sharedPreferences.getBoolean("skipProtectedAppsMessage", false)) {
            sharedPreferences = sharedPreferences.edit();
            Intent intent = new Intent();
            intent.setClassName("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.process.ProtectActivity");
            if (this.isCallable(intent)) {
                DialogInterface.OnClickListener onClickListener;
                CheckBox checkBox;
                CheckBox checkBox2 = checkBox;
                new CheckBox(this.getApplicationContext()).setTextColor(-16777216);
                checkBox2.setText((CharSequence)"     \u062f\u06cc\u06af\u0631 \u0627\u06cc\u0646 \u067e\u06cc\u0627\u0645 \u0631\u0627 \u0646\u0634\u0627\u0646 \u0646\u062f\u0647");
                checkBox2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){
                    final /* synthetic */ SharedPreferences.Editor NZV;
                    {
                        this.NZV = editor;
                    }

                    public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                        RGI rGI = this;
                        rGI.NZV.putBoolean("skipProtectedAppsMessage", bl);
                        rGI.NZV.apply();
                    }
                });
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)object);
                object = onClickListener;
                onClickListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int n) {
                        AdpPushClient.this.huaweiProtectedApps();
                    }
                };
                builder.setIcon(17301543).setTitle((CharSequence)string).setMessage((CharSequence)string2).setView((View)checkBox2).setPositiveButton((CharSequence)"\u0628\u0631\u0648 \u0628\u0647 \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647", (DialogInterface.OnClickListener)object).setNegativeButton((CharSequence)"\u0644\u063a\u0648", null).show();
            } else {
                SharedPreferences sharedPreferences2 = sharedPreferences;
                sharedPreferences2.putBoolean("skipProtectedAppsMessage", true);
                sharedPreferences2.apply();
            }
        }
    }

    private boolean isCallable(Intent intent) {
        return this.getApplicationContext().getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    private void huaweiProtectedApps() {
        String string;
        block5: {
            string = "am start -n com.huawei.systemmanager/.optimize.process.ProtectActivity";
            try {
                if (Build.VERSION.SDK_INT < 17) break block5;
            }
            catch (IOException iOException) {}
            string = string + " --user " + this.getUserSerial();
        }
        Runtime.getRuntime().exec(string);
    }

    private String getUserSerial() {
        block13: {
            block12: {
                if ((object3 = ((AdpPushClient)object3).getApplicationContext().getSystemService("user")) == null) {
                    return "";
                }
                Object object = object3;
                Class<Process> clazz = Process.class;
                Method method = clazz.getMethod("myUserHandle", null);
                Class<Process> clazz2 = Process.class;
                Object object2 = method.invoke(clazz2, null);
                Class<?> clazz3 = object.getClass();
                Class[] classArray = new Class[1];
                int n = 0;
                classArray[n] = object2.getClass();
                Object object3 = (Long)clazz3.getMethod("getSerialNumberForUser", classArray).invoke(object3, object2);
                if (object3 == null) break block12;
                try {
                    return String.valueOf(object3);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block13;
                }
                catch (InvocationTargetException invocationTargetException) {
                    break block13;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    break block13;
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            return "";
        }
        return "";
    }

    private synchronized void updateDeviceToken(DeviceToken deviceToken) {
        this.updateDeviceToken(deviceToken, null);
    }

    private synchronized void updateDeviceToken(DeviceToken object, @Nullable Callback callback) {
        Object object2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (((AdpPushClient)object2).userId.NZV() == null) {
            object2 = "userId not initialized yet";
            IRK.OJW(TAG, (String)object2);
            if (callback != null) {
                Throwable throwable;
                object = throwable;
                throwable = new Throwable((String)object2);
                callback.onFailure((Throwable)object);
            }
            return;
        }
        if (object != null && !TextUtils.isEmpty((CharSequence)((DeviceToken)object).MRR().NZV())) {
            HashMap hashMap;
            if (AdpPushClient.get().getInstallationId() == null) {
                object2 = "Not initialized yet to update device token...";
                IRK.OJW(TAG, (String)object2);
                if (callback != null) {
                    Throwable throwable;
                    object = throwable;
                    throwable = new Throwable((String)object2);
                    callback.onFailure((Throwable)object);
                }
                return;
            }
            Object object3 = object2;
            object2 = hashMap;
            hashMap = new HashMap();
            long l = System.currentTimeMillis();
            String string = ((AdpPushClient)object3).getUserId();
            String string2 = ((AdpPushClient)object3).getInstallationId();
            HashMap<String, Object> hashMap2 = null;
            if (((DeviceToken)object).OJW() != null) {
                HashMap<String, Object> hashMap3;
                hashMap2 = hashMap3;
                hashMap2();
                hashMap2.put("code", ((DeviceToken)object).HUI());
                hashMap3.put("message", ((DeviceToken)object).OJW());
            }
            Object object4 = object2;
            ((HashMap)object4).put("createdAt", l);
            ((HashMap)object4).put("userId", string);
            ((HashMap)object4).put("installationId", string2);
            ((HashMap)object4).put("deviceType", "android");
            ((HashMap)object2).put("deviceToken", ((DeviceToken)object).MRR().NZV());
            if (hashMap2 != null) {
                ((HashMap)object2).put("tokenError", hashMap2);
            }
            if (((DeviceToken)object).YCE() != null) {
                ((HashMap)object2).put("tokenStatus", ((DeviceToken)object).YCE());
            }
            NZV.NZV.XTU.NZV((Map<String, Object>)object2, callback);
            return;
        }
        object2 = "updateDeviceToken: token is empty";
        IRK.OJW(TAG, (String)object2);
        if (callback != null) {
            Throwable throwable;
            object = throwable;
            throwable = new Throwable((String)object2);
            callback.onFailure((Throwable)object);
        }
    }

    private String getRawInstallReferrer() {
        if ((this = ((AdpPushClient)this).getSharedPreferences().getString("CHK_RAW_INSTALL_REFERRER", null)) == null) {
            return null;
        }
        return XTU.NZV(context, (String)this);
    }

    private long getRawInstallReferrerClickTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", 0L);
        }
        catch (NumberFormatException numberFormatException) {
            IRK.NZV("AdpPushLibrary", "Exception happen to get RawInstallRefClickTs", numberFormatException);
            return 0L;
        }
    }

    private Map<String, String> getRawInstallReferrerParams() {
        HashMap hashMap;
        Iterator iterator;
        Object object;
        try {
            object = URLDecoder.decode(((AdpPushClient)object).getRawInstallReferrer(), "UTF-8");
            iterator = object;
        }
        catch (Exception exception) {
            iterator = "malformed";
            IRK.MRR(IRK.MRR, "Referrer decoding failed. Message: (" + exception.getMessage() + ")");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            iterator = "malformed";
            IRK.MRR(IRK.MRR, "Referrer decoding failed due to IllegalArgumentException. Message: (" + illegalArgumentException.getMessage() + ")");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            iterator = "malformed";
            IRK.MRR(IRK.MRR, "Referrer decoding failed due to UnsupportedEncodingException. Message: (" + unsupportedEncodingException.getMessage() + ")");
        }
        IRK.YCE(IRK.MRR, "Referrer to parse (" + (String)((Object)iterator) + ")");
        UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
        urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        urlQuerySanitizer.setAllowUnregisteredParamaters(true);
        urlQuerySanitizer.parseQuery((String)((Object)iterator));
        object = hashMap;
        hashMap = new HashMap();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : urlQuerySanitizer.getParameterList()) {
            String string = parameterValuePair.mParameter;
            ((HashMap)object).put(string, parameterValuePair.mValue);
        }
        return object;
    }

    public static void configureEnvironment(Environment environment) {
        AdpPushClient.configureEnvironment(environment, null);
    }

    public static void configureEnvironment(Environment object, String string) {
        if (context != null) {
            com.adpdigital.push.config.NZV nZV = com.adpdigital.push.config.MRR.NZV((Environment)((Object)object));
            if (nZV != null) {
                com.adpdigital.push.config.NZV nZV2 = nZV;
                String string2 = nZV2.NZV();
                String string3 = nZV2.AOP();
                String string4 = nZV2.YCE();
                AdpPushClient.init(nZV.MRR(), string2, string3, string4);
                chabokEnvironment = object;
                if (chabokEnvironment == null) {
                    AdpPushClient.get().setDevelopment(true);
                } else {
                    Environment environment = object;
                    object = AdpPushClient.get();
                    boolean bl = environment != Environment.PRODUCTION;
                    ((AdpPushClient)object).setDevelopment(bl);
                }
                AdpPushClient.get().setEnableRealtime(nZV.VMB());
                AdpPushClient.get().setConfiguration(nZV);
                object = AdpPushClient.get().getUserId();
                if (object != null) {
                    AdpPushClient.get().register((String)object);
                } else {
                    AdpPushClient.get().registerAsGuest(string);
                }
                return;
            }
            throw new IllegalStateException("AdpPushClient not initialized, Make sure to configure correct environment. Please see http://bit.ly/32x1Tsn");
        }
        throw new IllegalStateException("AdpPushClient is not initialized in this process " + RPN.NZV() + ". Make sure to call AdpPushClient.setApplicationContext(Context) first.");
    }

    private void setConfiguration(com.adpdigital.push.config.NZV nZV) {
        this.config = nZV;
    }

    private void login(String string, final String[] stringArray, final @Nullable Callback<String> callback) {
        Callback<String> callback2;
        Callback<String> callback3 = callback2;
        callback2 = new Callback<String>(){

            @Override
            public void onFailure(Throwable throwable) {
                Callback<String> callback2 = callback2.callback;
                if (callback2 != null) {
                    callback2.onFailure(throwable);
                }
            }

            @Override
            public void onSuccess(Object object) {
                String cfr_ignored_0 = (String)object;
                String[] stringArray2 = stringArray2.stringArray;
                stringArray2.AdpPushClient.this.addTag(stringArray2, stringArray2.callback);
            }
        };
        this.register(string, callback3);
    }

    private void login(String string, final HashMap<String, Object> hashMap, final @Nullable Callback<String> callback) {
        Callback<String> callback2;
        Callback<String> callback3 = callback2;
        callback2 = new Callback<String>(){

            @Override
            public void onFailure(Throwable throwable) {
                Callback<String> callback2 = callback2.callback;
                if (callback2 != null) {
                    callback2.onFailure(throwable);
                }
            }

            @Override
            public void onSuccess(Object object) {
                String cfr_ignored_0 = (String)object;
                WFM wFM = hashMap2;
                HashMap hashMap2 = wFM.hashMap;
                hashMap2.AdpPushClient.this.setUserAttributes(hashMap2, wFM.callback);
            }
        };
        this.register(string, callback3);
    }

    private void login(String string, final String string2, final JSONObject jSONObject, final @Nullable Callback<String> callback) {
        Callback<String> callback2;
        Callback<String> callback3 = callback2;
        callback2 = new Callback<String>(){

            @Override
            public void onFailure(Throwable throwable) {
                Callback<String> callback2 = callback2.callback;
                if (callback2 != null) {
                    callback2.onFailure(throwable);
                }
            }

            @Override
            public void onSuccess(Object object) {
                String cfr_ignored_0 = (String)object;
                ELX eLX = string;
                String string = eLX.string2;
                object = eLX.jSONObject;
                Callback callback2 = eLX.callback;
                string.AdpPushClient.this.track(string, (JSONObject)object, callback2);
            }
        };
        this.register(string, callback3);
    }

    private void login(String string, String object, final @Nullable Callback callback) {
        Callback<String> callback2;
        this.userHash = object;
        object = callback2;
        callback2 = new Callback<String>(){

            @Override
            public void onFailure(Throwable throwable) {
                Callback<String> callback2 = callback2.callback;
                if (callback2 != null) {
                    callback2.onFailure(throwable);
                }
            }

            @Override
            public void onSuccess(Object object) {
                QHG qHG = string;
                String string = (String)object;
                object = qHG.callback;
                if (object != null) {
                    object.onSuccess(string);
                }
            }
        };
        this.register(string, (Callback<String>)object);
    }

    private void logout(@Nullable Callback<String> callback) {
        this.registerAsGuest(callback);
    }

    static /* synthetic */ WeakReference access$002(AdpPushClient adpPushClient, WeakReference weakReference) {
        adpPushClient.currentActivity = weakReference;
        return weakReference;
    }

    static /* synthetic */ boolean access$102(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.isFreshStart = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1202(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.registering = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1802(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.restartServiceState = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1102(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.registeredOnce = bl;
        return bl;
    }

    static /* synthetic */ int access$2102(int n) {
        installationRetries = n;
        return installationRetries;
    }

    static /* synthetic */ Callback access$2200(AdpPushClient adpPushClient) {
        return adpPushClient.registerCallback;
    }

    static /* synthetic */ com.adpdigital.push.WFM access$2300(AdpPushClient adpPushClient) {
        return adpPushClient.userId;
    }

    static /* synthetic */ Callback access$2202(AdpPushClient adpPushClient, Callback callback) {
        adpPushClient.registerCallback = callback;
        return callback;
    }

    static /* synthetic */ void access$2600(AdpPushClient adpPushClient) {
        adpPushClient.getDeferredDeepLink();
    }

    static /* synthetic */ boolean access$2702(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient._isLoggedInNow = bl;
        return bl;
    }

    static /* synthetic */ boolean access$402(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.isNewInstall = bl;
        return bl;
    }

    static /* synthetic */ String access$2802(AdpPushClient adpPushClient, String string) {
        adpPushClient.userHash = string;
        return string;
    }

    static /* synthetic */ boolean access$2902(AdpPushClient adpPushClient, boolean bl) {
        adpPushClient.isLaunched = bl;
        return bl;
    }

    static /* synthetic */ void access$3000(AdpPushClient adpPushClient) {
        adpPushClient.retryRegistrationBackoff();
    }

    static {
        FORCE_STICKY = false;
        installationRetries = 0;
        tokenRetries = 0;
        notifs = new HUI<String>(200);
        pushClientInstance = null;
        tokenWorker = Executors.newSingleThreadScheduledExecutor();
    }

    public void onEvent(GcmMessage gcmMessage) {
        new StringBuilder().append("New GCM message (foreground:").append(this.isForeground()).append("): ");
        if (gcmMessage != null) {
            throw null;
        }
        throw null;
    }

    public void publish(PushMessage pushMessage, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!((AdpPushClient)((Object)throwable2)).isEnabledRealtime()) {
            return;
        }
        if (!pushMessage.getUser().contains("/") && !pushMessage.getChannel().contains("/")) {
            com.adpdigital.push.CVA.NZV(((AdpPushClient)((Object)throwable2)).getApplicationContext()).NZV(pushMessage, (Callback<Boolean>)callback);
            return;
        }
        if (callback != null) {
            Throwable throwable;
            Throwable throwable2 = throwable;
            throwable = new Throwable("Channel or user should not contain slashes");
            callback.onFailure(throwable2);
        }
    }

    public void publish(String string, String string2, Callback callback) {
        PushMessage pushMessage;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!((AdpPushClient)object).isEnabledRealtime()) {
            return;
        }
        if (string.contains("/")) {
            if (callback != null) {
                Throwable throwable;
                Object object = throwable;
                throwable = new Throwable("Channel should not contain slashes");
                callback.onFailure((Throwable)object);
            }
            return;
        }
        AdpPushClient adpPushClient = object;
        Object object = object = pushMessage;
        ((PushMessage)object)();
        ((ChabokMessage)object).setId(UUID.randomUUID().toString());
        ((PushMessage)object).setCreatedAt(System.currentTimeMillis());
        ((PushMessage)object).setBody(string2);
        pushMessage.setChannel(string);
        com.adpdigital.push.CVA.NZV(adpPushClient.getApplicationContext()).NZV((PushMessage)object, (Callback<Boolean>)callback);
    }

    public void publish(String string, String string2, String string3, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!((AdpPushClient)object).isEnabledRealtime()) {
            return;
        }
        if (!string2.contains("/") && !string.contains("/")) {
            PushMessage pushMessage;
            AdpPushClient adpPushClient = object;
            Object object = object = pushMessage;
            ((PushMessage)object)();
            ((ChabokMessage)object).setId(UUID.randomUUID().toString());
            ((PushMessage)object).setCreatedAt(System.currentTimeMillis());
            ((PushMessage)object).setBody(string3);
            ((ChabokMessage)object).setChannel(string2);
            pushMessage.setUser(string);
            com.adpdigital.push.CVA.NZV(adpPushClient.getApplicationContext()).NZV((PushMessage)object, (Callback<Boolean>)callback);
            return;
        }
        if (callback != null) {
            Throwable throwable;
            Object object = throwable;
            throwable = new Throwable("Channel or user should not contain slashes");
            callback.onFailure((Throwable)object);
        }
    }

    void publishMessageEvent(String string, String string2) {
        JSONObject jSONObject;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        AdpPushClient adpPushClient = adpPushClient2;
        AdpPushClient adpPushClient2 = jSONObject;
        jSONObject = new JSONObject();
        jSONObject.put("ts", System.currentTimeMillis());
        try {
            adpPushClient.emit(com.adpdigital.push.QHG.event, string, string2, (JSONObject)adpPushClient2, true, false);
        }
        catch (Exception exception) {
            IRK.NZV(TAG, "Couldnt publish message event " + string2, exception);
        }
    }

    public void publishEvent(String string, JSONObject jSONObject) {
        this.publishEvent(string, jSONObject, true, false);
    }

    public void publishEvent(String string, JSONObject jSONObject, boolean bl) {
        this.publishEvent(string, jSONObject, bl, false);
    }

    public void publishEvent(final String string, JSONObject object, final boolean bl, final boolean bl2) {
        block16: {
            JSONObject jSONObject;
            block18: {
                block15: {
                    boolean bl3;
                    block17: {
                        block13: {
                            block14: {
                                JSONObject jSONObject2;
                                if (AdpPushClient.isDisabledSdk()) {
                                    return;
                                }
                                if (string == null || string.isEmpty()) break block16;
                                if (object == null) {
                                    IRK.OJW(TAG, "data parameter is null. Please, provide a data");
                                    return;
                                }
                                jSONObject = jSONObject2;
                                jSONObject2 = new JSONObject();
                                if (!string.contentEquals("matchUserFeedback")) break block13;
                                if (AdpPushClient.get().getAppId().contentEquals("90-dev")) break block14;
                                if (!AdpPushClient.get().getAppId().contentEquals("90-demo")) break block13;
                            }
                            bl3 = true;
                            break block17;
                        }
                        bl3 = false;
                    }
                    if (string.contentEquals("geo") || bl3) break block15;
                    JSONObject jSONObject3 = jSONObject;
                    jSONObject3.put("id", (Object)UUID.randomUUID().toString());
                    jSONObject3.put("createdAt", System.currentTimeMillis());
                    jSONObject3.put("data", object);
                    break block18;
                }
                JSONObject jSONObject4 = object;
                jSONObject4.put("id", (Object)UUID.randomUUID().toString());
                try {
                    jSONObject4.put("createdAt", System.currentTimeMillis());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                jSONObject = object;
            }
            if (object2.getInstallationId() == null) {
                object2.eventBus.OJW(new Object(){

                    public void onEvent(ConnectionStatus object) {
                        if (object == ConnectionStatus.CONNECTED) {
                            NHW nHW = this;
                            AdpPushClient adpPushClient = nHW.AdpPushClient.this;
                            object = adpPushClient;
                            NHW nHW2 = this;
                            ConnectionStatus connectionStatus = object;
                            object = com.adpdigital.push.QHG.event;
                            String string3 = string;
                            String string2 = ((AdpPushClient)((Object)connectionStatus)).getInstallationId();
                            JSONObject jSONObject2 = nHW2.jSONObject;
                            boolean bl3 = nHW2.bl;
                            boolean bl22 = nHW2.bl2;
                            adpPushClient.emit((com.adpdigital.push.QHG)((Object)object), string3, string2, jSONObject2, bl3, bl22);
                            nHW.AdpPushClient.this.eventBus.HUI(this);
                        }
                    }
                });
                return;
            }
            AdpPushClient adpPushClient = object2;
            IRK.MRR(TAG, "publishEvent: sending data, event: " + string);
            Object object2 = com.adpdigital.push.QHG.event;
            object = adpPushClient.getInstallationId();
            adpPushClient.emit((com.adpdigital.push.QHG)((Object)object2), string, (String)object, jSONObject, bl, bl2);
            return;
        }
        IRK.OJW(TAG, "eventName parameter is null. Please, provide an eventName");
    }

    public void publishEvent(String string, Bundle bundle) {
        this.publishEvent(string, bundle, true, false);
    }

    public void publishEvent(String string, Bundle bundle, boolean bl) {
        this.publishEvent(string, bundle, bl, false);
    }

    public void publishEvent(final String string, Bundle object, final boolean bl, final boolean bl2) {
        block20: {
            JSONObject jSONObject;
            block22: {
                JSONObject jSONObject2;
                block19: {
                    boolean bl3;
                    block21: {
                        block17: {
                            block18: {
                                JSONObject jSONObject3;
                                if (AdpPushClient.isDisabledSdk()) {
                                    return;
                                }
                                if (string == null || string.isEmpty()) break block20;
                                if (object == null) {
                                    IRK.OJW(TAG, "data parameter is null. Please, provide a data");
                                    return;
                                }
                                Bundle bundle = object;
                                object = object2.prepareMetaData((Bundle)object);
                                jSONObject2 = DYH.NZV(bundle);
                                jSONObject = jSONObject3;
                                jSONObject3 = new JSONObject();
                                if (!string.contentEquals("matchUserFeedback")) break block17;
                                if (AdpPushClient.get().getAppId().contentEquals("90-dev")) break block18;
                                if (!AdpPushClient.get().getAppId().contentEquals("90-demo")) break block17;
                            }
                            bl3 = true;
                            break block21;
                        }
                        bl3 = false;
                    }
                    if (string.contentEquals("geo") || bl3) break block19;
                    JSONObject jSONObject4 = jSONObject;
                    jSONObject4.put("id", (Object)UUID.randomUUID().toString());
                    jSONObject4.put("createdAt", System.currentTimeMillis());
                    jSONObject4.put("data", (Object)jSONObject2);
                    if (object != null) {
                        jSONObject.put(META_DATA, object);
                    }
                    break block22;
                }
                JSONObject jSONObject5 = jSONObject2;
                jSONObject5.put("id", (Object)UUID.randomUUID().toString());
                try {
                    jSONObject5.put("createdAt", System.currentTimeMillis());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (object != null) {
                    jSONObject2.put(META_DATA, object);
                }
                jSONObject = jSONObject2;
            }
            if (object2.getInstallationId() == null) {
                object2.eventBus.OJW(new Object(){

                    public void onEvent(ConnectionStatus object) {
                        if (object == ConnectionStatus.CONNECTED) {
                            WGR wGR = this;
                            AdpPushClient adpPushClient = wGR.AdpPushClient.this;
                            object = adpPushClient;
                            WGR wGR2 = this;
                            ConnectionStatus connectionStatus = object;
                            object = com.adpdigital.push.QHG.event;
                            String string3 = string;
                            String string2 = ((AdpPushClient)((Object)connectionStatus)).getInstallationId();
                            JSONObject jSONObject2 = wGR2.jSONObject;
                            boolean bl3 = wGR2.bl;
                            boolean bl22 = wGR2.bl2;
                            adpPushClient.emit((com.adpdigital.push.QHG)((Object)object), string3, string2, jSONObject2, bl3, bl22);
                            wGR.AdpPushClient.this.eventBus.HUI(this);
                        }
                    }
                });
                return;
            }
            AdpPushClient adpPushClient = object2;
            IRK.MRR(TAG, "publishEvent: sending data, event: " + string);
            Object object2 = com.adpdigital.push.QHG.event;
            object = adpPushClient.getInstallationId();
            adpPushClient.emit((com.adpdigital.push.QHG)((Object)object2), string, (String)object, jSONObject, bl, bl2);
            return;
        }
        IRK.OJW(TAG, "eventName parameter is null. Please, provide an eventName");
    }

    @Deprecated
    public void publishBackground(String string, JSONObject jSONObject) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            ChabokCommunicateEvent chabokCommunicateEvent;
            JSONObject jSONObject2;
            JSONObject jSONObject3;
            block14: {
                block13: {
                    JSONObject jSONObject4;
                    JSONObject jSONObject5;
                    if (jSONObject == null) {
                        IRK.OJW(TAG, "data parameter is null. Please, provide a data");
                        return;
                    }
                    jSONObject3 = jSONObject5;
                    jSONObject5 = new JSONObject();
                    jSONObject2 = jSONObject4;
                    jSONObject4 = new JSONObject();
                    if (!string.equals("geo")) break block13;
                    jSONObject2 = jSONObject;
                    break block14;
                }
                jSONObject2.put("data", (Object)jSONObject);
            }
            AdpPushClient adpPushClient = chabokCommunicateEvent2;
            JSONObject jSONObject6 = jSONObject3;
            JSONObject jSONObject7 = jSONObject6;
            JSONObject jSONObject8 = jSONObject6;
            JSONObject jSONObject9 = jSONObject2;
            JSONObject jSONObject10 = jSONObject9;
            JSONObject jSONObject11 = jSONObject9;
            jSONObject9.put("eventName", (Object)string);
            jSONObject11.put("id", (Object)UUID.randomUUID().toString());
            jSONObject10.put("createdAt", System.currentTimeMillis());
            jSONObject7.put("type", 3);
            jSONObject8.put("data", (Object)jSONObject2);
            ChabokCommunicateEvent chabokCommunicateEvent2 = chabokCommunicateEvent;
            try {
                chabokCommunicateEvent = new ChabokCommunicateEvent(jSONObject3, ChabokCommunicateStatus.PublishInBackground);
                adpPushClient.eventBus.MRR(chabokCommunicateEvent2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return;
        }
        IRK.OJW(TAG, "eventName parameter is null. Please, provide an eventName");
    }

    public void getStatus(Callback<ConnectionStatus> callback) {
        if (!PushService.NZV(this.getApplicationContext())) {
            callback.onSuccess(ConnectionStatus.DISCONNECTED);
            return;
        }
        callback.onSuccess(com.adpdigital.push.CVA.NZV(this.getApplicationContext()).HUI());
    }

    public void setEnableAlertForNotSupportingGcm(boolean bl) {
        this.getSharedPreferences().edit().putBoolean("CHK_SHOW_DIALOG_FOR_NOT_SUPPORT_GCM", bl).apply();
    }

    public void subscribe(String string, Callback callback) {
        this.subscribe(string, false, callback);
    }

    public void subscribe(String string, boolean bl, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        if (!bl) {
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet2(Arrays.asList(this.channels));
            hashSet2.add(this.convertChannelName2OldConvention(string));
            DYH.NZV(this.getApplicationContext(), hashSet2);
            this.channels = ((AbstractCollection)hashSet).toArray(new String[hashSet.size()]);
            this.updateInstallation(new HashMap<String, Object>());
            if (string.startsWith("public/") || !string.startsWith("private/")) {
                ChabokFirebaseMessaging.subscribe(string);
            }
        }
        AdpPushClient adpPushClient = this;
        String string2 = string;
        adpPushClient.createOrUpdateNotificationChannel(string2, ChabokFirebaseMessaging.MRR(string2));
        com.adpdigital.push.CVA.NZV(adpPushClient.getApplicationContext()).NZV(string, bl, (Callback<String>)callback);
    }

    public void unsubscribe(String string, Callback callback) {
        HashSet<String> hashSet;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        HashSet<String> hashSet2 = hashSet;
        hashSet2(Arrays.asList(this.channels));
        hashSet2.remove(this.convertChannelName2OldConvention(string));
        DYH.NZV(this.getApplicationContext(), hashSet2);
        this.channels = ((AbstractCollection)hashSet).toArray(new String[hashSet.size()]);
        this.updateInstallation(new HashMap<String, Object>());
        if (string.startsWith("public/") || !string.startsWith("private/")) {
            ChabokFirebaseMessaging.unsubscribe(string);
        }
        if (this.hasNotificationChannel(string)) {
            this.deleteNotificationChannel(string);
        }
        com.adpdigital.push.CVA.NZV(this.getApplicationContext()).NZV(string, (Callback<Boolean>)callback);
    }

    public void updateNotificationSettings(String object, String object2, boolean bl) {
        block10: {
            HashMap hashMap;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            if (this.notificationSettings == null) {
                JSONObject jSONObject3;
                jSONObject2 = jSONObject3;
                jSONObject3 = new JSONObject();
                this.notificationSettings = jSONObject2;
            }
            AdpPushClient adpPushClient = this;
            jSONObject2 = jSONObject;
            jSONObject2();
            this.notificationSettings.remove((String)object);
            jSONObject.put("sound", object2);
            jSONObject.put("alert", bl);
            adpPushClient.notificationSettings.put((String)object, (Object)jSONObject2);
            SharedPreferences.Editor editor = adpPushClient.getSharedPreferences().edit();
            editor.putString("notificationSettings", this.notificationSettings.toString()).apply();
            object = hashMap;
            hashMap = new HashMap();
            object2 = adpPushClient.getNotificationSettings();
            if (object2 == null) break block10;
            ((HashMap)object).put("notificationSettings", object2);
        }
        try {
            this.updateInstallation((Map<String, Object>)object);
        }
        catch (JSONException jSONException) {
            IRK.NZV(TAG, jSONException.getMessage(), jSONException);
        }
    }

    public AdpPushClient addListener(Object object) {
        if (!this.eventBus.NZV(object)) {
            this.eventBus.OJW(object);
        }
        return this;
    }

    public AdpPushClient notify(Object object) {
        MRR.NZV.NZV.OJW oJW = this.eventBus;
        if (oJW != null) {
            oJW.MRR(object);
        }
        return this;
    }

    public AdpPushClient removeListener(Object object) {
        if (this.eventBus.NZV(object)) {
            this.eventBus.HUI(object);
        }
        return this;
    }

    public AdpPushClient setPushListener(Object object) {
        return this.addListener(object);
    }

    public AdpPushClient removePushListener(Object object) {
        return this.removeListener(object);
    }

    @Deprecated
    public void dismiss() {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        AdpPushClient adpPushClient = this;
        IRK.HUI(TAG, "Dismiss AdpPushClient");
        adpPushClient.eventBus.HUI(this);
        adpPushClient.getForegroundManager().removeListeners();
        adpPushClient.deferredDataListener = null;
        adpPushClient.onDeeplinkResponseListener = null;
    }

    void makeSubsDirty() {
        this.getSharedPreferences().edit().putBoolean("subscriptionDirty", true).apply();
    }

    public void onEvent(final DeviceToken deviceToken) {
        Object[] objectArray = new Object[2];
        Object object = objectArray;
        objectArray[0] = Thread.currentThread().getName();
        objectArray[1] = Thread.currentThread().getId();
        IRK.MRR(TAG, String.format(Locale.getDefault(), "DeviceToken onEvent called in `%s` Thread (%d)", (Object[])object));
        object = this.getInstallationModel();
        IRK.MRR(TAG, "on event DeviceToken " + deviceToken.MRR() + " ?== " + ((OJW)object).MRR());
        new AsyncTask<Void, Void, Boolean>((OJW)object){
            final /* synthetic */ OJW MRR;
            {
                this.MRR = oJW;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Boolean NZV() {
                NZV nZV = this;
                IRK.MRR(TAG, "onEvent(DeviceToken).doInBackground()");
                Object object = nZV.AdpPushClient.this._tokenLock;
                synchronized (object) {
                    block22: {
                        IRK.MRR(TAG, "_tokenLock acquired");
                        IRK.MRR(TAG, String.format(Locale.getDefault(), "DeviceToken doInBackground called in `%s` Thread (%d)", Thread.currentThread().getName(), Thread.currentThread().getId()));
                        if (nZV.deviceToken.NZV() != null) {
                            if (deviceToken.NZV().equalsIgnoreCase(ChabokFirebaseMessaging.class.getCanonicalName())) {
                                IRK.MRR(TAG, "token received from Firebase.onNewToken() method");
                                com.adpdigital.push.WFM wFM = com.adpdigital.push.WFM.NZV(AdpPushClient.this.getSharedPreferences().getString("deviceToken", null));
                                if (wFM.NZV() == null) {
                                    IRK.HUI(TAG, "GOT current token ~> null, don't update installation");
                                    IRK.MRR(TAG, "_tokenLock released");
                                    return false;
                                }
                                if (deviceToken.MRR().NZV().equalsIgnoreCase(wFM.NZV())) {
                                    IRK.HUI(TAG, "GOT same token, don't update installation");
                                    IRK.MRR(TAG, "_tokenLock released");
                                    return false;
                                }
                                if (AdpPushClient.this.isNewInstall) {
                                    IRK.HUI(TAG, "this is a new install, so installation dropped!");
                                    IRK.MRR(TAG, "_tokenLock released");
                                    return false;
                                }
                            } else {
                                IRK.MRR(TAG, "token received from Firebase.getInstanceId() method");
                            }
                        } else {
                            IRK.MRR(TAG, "token received from unknown callerId so ... we accept it!");
                        }
                        if (deviceToken == null || deviceToken.MRR().NZV() == null) break block22;
                        NZV nZV2 = this;
                        nZV2.MRR.NZV(deviceToken.MRR());
                        try {
                            if (nZV2.deviceToken.YCE() != null) {
                                this.MRR.HUI(deviceToken.YCE());
                            }
                            if (deviceToken.OJW() != null) {
                                this.MRR.NZV(deviceToken.OJW(), deviceToken.HUI());
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if ("SERVICE_NOT_AVAILABLE".equalsIgnoreCase(deviceToken.OJW())) {
                            NZV nZV3 = this;
                            IRK.OJW(TAG, "FCM:SERVICE_NOT_AVAILABLE ~> retryRegistrationBackoff...");
                            nZV3.AdpPushClient.this.retryGetTokenBackoff();
                            if (nZV3.deviceToken.XTU()) {
                                return false;
                            }
                        } else if (deviceToken.XTU()) {
                            IRK.XTU(TAG, "token force update!");
                            AdpPushClient.this.updateDeviceToken(deviceToken);
                            return false;
                        }
                        IRK.MRR(TAG, "_tokenLock released");
                        return true;
                    }
                    NZV nZV4 = this;
                    IRK.HUI(TAG, "token ~> null, now registering installation");
                    nZV4.MRR.NZV(com.adpdigital.push.WFM.NZV("---"));
                    nZV4.MRR.HUI("ERR");
                    nZV4.MRR.NZV("Token is null for unknown reason.", 200);
                    IRK.MRR(TAG, "_tokenLock released");
                    return true;
                }
            }

            protected void onPostExecute(Object object) {
                if (((Boolean)object).booleanValue()) {
                    NZV nZV = object2;
                    IRK.HUI(TAG, "Got token, now registering installation");
                    AdpPushClient adpPushClient = nZV.AdpPushClient.this;
                    Object object2 = object2.MRR;
                    adpPushClient.saveInstallation((OJW)object2, adpPushClient.restartServiceState);
                    AdpPushClient.access$1802(nZV.AdpPushClient.this, false);
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[]{null, null, null});
    }

    HashMap<String, HashMap> getNotificationSettings() {
        if (this.notificationSettings != null) {
            HashMap<String, HashMap> hashMap;
            HashMap<String, HashMap> hashMap2 = hashMap;
            hashMap = new HashMap<String, HashMap>();
            Iterator iterator = this.notificationSettings.keys();
            while (iterator.hasNext()) {
                HashMap<String, String> hashMap3;
                String string = (String)iterator.next();
                JSONObject jSONObject = this.notificationSettings.optJSONObject(string);
                HashMap<String, String> hashMap4 = hashMap3;
                hashMap4();
                hashMap4.put("alert", jSONObject.optString("alert", null));
                hashMap3.put("sound", jSONObject.optString("sound", null));
                hashMap2.put(string, hashMap4);
            }
            return hashMap2;
        }
        return null;
    }

    public String getClientVersion() {
        String string = XTU.NZV(context, this.getSharedPreferences().getString("clientVersion", null));
        if (string == null) {
            try {
                string = this.getApplicationContext().getPackageManager().getPackageInfo((String)AdpPushClient.context.getPackageName(), (int)0).versionName;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return string;
    }

    public void setClientVersion(String string) {
        this.getSharedPreferences().edit().putString("clientVersion", XTU.MRR(context, string)).apply();
    }

    public void incBadge() {
        if (AdpPushClient.get().isForeground()) {
            return;
        }
        AdpPushClient adpPushClient = this;
        adpPushClient.setBadge(adpPushClient.getSharedPreferences().getInt("androidBadge", 0) + 1);
    }

    boolean isBadgeEnabled() {
        block8: {
            block9: {
                if (context == null) break block8;
                Object object = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData;
                if (object == null) break block9;
                object = object.getString(USE_BADGE_COUNT);
                if (object == null) break block9;
                if (!((String)object).toLowerCase().equals("disable")) break block9;
                return false;
            }
            try {
                if (!ShortcutBadger.isBadgeCounterSupported((Context)context)) {
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                IRK.NZV(TAG, "isBadgeEnabled: NullPointerException -->", nullPointerException);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                IRK.NZV(TAG, "isBadgeEnabled: NameNotFoundException -->", nameNotFoundException);
            }
        }
        return true;
    }

    boolean isEnabledRealtime() {
        block19: {
            block18: {
                block16: {
                    block17: {
                        if (this.config == null) break block16;
                        if (this.config.VMB()) break block17;
                        String string = TAG;
                        Locale locale = Locale.getDefault();
                        Object[] objectArray = new Object[1];
                        objectArray[0] = this.config.OJW();
                        IRK.HUI(string, String.format(locale, "Chabok realtime is disabled. To enable set realtime in Chabok.%s.json file to true.", objectArray));
                        return false;
                    }
                    return true;
                }
                if (!this.getSharedPreferences().contains("CHK_DISABLE_REALTIME")) break block18;
                return this.getSharedPreferences().getBoolean("CHK_DISABLE_REALTIME", true) ^ true;
            }
            if (context == null) break block19;
            Bundle bundle = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData;
            if (bundle == null) break block19;
            if (!bundle.containsKey(DISABLE_REALTIME)) break block19;
            IRK.HUI(IRK.MRR, "com.adpdigital.push.client.DISABLE_REALTIME meta-data does not support anymore.");
            if (this.config == null) break block19;
            String string = IRK.MRR;
            Locale locale = Locale.getDefault();
            Object[] objectArray = new Object[1];
            try {
                objectArray[0] = this.config.OJW();
                IRK.HUI(string, String.format(locale, "For config realtime change it from Chabok.%s.json file.", objectArray));
            }
            catch (NullPointerException nullPointerException) {
                IRK.NZV(TAG, "isEnabledRealtime: NullPointerException -->", nullPointerException);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                IRK.NZV(TAG, "isEnabledRealtime: NameNotFoundException -->", nameNotFoundException);
            }
        }
        return true;
    }

    boolean isEnabledPushNotification() {
        com.adpdigital.push.config.NZV nZV = ((AdpPushClient)((Object)nZV)).config;
        if (nZV != null && !nZV.XTU()) {
            IRK.XTU(TAG, "Chabok push notification has been disabled in configuration.");
            return false;
        }
        return true;
    }

    @Deprecated
    public void setEnableRealtime(boolean bl) {
        SharedPreferences.Editor editor = ((AdpPushClient)((Object)string)).getSharedPreferences().edit();
        String string = "CHK_DISABLE_REALTIME";
        editor.putBoolean(string, bl ^ true).apply();
    }

    @Deprecated
    public boolean isChabokPushNotification(Bundle bundle) {
        return bundle != null && bundle.containsKey("fromChabok");
    }

    @Deprecated
    public boolean isChabokPushNotification(Map<String, String> map) {
        return map != null && map.containsKey("fromChabok");
    }

    boolean isAdvertisingIdEnabled() {
        block7: {
            if (context == null) break block7;
            Object object = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData;
            if (object == null) break block7;
            object = object.getString(ADVERTISING_ID_ENABLED);
            if (object == null) break block7;
            try {
                if (((String)object).toLowerCase().equals("disable")) {
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                IRK.NZV(TAG, "isAdvertisingIdEnabled: NullPointerException -->", nullPointerException);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                IRK.NZV(TAG, "isAdvertisingIdEnabled: NameNotFoundException -->", nameNotFoundException);
            }
        }
        return true;
    }

    int getDefaultNotificationIconIdFromMetadata() {
        block8: {
            int n;
            block10: {
                block9: {
                    if (context == null) break block8;
                    AdpPushClient adpPushClient = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData;
                    if (adpPushClient == null) break block8;
                    n = -1;
                    if (!adpPushClient.containsKey(FB_DEFAULT_NOTIFICATION_ICON)) break block9;
                    n = adpPushClient.getInt(FB_DEFAULT_NOTIFICATION_ICON);
                    if (n <= -1) break block9;
                    return n;
                }
                if (!adpPushClient.containsKey(CHABOK_DEFAULT_NOTIFICATION_ICON)) break block10;
                try {
                    n = adpPushClient.getInt(CHABOK_DEFAULT_NOTIFICATION_ICON);
                }
                catch (NullPointerException nullPointerException) {
                    IRK.NZV(TAG, "getDefaultNotificationIconFromMetadata: NullPointerException -->", nullPointerException);
                    break block8;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    IRK.NZV(TAG, "getDefaultNotificationIconFromMetadata: NameNotFoundException -->", nameNotFoundException);
                }
            }
            return n;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int getDefaultNotificationColorFromMetadata() {
        try {
            if (context == null) return -1;
            AdpPushClient adpPushClient = AdpPushClient.context.getPackageManager().getApplicationInfo((String)AdpPushClient.context.getPackageName(), (int)128).metaData;
            if (adpPushClient == null) return -1;
            int n = -1;
            if (adpPushClient.containsKey(FB_DEFAULT_NOTIFICATION_COLOR) && (n = adpPushClient.getInt(FB_DEFAULT_NOTIFICATION_COLOR)) > -1) {
                return context.getResources().getColor(n);
            }
            if (!adpPushClient.containsKey(CHABOK_DEFAULT_NOTIFICATION_COLOR)) return context.getResources().getColor(n);
            n = adpPushClient.getInt(CHABOK_DEFAULT_NOTIFICATION_COLOR);
            return context.getResources().getColor(n);
        }
        catch (Exception exception) {
            IRK.NZV(TAG, "getDefaultNotificationColorFromMetadata: Exception -->", exception);
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            IRK.NZV(TAG, "getDefaultNotificationColorFromMetadata: NullPointerException -->", nullPointerException);
            return -1;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            IRK.NZV(TAG, "getDefaultNotificationColorFromMetadata: NameNotFoundException -->", nameNotFoundException);
        }
        return -1;
    }

    public int getAppLaunchCount() {
        return this.getSharedPreferences().getInt(APPLICATION_LAUNCH, 0);
    }

    public long getAppLaunchTime() {
        long l = System.currentTimeMillis();
        return this.getSharedPreferences().getLong(APPLICATION_LAUNCH_TS, l);
    }

    public long getLastAppLaunchTime() {
        return this.lastLaunchTime;
    }

    public com.adpdigital.push.WFM getReregisteredFrom() {
        return DYH.NZV(this.getApplicationContext(), "72657265676973746572656446726f6d");
    }

    public int getBadge() {
        return this.getSharedPreferences().getInt("androidBadge", 0);
    }

    AdpPushClient setBadge(int n) {
        AdpPushClient adpPushClient = this;
        adpPushClient.getSharedPreferences().edit().putInt("androidBadge", n).apply();
        adpPushClient.eventBus.MRR(new BadgeUpdate(n));
        if (adpPushClient.isBadgeEnabled() && !ShortcutBadger.applyCount((Context)this.getApplicationContext(), (int)n)) {
            IRK.HUI(TAG, "Could not apply the badge " + n);
        }
        return this;
    }

    public AdpPushClient resetBadge() {
        AdpPushClient adpPushClient = this;
        ((NotificationManager)adpPushClient.getApplicationContext().getSystemService("notification")).cancelAll();
        SharedPreferences.Editor editor = adpPushClient.getSharedPreferences().edit();
        editor.putInt("androidUnseenBadge", 0);
        editor.apply();
        return adpPushClient.setBadge(0);
    }

    public String getInstallationId() {
        if ((this = XTU.NZV(context, ((AdpPushClient)this).getSharedPreferences().getString("installationId", null))) != null) {
            try {
                return (String)new JSONArray((String)this).get(0);
            }
            catch (JSONException jSONException) {
                IRK.NZV(TAG, "Cannot parse installation id '" + (String)this + "'", jSONException);
            }
        }
        return null;
    }

    public void requestVerificationCode(String string, String string2, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        NZV.NZV.XTU.NZV(string, this.appId, string2, callback);
    }

    public void requestVerificationCode(String string, Callback callback) {
        this.requestCode(string, callback);
    }

    public void verifyUserCode(String string, String string2, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("userId", string);
        hashMap.put("code", string2);
        NZV.NZV.XTU.NZV(string, string2, callback);
    }

    boolean isFreshStart() {
        return this.isFreshStart;
    }

    public boolean isForeground() {
        return this.getForegroundManager().isForeground();
    }

    public boolean isFocused() {
        return this.isForeground() && AdpPushClient.getActivityClass(this.getApplicationContext()).getName().equals(this.getForegroundManager().getActiveActivityClassName());
    }

    public boolean isBackground() {
        return this.getForegroundManager().isBackground();
    }

    public AdpPushClient addAppListener(AppListener appListener) {
        AdpPushClient adpPushClient = this;
        adpPushClient.getForegroundManager().addListener(appListener);
        return adpPushClient;
    }

    public Class getActivityClass() {
        return activityClass;
    }

    public String getUserId() {
        return this.getSecureUserId().NZV();
    }

    public void setAutoResetBadge(boolean bl) {
        this.getSharedPreferences().edit().putBoolean("CHK_AUTO_RESET_BADGE", bl).apply();
    }

    public boolean isAutoResetBadge() {
        return this.getSharedPreferences().getBoolean("CHK_AUTO_RESET_BADGE", true);
    }

    public boolean isRegistered() {
        return this.getSharedPreferences().getString("installationId", null) != null;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getNotificationIcon() {
        int n = adpPushClient3.notificationIcon;
        if (n == -1) {
            block5: {
                try {
                    n = adpPushClient3.getDefaultNotificationIconIdFromMetadata();
                    if (n <= -1) break block5;
                    return n;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return -1;
                }
            }
            AdpPushClient adpPushClient = adpPushClient3;
            AdpPushClient adpPushClient2 = adpPushClient;
            AdpPushClient adpPushClient3 = adpPushClient.getApplicationContext().getPackageManager().getPackageInfo(adpPushClient3.getApplicationContext().getPackageName(), 0);
            return adpPushClient2.getApplicationContext().getPackageManager().getApplicationInfo((String)((PackageInfo)adpPushClient3).packageName, (int)0).icon;
        }
        return n;
    }

    public void setNotificationIcon(int n) {
        this.notificationIcon = n;
    }

    public int getNotificationIconSilhouette() {
        int n = this.notificationIconSilhouette;
        if (n == -1) {
            return this.getNotificationIcon();
        }
        return n;
    }

    public void setNotificationIconSilhouette(int n) {
        this.notificationIconSilhouette = n;
    }

    public boolean isLoggedIn() {
        return this.isGuestUser() ^ true;
    }

    public void unsetUserAttribute(String string) {
        String[] stringArray = stringArray3;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = string;
        stringArray.unsetUserAttributes(stringArray3);
    }

    public void unsetUserAttributes(String[] stringArray) {
        block7: {
            HashMap hashMap;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            if (AdpPushClient.isDisabledSdk()) {
                return;
            }
            if (stringArray == null || stringArray.length == 0) break block7;
            JSONObject jSONObject3 = jSONObject2;
            jSONObject2 = new JSONObject();
            JSONObject jSONObject4 = jSONObject;
            jSONObject = new JSONObject();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                jSONObject4.put(stringArray[i], (Object)new JSONObject().put("operation", (Object)"unset"));
            }
            try {
                jSONObject3.put("keys", (Object)jSONObject4);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            AdpPushClient adpPushClient = hashMap2;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            adpPushClient.setUserAttributesInternal(hashMap2, jSONObject3, null);
            return;
        }
        IRK.OJW(TAG, "attribute keys parameter should has a value.");
    }

    public void addToUserAttributeArray(String string, String string2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new String[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        super.addToUserAttributeArrayInternal(string, objectArray3, null);
    }

    public void addToUserAttributeArray(String string, String[] stringArray) {
        this.addToUserAttributeArrayInternal(string, stringArray, null);
    }

    public void removeFromUserAttributeArray(String string, String string2) {
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new String[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string2;
        super.removeFromUserAttributeArrayInternal(string, objectArray3, null);
    }

    public void removeFromUserAttributeArray(String string, String[] stringArray) {
        this.removeFromUserAttributeArrayInternal(string, stringArray, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, Object> getUserAttributes() {
        try {
            String string = ((AdpPushClient)((Object)string)).getSharedPreferences().getString("CHK_USER_INFO", null);
            if (string == null) return null;
            return (HashMap)DYH.NZV((Object)new JSONObject(XTU.NZV(context, string)));
        }
        catch (Exception exception) {
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
        exception.printStackTrace();
        return null;
    }

    public void setUserAttributes(Bundle bundle) {
        this.setUserAttributes(bundle, null);
    }

    public void setUserAttributes(HashMap<String, Object> hashMap) {
        this.setUserAttributes(hashMap, null);
    }

    public void incrementUserAttribute(String string) {
        this.incrementUserAttribute(string, 1.0, null);
    }

    public void incrementUserAttribute(String string, double d) {
        HashMap hashMap;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string == null) {
            IRK.OJW(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }
        AdpPushClient adpPushClient = hashMap2;
        HashMap<String, Double> hashMap2 = hashMap;
        hashMap2();
        hashMap.put(string, d);
        adpPushClient.incrementUserAttribute(hashMap2, null);
    }

    public void incrementUserAttribute(ArrayList<String> arrayList) {
        this.incrementUserAttribute(arrayList, null);
    }

    public void incrementUserAttribute(HashMap<String, Double> hashMap) {
        this.incrementUserAttribute(hashMap, null);
    }

    public void decrementUserAttribute(String string) {
        this.incrementUserAttribute(string, -1.0, null);
    }

    public void decrementUserAttribute(String string, double d) {
        HashMap hashMap;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string == null) {
            IRK.OJW(TAG, "attributeName is null. Please provide an attributeName");
            return;
        }
        AdpPushClient adpPushClient = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap2();
        hashMap.put(string, -d);
        adpPushClient.incrementUserAttribute(hashMap, null);
    }

    public void decrementUserAttribute(ArrayList<String> arrayList) {
        this.decrementUserAttribute(arrayList, null);
    }

    public void decrementUserAttribute(HashMap<String, Double> hashMap) {
        this.decrementUserAttribute(hashMap, null);
    }

    @Deprecated
    public AdpPushClient setDevelopment(boolean bl) {
        if (AdpPushClient.isDisabledSdk()) {
            return pushClientInstance;
        }
        AdpPushClient adpPushClient = this;
        adpPushClient.useDev = bl;
        adpPushClient.getSharedPreferences().edit().putBoolean("useDev", this.useDev).apply();
        adpPushClient.initializeAdapter();
        return adpPushClient;
    }

    public void setDefaultNotificationChannel(String string) {
        String string2 = "default";
        if (Build.VERSION.SDK_INT >= 26) {
            this.createOrUpdateNotificationChannel(string2, string);
        }
    }

    void createOrUpdateNotificationChannel(String string, String string2) {
        if (Build.VERSION.SDK_INT >= 26) {
            new IZX(string, this.getApplicationContext()).MRR(string2).NZV();
        }
    }

    void deleteNotificationChannel(String string) {
        AdpPushClient adpPushClient = (NotificationManager)adpPushClient.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            if (adpPushClient != null) {
                adpPushClient.deleteNotificationChannel(string);
            }
        } else {
            IRK.MRR(TAG, "Couldn't delete notification channel, because is require api level 26");
        }
    }

    boolean hasNotificationChannel(String string) {
        if (string == null) {
            return false;
        }
        AdpPushClient adpPushClient = (NotificationManager)adpPushClient.getApplicationContext().getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && adpPushClient != null) {
            return adpPushClient.getNotificationChannel(string) != null;
        }
        return false;
    }

    public AdpPushClient setSticky(boolean bl) {
        FORCE_STICKY = bl;
        return this;
    }

    public void subscribeEvent(String string, Callback callback) {
        this.subscribeEvent(string, "+", false, callback);
    }

    public void subscribeEvent(String string, boolean bl, Callback callback) {
        this.subscribeEvent(string, "+", bl, callback);
    }

    public void subscribeEvent(String string, String string2, Callback callback) {
        this.subscribeEvent(string, string2, false, callback);
    }

    public void subscribeEvent(String string, String string2, boolean bl, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        com.adpdigital.push.CVA.NZV(this.getApplicationContext()).NZV(string, string2, bl, callback);
    }

    public void unsubscribeEvent(String string, Callback callback) {
        this.unsubscribeEvent(string, "+", callback);
    }

    public void unsubscribeEvent(String string, String string2, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (!this.isEnabledRealtime()) {
            return;
        }
        com.adpdigital.push.CVA.NZV(this.getApplicationContext()).NZV(string, string2, (Callback<String>)callback);
    }

    public void track(String string) {
        this.track(string, (Bundle)null);
    }

    public void track(String string, Bundle bundle) {
        this.track(string, bundle, null);
    }

    public void track(String string, JSONObject jSONObject) {
        this.track(string, jSONObject, null);
    }

    public void trackPurchase(String string, ChabokEvent object) {
        JSONObject jSONObject;
        block12: {
            block11: {
                JSONObject jSONObject2;
                if (object == null) {
                    IRK.OJW(TAG, "chabokEvent is null, please provide a revenue");
                    return;
                }
                if (((ChabokEvent)object).revenue < 0.0) {
                    IRK.OJW(TAG, "Could not track event, Invalid amount");
                }
                new JSONObject();
                jSONObject = jSONObject2;
                jSONObject2 = new JSONObject();
                if (((ChabokEvent)object).data == null) break block11;
                jSONObject = ((ChabokEvent)object).data;
            }
            ChabokEvent chabokEvent = object;
            JSONObject jSONObject3 = jSONObject;
            ChabokEvent chabokEvent2 = object;
            jSONObject.put("isRevenue", true);
            String string2 = "value";
            jSONObject3.put(string2, (Object)chabokEvent2.revenue);
            if (chabokEvent.currency == null) break block12;
            ChabokEvent chabokEvent3 = object;
            object = "currency";
            jSONObject.put((String)object, (Object)chabokEvent3.currency);
        }
        try {
            this.trackInternal(string, jSONObject, this.prepareMetaData(jSONObject));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void trackRevenue(double d) {
        ChabokEvent chabokEvent;
        AdpPushClient adpPushClient = chabokEvent2;
        ChabokEvent chabokEvent2 = chabokEvent;
        chabokEvent = new ChabokEvent(d);
        adpPushClient.trackPurchase("Purchase", chabokEvent2);
    }

    void publishClientEvents(String string, JSONArray jSONArray) {
        JSONObject jSONObject;
        final JSONObject jSONObject2 = jSONObject;
        new JSONObject().put("id", (Object)string);
        try {
            jSONObject2.put("createdAt", System.currentTimeMillis());
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (jSONArray != null) {
            jSONObject2.put("eventData", (Object)jSONArray);
        }
        if (object.getInstallationId() == null) {
            object.eventBus.OJW(new Object(){

                public void onEvent(ConnectionStatus enum_) {
                    if (enum_ == ConnectionStatus.CONNECTED) {
                        QHM qHM = this;
                        AdpPushClient adpPushClient = qHM.AdpPushClient.this;
                        enum_ = com.adpdigital.push.QHG.event;
                        String string = adpPushClient.getInstallationId();
                        JSONObject jSONObject = jSONObject2;
                        adpPushClient.emit((com.adpdigital.push.QHG)enum_, "clientEvent", string, jSONObject, true, false);
                        qHM.AdpPushClient.this.eventBus.HUI(this);
                    }
                }
            });
            return;
        }
        AdpPushClient adpPushClient = object;
        IRK.MRR(TAG, "-- Publish cached data " + jSONArray);
        Object object = com.adpdigital.push.QHG.event;
        string = adpPushClient.getInstallationId();
        adpPushClient.emit((com.adpdigital.push.QHG)((Object)object), "clientEvent", string, jSONObject2, true, false);
    }

    public AdpPushClient enableDeliveryTopic() {
        AdpPushClient adpPushClient = this;
        adpPushClient.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", true).apply();
        return adpPushClient;
    }

    public AdpPushClient disableDeliveryTopic() {
        AdpPushClient adpPushClient = this;
        adpPushClient.getSharedPreferences().edit().putBoolean("deliveryTopicEnabled", false).apply();
        return adpPushClient;
    }

    public boolean deliveryTopicEnabled() {
        return this.getSharedPreferences().getBoolean("deliveryTopicEnabled", false);
    }

    public String[] getSubscriptions() {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        String[] stringArray = this.channels;
        int n = this.channels.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.add(this.convertChannelName2newConvention(stringArray[i]));
        }
        ArrayList<String> arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    SharedPreferences getSharedPreferences() {
        return DYH.VMB(this.getApplicationContext());
    }

    public AdpPushClient setCurrentActivity(Activity activity) {
        AdpPushClient.get().currentActivity = new WeakReference<Activity>(activity);
        return this;
    }

    void notifyNewMessage(PushMessage objectArray) {
        final Class clazz = activityClass;
        if (AdpPushClient.hasNotified(objectArray.getId())) {
            return;
        }
        Iterator<NotificationHandler> iterator = ((AdpPushClient)((Object)executor)).handlers.iterator();
        while (iterator.hasNext()) {
            Class clazz2 = iterator.next().getActivityClass(new ChabokNotification((PushMessage)objectArray, 0));
            if (clazz2 == null) {
                clazz2 = clazz;
            }
            clazz = clazz2;
        }
        AsyncTask<Void, Void, Boolean> asyncTask = new AsyncTask<Void, Void, Boolean>((PushMessage)objectArray){
            final /* synthetic */ PushMessage MRR;
            {
                this.MRR = pushMessage;
            }

            protected void onPostExecute(Object object) {
                Boolean bl = (Boolean)object;
                IRK.MRR(IRK.MRR, "~~> Finish showing notification in background");
                super.onPostExecute((Object)bl);
            }

            protected Object doInBackground(Object[] objectArray) {
                Void[] cfr_ignored_0 = (Void[])objectArray;
                IRK.MRR(IRK.MRR, "~~> Start showing notification in background");
                ChabokFirebaseMessaging.sendNotification(AdpPushClient.this.getApplicationContext(), clazz, new ChabokNotification(this.MRR, 0));
                return true;
            }
        };
        Executor executor = AsyncTask.THREAD_POOL_EXECUTOR;
        Object[] objectArray2 = new Void[3];
        objectArray = objectArray2;
        objectArray2[0] = null;
        objectArray2[1] = null;
        objectArray2[2] = null;
        asyncTask.executeOnExecutor(executor, objectArray);
    }

    boolean addNotifiedMessage(String string) {
        HashSet<String> hashSet;
        boolean bl = notifs.add(string);
        SharedPreferences.Editor editor = ((AdpPushClient)((Object)hashSet2)).getSharedPreferences().edit();
        HashSet<String> hashSet2 = hashSet;
        Collection<String> collection = notifs;
        hashSet = new HashSet<String>(Arrays.asList(collection.toArray(new String[collection.size()])));
        editor.putStringSet("notifs", (Set)hashSet2).apply();
        return bl;
    }

    Class getNotifActivityClass(Bundle bundle) throws ClassNotFoundException {
        Object object = activityClass;
        String string = bundle.getString("title");
        if (string == null) {
            string = bundle.getString("messageFrom");
        }
        Iterator<NotificationHandler> iterator = ((AdpPushClient)((Object)iterator)).handlers.iterator();
        while (iterator.hasNext()) {
            Bundle bundle2 = bundle;
            Object object2 = bundle2.getString("messageId");
            String string2 = bundle2.getString("message");
            int n = Integer.valueOf(bundle2.getString("androidBadge", "0"));
            object2 = ((NotificationHandler)iterator.next()).getActivityClass(new ChabokNotification((String)object2, string, string2, n, bundle));
            if (object2 == null) {
                object2 = object;
            }
            object = object2;
        }
        return object;
    }

    boolean notificationOpened(Bundle object, ChabokNotificationAction chabokNotificationAction) {
        ChabokNotification chabokNotification;
        ((AdpPushClient)((Object)chabokNotification2)).lastNotificationAction = chabokNotificationAction;
        String string = object.getString("title");
        boolean bl = true;
        if (string == null) {
            string = object.getString("messageFrom");
        }
        AdpPushClient adpPushClient = chabokNotification2;
        ChabokNotification chabokNotification2 = chabokNotification;
        Bundle bundle = object;
        String string2 = bundle.getString("messageId");
        String string3 = bundle.getString("message");
        int n = Integer.valueOf(bundle.getString("androidBadge", "0"));
        adpPushClient.lastNotificationData = new ChabokNotification(string2, string, string3, n, (Bundle)object);
        object = adpPushClient.handlers.iterator();
        while (object.hasNext()) {
            bl = ((NotificationHandler)object.next()).notificationOpened(chabokNotification2, chabokNotificationAction);
        }
        return bl;
    }

    public ChabokNotificationAction getLastNotificationAction() {
        return this.lastNotificationAction;
    }

    public ChabokNotification getLastNotificationData() {
        return this.lastNotificationData;
    }

    public boolean prepareNotification(ChabokNotification chabokNotification, NotificationCompat.Builder builder) {
        boolean bl = true;
        Iterator<NotificationHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            bl &= iterator.next().buildNotification(chabokNotification, builder);
        }
        return bl;
    }

    public void addNotificationHandler(NotificationHandler notificationHandler) {
        this.handlers.add(notificationHandler);
    }

    void launchSingleTaskUri(String string, String string2) {
        Intent intent;
        block8: {
            if (string.contains("://")) break block8;
            string = "http://" + string;
        }
        AdpPushClient adpPushClient = intent;
        String string3 = string;
        AdpPushClient adpPushClient2 = adpPushClient;
        adpPushClient2("android.intent.action.VIEW");
        adpPushClient2.addFlags(0x10020000);
        intent.setData(Uri.parse((String)string3));
        String string4 = IRK.MRR;
        try {
            IRK.MRR(string4, string2 + " " + string);
            context.startActivity((Intent)adpPushClient);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Deprecated
    public void setOnDeeplinkResponseListener(OnDeeplinkResponseListener onDeeplinkResponseListener) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.onDeeplinkResponseListener = onDeeplinkResponseListener;
    }

    public void setDeferredDataListener(DeferredDataListener deferredDataListener) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        this.deferredDataListener = deferredDataListener;
    }

    public void appWillOpenUrl(Uri object) {
        if (object != null && !object.toString().trim().isEmpty()) {
            ChabokCommunicateEvent chabokCommunicateEvent;
            JSONObject jSONObject;
            AdpPushClient adpPushClient = adpPushClient2;
            long l = System.currentTimeMillis();
            AdpPushClient adpPushClient2 = jSONObject;
            Uri uri = object;
            AdpPushClient adpPushClient3 = adpPushClient2;
            adpPushClient3();
            adpPushClient3.put("type", 0);
            adpPushClient3.put("deepLinkClickTs", l);
            object = "deepLinkUrl";
            jSONObject.put((String)object, (Object)uri.toString());
            object = chabokCommunicateEvent;
            try {
                chabokCommunicateEvent = new ChabokCommunicateEvent((JSONObject)adpPushClient2, ChabokCommunicateStatus.GotDeepLink);
                adpPushClient.eventBus.MRR(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        IRK.MRR(TAG, "Deeplink url is not vaild!!");
    }

    public boolean hasProtectedAppSupport() {
        return !TextUtils.isEmpty((CharSequence)(this = ((AdpPushClient)this).getDeviceManufacturer().toLowerCase())) && (((String)this).contains("huawei") || ((String)this).contains("xiaomi"));
    }

    public void showProtectedAppSettings(Activity activity, String string, String string2, String object) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = "\u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647";
        }
        if (object == null || object.isEmpty()) {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = string;
            object = String.format("\u0628\u0631\u0646\u0627\u0645\u0647 %s \u0628\u0631\u0627\u06cc \u06a9\u0627\u0631\u06a9\u0631\u062f \u062f\u0631\u0633\u062a \u0645\u06cc\u200c\u0628\u0627\u06cc\u0633\u062a \u062f\u0631 \u0644\u06cc\u0633\u062a \u0628\u0631\u0646\u0627\u0645\u0647\u200c\u0647\u0627\u06cc \u0645\u062d\u0627\u0641\u0638\u062a \u0634\u062f\u0647 \u0641\u0639\u0627\u0644 \u0634\u0648\u062f.%n", object);
        }
        this.showGuide(activity, string2, (String)object);
    }

    boolean shouldBeSticky() {
        if (FORCE_STICKY) {
            return true;
        }
        return this.isPlayServicesSupported() ^ true;
    }

    public boolean isPlayServicesSupported() {
        Context context = ((AdpPushClient)((Object)string)).getApplicationContext();
        String string = XTU.NZV("6e6f47434d");
        return DYH.VMB(context).getBoolean(string, false) ^ true;
    }

    public void addTag(String string, Callback callback) {
        if (stringArray3.userId.NZV() == null) {
            IRK.OJW(TAG, "userId not initialized yet");
            callback.onFailure(new Throwable("userId not initialized yet"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            IRK.OJW(TAG, "addTag: tag is empty");
            callback.onFailure(new Throwable("addTag: tag is empty"));
            return;
        }
        String[] stringArray = stringArray3;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = string;
        stringArray.addTag(stringArray3, callback);
    }

    public void addTag(String[] object, Callback callback) {
        Object object2;
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (((AdpPushClient)object2).userId.NZV() == null) {
            object2 = "userId not initialized yet";
            IRK.OJW(TAG, (String)object2);
            if (callback != null) {
                Throwable throwable;
                object = throwable;
                throwable = new Throwable((String)object2);
                callback.onFailure((Throwable)object);
            }
            return;
        }
        int n = ((String[])object).length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.isEmpty((CharSequence)object[i])) continue;
            object2 = "addTags: tag is empty";
            IRK.OJW(TAG, (String)object2);
            if (callback != null) {
                Throwable throwable;
                object = throwable;
                throwable = new Throwable((String)object2);
                callback.onFailure((Throwable)object);
            }
            return;
        }
        NZV.NZV.XTU.NZV(((AdpPushClient)object2).userId, object, callback);
    }

    public void removeTag(String string, Callback callback) {
        if (stringArray3.userId.NZV() == null) {
            IRK.OJW(TAG, "userId not initialized yet");
            callback.onFailure(new Throwable("userId not initialized yet"));
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            IRK.OJW(TAG, "removeTag: tag is empty");
            callback.onFailure(new Throwable("removeTag: tag is empty"));
            return;
        }
        String[] stringArray = stringArray3;
        String[] stringArray2 = new String[1];
        String[] stringArray3 = stringArray2;
        stringArray2[0] = string;
        stringArray.removeTag(stringArray3, callback);
    }

    public void removeTag(String[] stringArray, Callback callback) {
        if (AdpPushClient.isDisabledSdk()) {
            return;
        }
        if (this.userId.NZV() == null) {
            IRK.OJW(TAG, "userId not initialized yet");
            callback.onFailure(new Throwable("userId not initialized yet"));
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!TextUtils.isEmpty((CharSequence)stringArray[i])) continue;
            IRK.OJW(TAG, "removeTag: tag is empty");
            callback.onFailure(new Throwable("removeTag: tag is empty"));
            return;
        }
        NZV.NZV.XTU.MRR(this.userId, stringArray, callback);
    }

    void sendEventData(JSONArray jSONArray, Callback callback) {
        if (jSONArray == null) {
            IRK.OJW(TAG, "Please provide a data parameter");
            callback.onFailure(new Throwable("Please provide a data parameter"));
            return;
        }
        if (AdpPushClient.get().getInstallationId() == null) {
            IRK.OJW(TAG, "Not initialized yet to send fallback event...");
            callback.onFailure(new Throwable("Not initialized yet to send fallback event..."));
            return;
        }
        IRK.MRR(TAG, "-- Sending eventData");
        NZV.NZV.XTU.NZV(this.getSecureUserId(), this.getInstallationId(), jSONArray, callback);
    }

    boolean hasInstallReferrerData() {
        return this.getSharedPreferences().contains("CHK_INSTALL_REFERRER") && this.getSharedPreferences().contains("CHK_INSTALL_REF_CLICK_TS_L") && this.getSharedPreferences().contains("CHK_INSTALL_REF_BEGIN_TS_L");
    }

    String getInstallReferrer() {
        if ((this = ((AdpPushClient)this).getSharedPreferences().getString("CHK_INSTALL_REFERRER", null)) == null) {
            return null;
        }
        return XTU.NZV(context, (String)this);
    }

    long getInstallReferrerClickTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_INSTALL_REF_CLICK_TS_L", 0L);
        }
        catch (NumberFormatException numberFormatException) {
            IRK.NZV("AdpPushLibrary", "Exception happen to get ReferrerClickTimestampSeconds", numberFormatException);
            return 0L;
        }
    }

    long getInstallReferrerInstallBeginTs() {
        try {
            return this.getSharedPreferences().getLong("CHK_INSTALL_REF_BEGIN_TS_L", 0L);
        }
        catch (NumberFormatException numberFormatException) {
            IRK.NZV("AdpPushLibrary", "Exception happen to get InstallBeginTimestampSeconds", numberFormatException);
            return 0L;
        }
    }

    void getApplicationInstallReferrer() {
        new com.adpdigital.push.QHM(context, new VLN(){

            public void NZV(String string, long l, long l2) {
                if (string == null) {
                    return;
                }
                if (AdpPushClient.this.hasInstallReferrerData() && l == AdpPushClient.this.getInstallReferrerClickTs() && l2 == AdpPushClient.this.getInstallReferrerInstallBeginTs() && string.equals(AdpPushClient.this.getInstallReferrer())) {
                    return;
                }
                CVA cVA = this;
                cVA.AdpPushClient.this.getSharedPreferences().edit().putString("CHK_INSTALL_REFERRER", XTU.MRR(context, string)).apply();
                cVA.AdpPushClient.this.getSharedPreferences().edit().putLong("CHK_INSTALL_REF_CLICK_TS_L", l).apply();
                cVA.AdpPushClient.this.getSharedPreferences().edit().putLong("CHK_INSTALL_REF_BEGIN_TS_L", l2).apply();
            }
        });
    }

    void sendInstallReferrer(String string, Context context) {
        long l = System.currentTimeMillis();
        if (string != null && string.length() != 0) {
            AdpPushClient adpPushClient = this;
            AdpPushClient.context = context;
            adpPushClient.getSharedPreferences().edit().putString("CHK_RAW_INSTALL_REFERRER", XTU.MRR(context, string)).apply();
            adpPushClient.getSharedPreferences().edit().putLong("CHK_RAW_INSTALL_REF_CLICK_TS_L", l).apply();
            return;
        }
    }

    public void login(String string) {
        this.register(string);
    }

    public void login(String string, @Nullable Callback<String> callback) {
        this.register(string, callback);
    }

    public void login(String string, String[] stringArray) {
        this.login(string, stringArray, null);
    }

    public void login(String string, HashMap<String, Object> hashMap) {
        this.login(string, hashMap, null);
    }

    public void login(String string, String string2, JSONObject jSONObject) {
        this.login(string, string2, jSONObject, null);
    }

    public void login(String string, String string2) {
        this.userHash = string2;
        this.register(string);
    }

    public void logout() {
        this.logout(null);
    }
}

