package com.network;

import com.adpdigital.push.Logger;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;

public class HttpRequestHandler {

    private static String TAG = HttpRequestHandler.class.getName();
    private final int TIMEOUT = 60000;
    private int responseCode = 0;
    private HashMap<String,String> requestHeaders = new HashMap<>();

    void sendHttpRequest(final HttpRequestType requestType, final String params,
                         HashMap<String,String> requestHeaders, String api,
                         final com.adpdigital.push.Callback callback) {

        if(requestType == HttpRequestType.GET) {
            api = NetworkUtils.getUrlBuilder(api,params);
        }

        final URL url = NetworkUtils.urlGenerator(api);
        this.requestHeaders = requestHeaders;

        if(url != null) {
            Thread backgroundThread = new Thread(new Runnable() {
                @Override public void run() {
                    switch (requestType) {
                        case GET: sendGet(url,callback); break;
                        case POST: sendPost(url,params,callback); break;
                        case PUT: sendPut(url,params,callback); break;
                        case DELETE: sendDelete(url,params,callback); break;
                    }
                }
            });

            backgroundThread.start();
        }

    }

    private void sendGet(URL url, com.adpdigital.push.Callback callback) {
        try {

            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod(HttpRequestType.GET.getRequestType());

            for(Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                connection.setRequestProperty(entry.getKey(),entry.getValue());
            }

            connection.setUseCaches(false);
            connection.setDoOutput(false);
            connection.setConnectTimeout(TIMEOUT);

            String response = response(connection);

            if(responseCode == HttpsURLConnection.HTTP_OK) {
                if(callback != null) callback.onSuccess(response);
                Logger.d(TAG," Response ~~~> " + response);
            } else {
                if(callback != null) callback.onFailure(null);
                Logger.e(TAG,"Error  Response ~~~> " + response);
            }

        } catch (Throwable t) {
            if(callback != null) callback.onFailure(null);
            Logger.e("Error Response ~~~> ",t.getMessage());
        }
    }

    private void sendPost(URL url, String params,com.adpdigital.push.Callback callback) {
        try {
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod(HttpRequestType.POST.getRequestType());

            for(Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                connection.setRequestProperty(entry.getKey(),entry.getValue());
            }

            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(TIMEOUT);
            connection.setReadTimeout(TIMEOUT);

            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            byte[] sendBytes = params.getBytes("UTF-8");
            outputStream.write(sendBytes);
            outputStream.flush();
            outputStream.close();

            String response = response(connection);

            if(responseCode == HttpsURLConnection.HTTP_OK) {
                if(callback != null) callback.onSuccess(response);
                Logger.d(TAG," Response ~~~> " + response);
            } else {
                if(callback != null) callback.onFailure(null);
                Logger.e(TAG,"Error  Response ~~~> " + response);
            }

        } catch (Throwable t) {
            if(callback != null) callback.onFailure(null);
            Logger.e("Error Response ~~~> ",t.getMessage());
        }

    }

    private void sendPut(URL url, String params,com.adpdigital.push.Callback callback) {
        try {
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod(HttpRequestType.PUT.getRequestType());

            for(Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                connection.setRequestProperty(entry.getKey(),entry.getValue());
            }

            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(TIMEOUT);
            connection.setReadTimeout(TIMEOUT);

            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            byte[] sendBytes = params.getBytes("UTF-8");
            outputStream.write(sendBytes);
            outputStream.flush();
            outputStream.close();

            String response = response(connection);

            if(responseCode == HttpsURLConnection.HTTP_OK) {
                if(callback != null) callback.onSuccess(response);
                Logger.d(TAG,"Response ~~~> " + response);
            } else {
                if(callback != null) callback.onFailure(null);
                Logger.e(TAG,"Error Response ~~~> " + response);
            }

        } catch (Throwable t) {
            if(callback != null) callback.onFailure(null);
            Logger.e("Error Response ~~~> ",t.getMessage());
        }

    }

    private void sendDelete(URL url, String params,com.adpdigital.push.Callback callback) {
        try {
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod(HttpRequestType.DELETE.getRequestType());

            for(Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                connection.setRequestProperty(entry.getKey(),entry.getValue());
            }

            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(TIMEOUT);
            connection.setReadTimeout(TIMEOUT);

            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            byte[] sendBytes = params.getBytes("UTF-8");
            outputStream.write(sendBytes);
            outputStream.flush();
            outputStream.close();

            String response = response(connection);

            if(responseCode == HttpsURLConnection.HTTP_OK) {
                if(callback != null) callback.onSuccess(response);
                Logger.d(TAG,"Response ~~~> " + response);
            } else {
                if(callback != null) callback.onFailure(null);
                Logger.e(TAG,"Error Response ~~~> " + response);
            }

        } catch (Throwable t) {
            if(callback != null) callback.onFailure(null);
            Logger.e("Error Response ~~~> ",t.getMessage());
        }

    }

    @SuppressWarnings("StringBufferMayBeStringBuilder")
    private String response(HttpURLConnection connection) throws Exception {
        StringBuffer response = new StringBuffer();
        BufferedReader input;
        InputStream inputStream;
        int responseCode = responseCode(connection);

        if(responseCode == HttpsURLConnection.HTTP_OK) {
            inputStream = connection.getInputStream();
        } else {
            inputStream = connection.getErrorStream();
        }

        input = new BufferedReader(new InputStreamReader(inputStream));

        String inputLine;

        while ((inputLine = input.readLine()) != null) {
            response.append(inputLine);
        }

        input.close();

        return response.toString();

    }

    private int responseCode(HttpURLConnection connection) throws Exception {
        int responseCode = connection.getResponseCode();
        this.responseCode = responseCode;
        return responseCode;
    }

}
