package com.adpdigital.push.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.core.app.NotificationManagerCompat;

import com.adpdigital.push.ChabokFirebaseMessaging;
import com.adpdigital.push.Logger;

public class ChabokNotificationOpenedReceiver extends BroadcastReceiver {
    @Override
    public void onReceive(Context context, Intent intent) {
        Logger.d(Logger.TAG, "----> Broadcast received a notification action with " + intent);

        ChabokFirebaseMessaging.handleClickNotification(context, intent);

        handleDismissFromActionButtonPress(context, intent);
    }

    private static void handleDismissFromActionButtonPress(Context context, Intent intent) {
        // Pressed an action button, need to clear the notification and close the notification area manually.
        if (intent.getBooleanExtra("action_button", false)) {
//            Log.d(TAG, "handleDismissFromActionButtonPress: notificationId = " + intent.getIntExtra("notificationId", 1));
            NotificationManagerCompat.from(context).cancel(intent.getIntExtra("notificationId", 1));
//            context.sendBroadcast(new Intent(Intent.ACTION_CLOSE_SYSTEM_DIALOGS));
        }
    }
}
