package com.adpdigital.push.service;

import android.app.backup.BackupAgentHelper;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackupDataOutput;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.ParcelFileDescriptor;
import android.util.Log;

import com.network.InstallationModel;

import java.io.File;
import java.io.IOException;

public class ChabokBackupAgent extends BackupAgentHelper {
    private final static String TAG = ChabokBackupAgent.class.getSimpleName();

    // The name of the Chabok SharedPreferences file
    private static final String PREFS1 = "PREFS1";
    private static final String PREFS2 = "PREFS2";

    @Override
    public void onCreate() {
        Log.d(TAG, "onCreate() invoked.");

        super.onCreate();
    }

    @Override
    public void onFullBackup(FullBackupDataOutput data) throws IOException {
        Log.d(TAG, "onFullBackup() invoked.");

        try {
            super.onFullBackup(data);
        } catch (Exception e) {
            e.printStackTrace();

            Log.d(TAG, "super.onFullBackup() failed.");
        }
    }

    @Override
    public void onBackup(ParcelFileDescriptor oldState,
                         BackupDataOutput data,
                         ParcelFileDescriptor newState) throws IOException {
        Log.d(TAG, "onBackup() invoked.");

        try {
            super.onBackup(oldState, data, newState);
        } catch (Exception e) {
            e.printStackTrace();

            Log.d(TAG, "super.onBackup() failed.");
        }
    }

    @Override
    public void onRestore(BackupDataInput data,
                          int appVersionCode,
                          ParcelFileDescriptor newState) throws IOException {
        Log.d(TAG, "onRestore() invoked.");
        Log.d(TAG, "version ~> " + appVersionCode);

        // Let the restore operation go through
        try {
            super.onRestore(data, appVersionCode, newState);
        } catch (Exception e) {
            e.printStackTrace();

            Log.d(TAG, "super.onRestore() failed.");
        }
    }

    @Override
    public void onRestoreFile(ParcelFileDescriptor data,
                              long size,
                              File destination,
                              int type,
                              long mode,
                              long mtime) throws IOException {
        Log.d(TAG, "onRestoreFile() invoked.");
        Log.d(TAG, "destination ~> " + destination.getAbsolutePath());

        try {
            super.onRestoreFile(data, size, destination, type, mode, mtime);
        } catch (Exception e) {
            e.printStackTrace();

            Log.d(TAG, "super.onRestoreFile() failed.");
        }
    }

    @Override
    public void onRestoreFinished() {
        Log.d(TAG, "onRestoreFinished() invoked.");

        try {
            super.onRestoreFinished();
        } catch (Exception e) {
            e.printStackTrace();

            Log.d(TAG, "super.onRestoreFinished() failed.");
        }

        doRestore(getApplicationContext());
    }

    @Override
    public void onQuotaExceeded(long backupDataBytes, long quotaBytes) {
        Log.d(TAG, "onQuotaExceeded() invoked.");
        Log.d(TAG, "(" + quotaBytes + ") Bytes out of (" + backupDataBytes + ") Bytes");

        try {
            super.onQuotaExceeded(backupDataBytes, quotaBytes);
        } catch (Exception e) {
            e.printStackTrace();

            Log.d(TAG, "super.onQuotaExceeded() failed.");
        }
    }

    @Override
    public void onDestroy() {
        Log.d(TAG, "onDestroy() invoked.");

        super.onDestroy();
    }

    private static void removeChabokNoBackupPreferences(Context context) {
        Log.d(TAG, "removeChabokNoBackupPreferences() invoked.");

        try {
            final SharedPreferences.Editor editor1 = context.getSharedPreferences(
                    PREFS1, MODE_PRIVATE).edit();
            if (editor1 != null) {
                editor1.clear().apply();
            }

            final SharedPreferences.Editor editor2 = context.getSharedPreferences(
                    PREFS2, MODE_PRIVATE).edit();
            if (editor2 != null) {
                editor2.clear().apply();
            }
        } catch (Exception e) {
            e.printStackTrace();

            Log.e(TAG, "removeChabokNoBackupPreferences failed!");
        }
    }

    public static void doRestore(Context context) {
        Log.d(TAG, "doRestore() invoked.");

        removeChabokNoBackupPreferences(context);
    }
}
