package com.adpdigital.push.notification;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.RemoteViews;

import com.adpdigital.push.R;

import java.util.ArrayList;
import java.util.Collections;

import static com.adpdigital.push.AdpPushClient.TAG;

public class SimpleExpandedNotification {

    private SimpleExpandedNotification() {
    }

    public static class Builder {
        private int color = -1;
        private Bitmap image;
        private Bitmap largeIcon;
        private Context mContext;
        private CharSequence body;
        private CharSequence title;
        private RemoteViews mExpandedView;
        private boolean showActionRtl = false;
        private boolean alignActionsRtl = false;
        private ArrayList<NotificationCompat.Action> actions;

        public Builder(@NonNull Context context) {
            this.mContext = context;

            if (context != null) {
                mExpandedView = new RemoteViews(context.getPackageName(), R.layout.big_text_notification);
            } else {
                Log.e(TAG, "Builder: context is null");
            }
        }

        public CharSequence getBody() {
            return body;
        }

        public Builder setBody(CharSequence body) {
            this.body = body;

            if (mExpandedView == null) {
                Log.e(TAG, "setBody: mExpandedView is null");

                return this;
            }

            if (body != null) {
                mExpandedView.setTextViewText(R.id.bodyTextView, body);
                mExpandedView.setViewVisibility(R.id.bodyTextView, View.VISIBLE);
            } else {
                mExpandedView.setViewVisibility(R.id.bodyTextView, View.GONE);
            }

            return this;
        }

        public CharSequence getTitle() {
            return title;
        }

        public Builder setTitle(CharSequence title) {
            this.title = title;

            if (mExpandedView == null) {
                Log.e(TAG, "setTitle: mExpandedView is null");

                return this;
            }

            if (title != null) {
                mExpandedView.setTextViewText(R.id.titleTextView, title);
                mExpandedView.setViewVisibility(R.id.titleTextView, View.VISIBLE);
            } else {
                mExpandedView.setViewVisibility(R.id.titleTextView, View.GONE);
            }

            return this;
        }

        public Bitmap getImage() {
            return image;
        }

        public Builder setImage(Bitmap image) {
            this.image = image;

            if (mExpandedView == null) {
                Log.e(TAG, "setImage: mExpandedView is null");

                return this;
            }

            if (image != null) {
                mExpandedView.setImageViewBitmap(R.id.bigPictureImageView, image);
                mExpandedView.setViewVisibility(R.id.bigPictureImageView, View.VISIBLE);
            } else {
                mExpandedView.setViewVisibility(R.id.bigPictureImageView, View.GONE);
            }

            return this;
        }


        public Bitmap getLargeIcon() {
            return largeIcon;
        }

        public Builder setLargeIcon(Bitmap largeIcon) {
            this.largeIcon = largeIcon;

            if (mExpandedView == null){
                Log.e(TAG, "setLargeIcon: mCollapseView is null");

                return this;
            }

            if (largeIcon == null) {
                mExpandedView.setViewVisibility(R.id.leftLargeIconImageView, View.GONE);
                mExpandedView.setViewVisibility(R.id.rightLargeIconImageView, View.GONE);
            }

            return this;
        }

        public int getColor() {
            return color;
        }

        public Builder setColor(int color) {
            this.color = color;

            return this;
        }

        public ArrayList<NotificationCompat.Action> getActions() {
            return actions;
        }

        public Builder setActions(ArrayList<NotificationCompat.Action> actions) {
            this.actions = actions;

            return this;
        }

        public boolean isAlignActionsRtl() {
            return alignActionsRtl;
        }

        public Builder setAlignActionsRtl(boolean alignActionsRtl) {
            this.alignActionsRtl = alignActionsRtl;

            return this;
        }

        public boolean isShowActionRtl() {
            return showActionRtl;
        }

        public Builder setShowActionRtl(boolean showActionRtl) {
            this.showActionRtl = showActionRtl;

            return this;
        }

        @Nullable
        public RemoteViews remoteViewsBuilder() {
            if (mExpandedView == null) {
                Log.e(TAG, "remoteViewsBuilder: mExpandedView is null");

                return null;
            }

            if (this.getImage() == null) {
                mExpandedView = new RemoteViews(this.mContext.getPackageName(), R.layout.no_pic_big_text_notification);
            }

            boolean isLTR = StringUtils.isLTR(this.getBody().toString());

            if (isLTR) {
                mExpandedView.setInt(R.id.titleAndBodyLayout,"setGravity", Gravity.START);
            } else {
                mExpandedView.setInt(R.id.titleAndBodyLayout,"setGravity", Gravity.END);
            }

            if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.M) {
                this.provideFullscreenAlign();
            }

            if (this.getBody() == null) {
                mExpandedView.setViewVisibility(R.id.bodyTextView, View.GONE);
            } else {
                mExpandedView.setTextViewText(R.id.bodyTextView, this.getBody());
            }

            if (this.getTitle() == null || this.getTitle().toString().trim().length() == 0) {
                mExpandedView.setViewVisibility(R.id.titleTextView, View.GONE);
                float scale = mContext.getResources().getDisplayMetrics().density;
                int padding = (int) (10*scale + 0.5f);

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                    mExpandedView.setViewPadding(R.id.bodyTextView, 0,padding, 0, 0);
                }

            } else {
                mExpandedView.setTextViewText(R.id.titleTextView, this.getTitle());
            }

            if (this.getImage() == null) {
                mExpandedView.setViewVisibility(R.id.bigPictureImageView, View.GONE);
            } else {
                mExpandedView.setImageViewBitmap(R.id.bigPictureImageView, this.getImage());
            }

            mExpandedView.setViewVisibility(R.id.leftLargeIconImageView, View.GONE);
            mExpandedView.setViewVisibility(R.id.rightLargeIconImageView, View.GONE);

            if (this.largeIcon != null){
                if (isLTR) {
                    mExpandedView.setImageViewBitmap(R.id.leftLargeIconImageView, largeIcon);
                    mExpandedView.setViewVisibility(R.id.leftLargeIconImageView, View.VISIBLE);
                } else {
                    mExpandedView.setImageViewBitmap(R.id.rightLargeIconImageView, largeIcon);
                    mExpandedView.setViewVisibility(R.id.rightLargeIconImageView, View.VISIBLE);
                }
            }

            if (this.isShowActionRtl()){
                mExpandedView.setInt(R.id.actionsLayout, "setGravity", Gravity.END);
            } else {
                mExpandedView.setInt(R.id.actionsLayout, "setGravity", Gravity.START);
            }

            if (this.actions == null || this.actions.isEmpty()){
                mExpandedView.setViewVisibility(R.id.actionsLayout, View.GONE);
            } else {
                ArrayList<NotificationCompat.Action> actions = this.getActions();
                if (this.isAlignActionsRtl()){
                    Collections.reverse(actions);
                }

                int count = Math.min(actions.size(), 3);
                for (int i = 0; i < count; i++) {
                    mExpandedView.addView(
                            R.id.actionsLayout,
                            NotificationUtil.generateActionButton(actions.get(i), this.getColor(), this.mContext)
                    );
                }
            }

            return mExpandedView;
        }


        public void provideFullscreenAlign(){
            if (mExpandedView == null) {
                Log.e(TAG, "remoteViewsBuilder: mExpandedView is null");
                return;
            }

            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                int padding = NotificationUtil.getSizeFromScreenDp(10, this.mContext);

                mExpandedView.setViewPadding(R.id.parentLayout, padding,padding, padding, 0);
            }
        }
    }
}
