package com.adpdigital.push.config;

import android.content.Context;
import android.content.res.Resources;

class ResUtils {

    private ResUtils() {
        // no implementation
    }

    static String getResourceValue(Context context, String resourceName) {
        if (resourceName == null || resourceName.isEmpty()) {
            return "";
        }

        String trimmedKey = resourceName.trim();
        if (!isValidResourceName(trimmedKey))
            return "";

        int apiKeyId = getStringResId(context, trimmedKey);
        return context.getResources().getString(apiKeyId);
    }

    private static boolean isValidResourceName(String name) {
        return (name != null && !name.matches("^[0-9]"));
    }

    private static int getStringResId(Context context, String name) {
        Resources resources = context.getResources();
        if (resources != null) {
            String packageName = context.getPackageName();
            if (packageName != null) {
                return resources.getIdentifier(name, "string", packageName);
            }
        }
        return 0;
    }
}
