package com.adpdigital.push;

import org.json.JSONException;
import org.json.JSONObject;

import static com.adpdigital.push.AdpPushClient.PUSH_MSG_RECEIVED_INTENT;

/**
 * Created by jrad on 5/16/15.
 */
public class PushMessage extends ChabokMessage {


    private long createdAt;

    private boolean inApp = false;

    private boolean live = false;

    private boolean stateful = false;

    private long expireAt;

    protected String body;

    private JSONObject data;

    private JSONObject notification;

    private String senderId;

    private String sentId;

    private boolean notify = true;

    private boolean useAsAlert = false;

    private String alertText;

    private String alertTitle;

    private String sound;

    private String trackId;


    public long getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean isInApp() {
        return inApp;
    }

    public void setInApp(boolean inApp) {
        this.inApp = inApp;
    }

    public boolean isLive() {
        return live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public boolean isStateful() {
        return stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public long getExpireAt() {
        return expireAt;
    }

    public void setExpireAt(long expireAt) {
        this.expireAt = expireAt;
    }

    public JSONObject getData() {
        return data;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public JSONObject getNotification() {
        return notification;
    }

    public void setNotification(JSONObject notification) {
        this.notification = notification;
    }

    public String getSenderId() {
        return senderId;
    }

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    public String getSound() {
        return sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public String getSentId() {
        return sentId;
    }

    public void setSentId(String sentId) {
        this.sentId = sentId;
    }

    public boolean isUseAsAlert() {
        return useAsAlert;
    }

    public void setUseAsAlert(boolean useAsAlert) {
        this.useAsAlert = useAsAlert;
    }

    public String getAlertText() {
        return alertText;
    }

    public void setAlertText(String alertText) {
        this.alertText = alertText;
    }

    public String getAlertTitle() {
        return alertTitle;
    }

    public void setAlertTitle(String alertTitle) {
        this.alertTitle = alertTitle;
    }

    public boolean isNotify() {
        return notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public static PushMessage fromJson(String jsonString, String channel) {
        PushMessage push = new PushMessage();
        try {

            JSONObject jsonMessage = new JSONObject(jsonString);

            // must have keys
            push.setChannel(channel);
            push.setId(jsonMessage.getString("id"));
            if (jsonMessage.has("trackId")){
                push.setTrackId(jsonMessage.getString("trackId"));
            }
            push.setCreatedAt(jsonMessage.getLong("createdAt"));
            push.setReceivedAt(System.currentTimeMillis());

            // optional keys
            push.setBody(jsonMessage.optString("content"));
            push.setData(jsonMessage.optJSONObject("data"));
            long ttl = jsonMessage.optLong("ttl", 0);
            if( ttl > 0 ) {
                push.setExpireAt(push.getCreatedAt() + (ttl*1000));
            }
            push.setInApp(jsonMessage.optBoolean("inApp"));
            push.setLive(jsonMessage.optBoolean("live"));
            push.setNotify(!jsonMessage.optBoolean("silent", false));
            push.setStateful(jsonMessage.optBoolean("stateful"));
            String publishId = jsonMessage.optString("publishId");
            if( publishId != null) {
                String[] tokens = publishId.split("/");
                if( tokens.length == 3 ) {
                    push.setSenderId(tokens[0]);
                    push.setSentId(tokens[2]);
                }
            }

            JSONObject notif = jsonMessage.optJSONObject("notification");
            if (notif != null) {
                push.setNotification(notif);
                push.setAlertTitle(notif.optString("title"));
                push.setAlertText(notif.optString("text"));
                push.setAlertText(notif.optString("body"));
                push.setSound(notif.optString("sound"));
            }

            return push;
        } catch (JSONException e) {
            throw new IllegalArgumentException( "Invalid Json " + e.getMessage() );
        }
    }


    public String toJson() {
        try {
            JSONObject jsonMessage = new JSONObject();
            jsonMessage.put("id", id);
            jsonMessage.put("createdAt", createdAt);
            if( body != null ) {
                jsonMessage.put("content", body);
            }
            if( expireAt > 0 ) {
                long ttl = (getExpireAt() - getCreatedAt()) / 1000;
                jsonMessage.put("ttl", ttl);
            }
            if( inApp ) {
                jsonMessage.put("inApp", true);
            }
            if( !notify ) {
                jsonMessage.put("silent", true);
            }
            if( stateful ) {
                jsonMessage.put("stateful", true);
            }
            if( useAsAlert ) {
                jsonMessage.put("useAsAlert", true);
            }
            if( alertText != null ) {
                jsonMessage.put("alertText", alertText);
            }
            if( alertTitle != null ) {
                JSONObject obj = new JSONObject();
                obj.put("title", alertTitle);
                jsonMessage.put("notification", obj);
            }
            if( data != null ) {
                jsonMessage.put("data", data);
            }
            if (trackId != null){
                jsonMessage.put("trackId", trackId);
            }
            return jsonMessage.toString();
        } catch (JSONException e) {
            throw new IllegalArgumentException( "Invalid Json " + e.getMessage() );
        }
    }

    @Override
    public String toString() {
        return "PushMessage{" +
                "id='" + id + '\'' +
                ", createdAt=" + createdAt +
                ", channel='" + channel + '\'' +
                ", inapp='" + inApp + '\'' +
                ", stateful='" + stateful + '\'' +
                ", data='" + (data != null ? data.toString() : "null") + '\'' +
                '}';
    }


    public String getIntentType() {
        return PUSH_MSG_RECEIVED_INTENT;
    }


    public void markAsRead() {
        markAsRead( this.id );
    }


    public static void markAsRead( String messageId ) {
        AdpPushClient.get().publishMessageEvent( "seen", messageId );

    }

    public void dismiss() {
        messageDismissed(this.id);
    }


    public static void messageDismissed( String messageId ) {
        AdpPushClient.get().publishMessageEvent( "dismiss", messageId);

    }

    public String getTrackId() {
        return trackId;
    }

    public void setTrackId(String trackId) {
        this.trackId = trackId;
    }
}
