package com.adpdigital.push;

import android.os.Binder;
import android.os.Process;
import android.os.StrictMode;
import android.os.StrictMode.ThreadPolicy;
import androidx.annotation.Nullable;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class ProcessUtils {
    private static String myProcessName = null;
    private static int myProcessId = 0;

    private ProcessUtils() {
        // no implementation
    }

    @Nullable
    public static String getCallingProcessName() {
        int processId;
        return (processId = Binder.getCallingPid()) == getMyProcessId() ? getMyProcessName() : getProcessName(processId);
    }

    @Nullable
    public static String getMyProcessName() {
        if (myProcessName == null) {
            myProcessName = getProcessName(getMyProcessId());
        }

        return myProcessName;
    }

    @Nullable
    private static String getProcessName(int processId) {
        if (processId <= 0) {
            return null;
        } else {
            BufferedReader reader = null;
            String processName = null;

            try {
                processName = (reader = readFile((new StringBuilder(25)).append("/proc/").append(processId).append("/cmdline").toString())).readLine().trim();
            } catch (IOException ignored) {
                // ignore
            } finally {
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (IOException ignored) {
                        // ignore
                    }
                }
            }

            return processName;
        }
    }

    private static BufferedReader readFile(String filePath) throws IOException {
        ThreadPolicy policy = StrictMode.allowThreadDiskReads();

        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(filePath));
        } finally {
            StrictMode.setThreadPolicy(policy);
        }

        return reader;
    }

    private static int getMyProcessId() {
        if (myProcessId == 0) {
            myProcessId = Process.myPid();
        }

        return myProcessId;
    }
}