package com.adpdigital.push;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.UUID;

import static com.adpdigital.push.AdpPushClient.PUSH_DELIVERY_RECEIVED_INTENT;


/**
 * Created by behrad on 2/4/16.
 */
public class EventMessage extends ChabokMessage {

    private String name;

    private String installationId;

    private JSONObject data;


    public EventMessage(String name, String installationId, String payload) {
        this.name = name;
        this.installationId = installationId;
        try {
            JSONObject eventPayload = new JSONObject(payload);
            boolean isMatchFeedback = (name.contentEquals("matchUserFeedback") || name.contentEquals("matchFeedbackStats")) &&
                    (AdpPushClient.get().getAppId().contentEquals("90-dev") ||
                            AdpPushClient.get().getAppId().contentEquals("90-demo"));
            if (isMatchFeedback){
                this.data = eventPayload;
            } else {
                if (eventPayload.has("data")){
                    this.data = eventPayload.getJSONObject("data");
                }
            }
            if (eventPayload.has("id")) {
                try {
                    setId(eventPayload.getString("id"));
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        } catch (JSONException e) {
            throw new IllegalArgumentException( "Invalid Json " + e.getMessage() );
        }
    }

    public String getName() {
        return name;
    }

    public String getInstallationId() {
        return installationId;
    }

    public JSONObject getData() {
        return data;
    }
}
