package com.adpdigital.push;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.telephony.TelephonyManager;
import android.util.Base64;

import org.json.JSONObject;

import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DeviceUtil {

    private static String byteToString(byte[] bytes) {
        return new String(bytes);
    }

    private static boolean findBinary(String binaryName) {
        boolean found = false;
        try {
            String[] places = getPlacesString();

            for (String where : places) {
                if (new File(where + binaryName).exists()) {
                    found = true;

                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return found;
    }

    @NonNull
    private static String[] getPlacesString() {
        return new String[]{
                        byteToString(new byte[]{47, 115, 98, 105, 110, 47}),
                        byteToString(new byte[]{47, 115, 121, 115, 116, 101, 109, 47, 98, 105, 110, 47}),
                        byteToString(new byte[]{47, 115, 121, 115, 116, 101, 109, 47, 120, 98, 105, 110, 47}),
                        byteToString(new byte[]{47, 100, 97, 116, 97, 47, 108, 111, 99, 97, 108, 47, 120, 98, 105, 110, 47}),
                        byteToString(new byte[]{47, 100, 97, 116, 97, 47, 108, 111, 99, 97, 108, 47, 98, 105, 110, 47}),
                        byteToString(new byte[]{47, 115, 121, 115, 116, 101, 109, 47, 115, 100, 47, 120, 98, 105, 110, 47}),
                        byteToString(new byte[]{47, 115, 121, 115, 116, 101, 109, 47, 98, 105, 110, 47, 102, 97, 105, 108, 115, 97, 102, 101, 47}),
                        byteToString(new byte[]{47, 100, 97, 116, 97, 47, 108, 111, 99, 97, 108, 47}),
                };
    }

    private static boolean checkRootMethod2() {
        return findBinary(bytesToHex(new byte[]{115, 117}));
    }

    private static boolean checkRootMethod1() {
        String buildTags = android.os.Build.TAGS;
        String key = byteToString(new byte[]{116, 101, 115, 116, 45, 107, 101, 121, 115});

        return buildTags != null && buildTags.contains(key);
    }

    private static String deviceFingerPrint(){
        return Build.FINGERPRINT;
    }

    public static String getMobileOperator(Context context){
        TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);

        if (tm == null){
            return "";
        }

        return tm.getNetworkOperatorName();
    }

    private static boolean isEmulatorMethod1(Context context){
        String key = byteToString(new byte[]{65, 110, 100, 114, 111, 105, 100});

        return key.equals(getMobileOperator(context));
    }

    private static boolean isEmulatorMethod2() {
        String[] keys = new String[]{
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{117, 110, 107, 110, 111, 119, 110}),
                byteToString(new byte[]{103, 111, 108, 100, 102, 105, 115, 104}),
                byteToString(new byte[]{114, 97, 110, 99, 104, 117}),
                byteToString(new byte[]{103, 111, 111, 103, 108, 101, 95, 115, 100, 107}),
                byteToString(new byte[]{69, 109, 117, 108, 97, 116, 111, 114}),
                byteToString(new byte[]{65, 110, 100, 114, 111, 105, 100, 32, 83, 68, 75, 32, 98, 117, 105, 108, 116, 32, 102, 111, 114, 32, 120, 56, 54}),
                byteToString(new byte[]{71, 101, 110, 121, 109, 111, 116, 105, 111, 110}),
                byteToString(new byte[]{115, 100, 107, 95, 103, 111, 111, 103, 108, 101}),
                byteToString(new byte[]{115, 100, 107}),
                byteToString(new byte[]{115, 100, 107, 95, 120, 56, 54}),
                byteToString(new byte[]{118, 98, 111, 120, 56, 54, 112}),
                byteToString(new byte[]{101, 109, 117, 108, 97, 116, 111, 114}),
                byteToString(new byte[]{115, 105, 109, 117, 108, 97, 116, 111, 114}),

        };
        return (Build.BRAND.startsWith(keys[0]) && Build.DEVICE.startsWith(keys[0]))
                || Build.FINGERPRINT.startsWith(keys[0])
                || Build.FINGERPRINT.startsWith(keys[1])
                || Build.HARDWARE.contains(keys[2])
                || Build.HARDWARE.contains(keys[3])
                || Build.MODEL.contains(keys[4])
                || Build.MODEL.contains(keys[5])
                || Build.MODEL.contains(keys[6])
                || Build.MANUFACTURER.contains(keys[7])
                || Build.PRODUCT.contains(keys[8])
                || Build.PRODUCT.contains(keys[4])
                || Build.PRODUCT.contains(keys[9])
                || Build.PRODUCT.contains(keys[10])
                || Build.PRODUCT.contains(keys[11])
                || Build.PRODUCT.contains(keys[12])
                || Build.PRODUCT.contains(keys[13]);
    }

    public static boolean isEmulatorMethod3() {
        String[] keys = new String[]{
                byteToString(new byte[]{115, 100, 107}),
                byteToString(new byte[]{103, 111, 111, 103, 108, 101, 95, 115, 100, 107}),
                byteToString(new byte[]{115, 100, 107, 95, 120, 56, 54}),
                byteToString(new byte[]{118, 98, 111, 120, 56, 54, 112}),
                byteToString(new byte[]{117, 110, 107, 110, 111, 119, 110}),
                byteToString(new byte[]{71, 101, 110, 121, 109, 111, 116, 105, 111, 110}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 95, 120, 56, 54}),
                byteToString(new byte[]{65, 110, 100, 114, 111, 105, 100, 32, 83, 68, 75, 32, 98, 117, 105, 108, 116, 32, 102, 111, 114, 32, 120, 56, 54}),
                byteToString(new byte[]{118, 98, 111, 120, 56, 54}),
                byteToString(new byte[]{103, 111, 108, 100, 102, 105, 115, 104}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 47, 115, 100, 107, 47, 103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 95, 120, 56, 54, 47, 115, 100, 107, 95, 120, 56, 54, 47, 103, 101, 110, 101, 114, 105, 99, 95, 120, 56, 54}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 47, 103, 111, 111, 103, 108, 101, 95, 115, 100, 107, 47, 103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 47, 118, 98, 111, 120, 56, 54, 112, 47, 118, 98, 111, 120, 56, 54, 112}),
        };

        int rating = 0;

        if ((Build.PRODUCT.equals(keys[0])) || (Build.PRODUCT.equals(keys[1]))
                || (Build.PRODUCT.equals(keys[2])) || (Build.PRODUCT.equals(keys[3]))) {
            rating++;
        }
        if ((Build.MANUFACTURER.equals(keys[4])) || (Build.MANUFACTURER.equals(keys[5]))) {
            rating++;
        }
        if ((Build.BRAND.equals(keys[6])) || (Build.BRAND.equals(keys[7]))) {
            rating++;
        }
        if ((Build.DEVICE.equals(keys[6])) || (Build.DEVICE.equals(keys[7])) || (Build.DEVICE.equals(keys[3]))) {
            rating++;
        }
        if ((Build.MODEL.equals(keys[0])) || (Build.MODEL.equals(keys[1]))
                || (Build.MODEL.equals(keys[8]))) {
            rating++;
        }
        if ((Build.HARDWARE.equals(keys[10])) || (Build.HARDWARE.equals(keys[9]))) {
            rating++;
        }
        if ((Build.FINGERPRINT.contains(keys[11]))
                || (Build.FINGERPRINT.contains(keys[12]))
                || (Build.FINGERPRINT.contains(keys[13]))
                || (Build.FINGERPRINT.contains(keys[14]))) {
            rating++;
        }

        return rating > 4;
    }

    private static String getSystemProperty(String name) throws Exception {
        String key = byteToString(new byte[]{97,110,100,114,111,105,100,46,111,115,46,83,121,115,116,101,109,80,114,111,112,101,114,116,105,101,115});
        Class systemPropertyClazz = Class.forName(key);
        return (String) systemPropertyClazz.getMethod("get", new Class[]{String.class}).invoke(systemPropertyClazz, new Object[]{name});
    }

    private static boolean isEmulatorMethod4() {
        String[] keys = new String[]{
                byteToString(new byte[]{114, 111, 46, 104, 97, 114, 100, 119, 97, 114, 101 }),
                byteToString(new byte[]{103, 111, 108, 100, 102, 105, 115, 104}),
                byteToString(new byte[]{114, 111, 46, 107, 101, 114, 110, 101, 108, 46, 113, 101, 109, 117}),
                byteToString(new byte[]{114,111,46,112,114,111,100,117,99,116,46,109,111,100,101,108}),
                byteToString(new byte[]{115, 100, 107}),

                byteToString(new byte[]{117, 110, 107, 110, 111, 119, 110}),
                byteToString(new byte[]{71, 101, 110, 121, 109, 111, 116, 105, 111, 110}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 95, 120, 56, 54}),
                byteToString(new byte[]{65, 110, 100, 114, 111, 105, 100, 32, 83, 68, 75, 32, 98, 117, 105, 108, 116, 32, 102, 111, 114, 32, 120, 56, 54}),
                byteToString(new byte[]{118, 98, 111, 120, 56, 54}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 47, 115, 100, 107, 47, 103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 95, 120, 56, 54, 47, 115, 100, 107, 95, 120, 56, 54, 47, 103, 101, 110, 101, 114, 105, 99, 95, 120, 56, 54}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 47, 103, 111, 111, 103, 108, 101, 95, 115, 100, 107, 47, 103, 101, 110, 101, 114, 105, 99}),
                byteToString(new byte[]{103, 101, 110, 101, 114, 105, 99, 47, 118, 98, 111, 120, 56, 54, 112, 47, 118, 98, 111, 120, 56, 54, 112}),
        };

        boolean emu = false;
        boolean sdk = false;
        boolean goldfish = false;

        try {
            goldfish = getSystemProperty(keys[0]).contains(keys[1]);
            emu = getSystemProperty(keys[2]).length() > 0;
            sdk = getSystemProperty(keys[3]).equals(keys[4]);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return goldfish || emu || sdk;
    }

    @Nullable
    public static String getAppSignature(Context context) throws PackageManager.NameNotFoundException {
        // GET_SIGNATURES: https://developer.android.com/reference/android/content/pm/PackageManager#GET_SIGNATURES
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(
                context.getPackageName(), getSigFlag());
        for (Signature signature : packageInfo.signatures) {
            return getSHA1(signature.toByteArray());
        }

        return null;
    }

    private static int getSigFlag(){
        return PackageManager.GET_SIGNATURES;
    }

    //computed the sha1 hash of the signature
    @Nullable
    public static String getSHA1(byte[] sig) {
        String key = byteToString(new byte[]{83, 72, 65, 49});

        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(key);
            digest.update(sig);

            byte[] hashtext = digest.digest();
            return bytesToHex(hashtext);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (Exception e){
            e.printStackTrace();
        }

        return null;
    }

    //util method to convert byte array to hex string
    public static String bytesToHex(byte[] bytes) {
        final char[] hexArray = { '0', '1', '2', '3', '4', '5', '6', '7', '8',
                '9', 'A', 'B', 'C', 'D', 'E', 'F' };
        char[] hexChars = new char[bytes.length * 2];
        int v;
        for (int j = 0; j < bytes.length; j++) {
            v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0x0F];
        }
        return new String(hexChars);
    }

    private static int booleansToBinary(Boolean[] booleans){
        int result = 0;
        List<Boolean> boolArray = Arrays.asList(booleans);
        Collections.reverse(boolArray);

        for (int i = 0; i < boolArray.size(); i++) {
            if (boolArray.get(i)) {
                result |= 1 << i;
            }
        }

        return result;
    }

    @NonNull
    public static String base64CreateFingerprint(Context context) {
        try {
            Bundle fingerPrint = DeviceUtil.createFingerprint(context);
            if (fingerPrint.size() != 0) {
                JSONObject convertedData = DataConverter.bundleToJson(fingerPrint);
                byte[] data = convertedData.toString().getBytes("UTF-8");
                return Base64.encodeToString(data, Base64.NO_WRAP);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return "INVALID";
    }

    @NonNull
    public static Bundle createFingerprint(Context context){
        Bundle fingerprintBundle = new Bundle();

        Boolean[] isRooteds = new Boolean[]{
                checkRootMethod1(),
                checkRootMethod2()
        };

        int rootedCode = booleansToBinary(isRooteds);

        fingerprintBundle.putInt("ir", rootedCode);

        Boolean[] emulatorMethods = new Boolean[]{
                isEmulatorMethod1(context),
                isEmulatorMethod2(),
                isEmulatorMethod3(),
                isEmulatorMethod4()
        };

        int emulatorCode = booleansToBinary(emulatorMethods);
        fingerprintBundle.putInt("si", emulatorCode);

        return fingerprintBundle;
    }
}
