package com.adpdigital.push;

/**
 * Created by behrad on 4/28/16.
 */
public class DeviceToken {

    private SecureString token;
    private String tokenStatus;
    private int tokenErrCode;
    private String tokenErrMessage;
    private String callerId;
    private boolean forceUpdate;

    public DeviceToken(SecureString token) {
        this.token = token;
    }

    public DeviceToken(SecureString token, String tokenStatus) {
        this.token = token;
        this.tokenStatus = tokenStatus;
    }

    public DeviceToken(SecureString token, String errorMessage, int errorCode) {
        this.token = token;
        this.tokenStatus = "ERR";
        this.tokenErrCode = errorCode;
        this.tokenErrMessage = errorMessage;
    }

    public void setCallerId(String callerId) {
        this.callerId = callerId;
    }

    public String getCallerId() {
        return callerId;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public boolean isForceUpdate() {
        return forceUpdate;
    }

    public SecureString getToken() {
        return token;
    }

    public String getTokenStatus() {
        return tokenStatus;
    }

    public String getTokenErr() {
        return tokenErrMessage;
    }

    public int getTokenErrCode() {
        return tokenErrCode;
    }
}
