package com.adpdigital.push;

import java.util.UUID;

import static com.adpdigital.push.AdpPushClient.PUSH_DELIVERY_RECEIVED_INTENT;


/**
 * Created by behrad on 2/4/16.
 */
public class DeliveryMessage extends ChabokMessage {


    private String deliveredMessageId;

    private String deliveredUserId;

    private String deliveredDeviceId;

    private long deliveredAt;



    public DeliveryMessage(String messageCId, String payload) {
        String[] tokens = payload.split("-:-");
        setDeliveredUserId(tokens[0]);
        setDeliveredDeviceId(tokens[1]);
        setDeliveredAt(Long.parseLong(tokens[2]));
        setDeliveredMessageId(messageCId);
        //TODO use server side generate UUIDs to properly handle duplicates
        setId(UUID.randomUUID().toString());
    }

    public String getIntentType() {
        return PUSH_DELIVERY_RECEIVED_INTENT;
    }

    public long getDeliveredAt() {
        return deliveredAt;
    }

    public void setDeliveredAt(long deliveredAt) {
        this.deliveredAt = deliveredAt;
    }

    public String getDeliveredUserId() {
        return deliveredUserId;
    }

    public void setDeliveredUserId(String deliveredUserId) {
        this.deliveredUserId = deliveredUserId;
    }

    public String getDeliveredDeviceId() {
        return deliveredDeviceId;
    }

    public void setDeliveredDeviceId(String deliveredDeviceId) {
        this.deliveredDeviceId = deliveredDeviceId;
    }

    public String getDeliveredMessageId() {
        return deliveredMessageId;
    }

    public void setDeliveredMessageId(String deliveredMessageId) {
        this.deliveredMessageId = deliveredMessageId;
    }
}
