/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.S3Exception;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jspecify.annotations.Nullable;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.utils.BinaryUtils;

public final class DigestUtil {
    private static final String DIGEST_COULD_NOT_BE_CALCULATED = "Digest could not be calculated.";
    private static final String CHECKSUM_COULD_NOT_BE_CALCULATED = "Checksum could not be calculated.";

    private DigestUtil() {
    }

    public static void verifyChecksum(String expected, @Nullable String actual, com.adobe.testing.s3mock.dto.ChecksumAlgorithm checksumAlgorithm) {
        if (!expected.equals(actual)) {
            switch (checksumAlgorithm) {
                case SHA1: {
                    throw S3Exception.BAD_CHECKSUM_SHA1;
                }
                case SHA256: {
                    throw S3Exception.BAD_CHECKSUM_SHA256;
                }
                case CRC32: {
                    throw S3Exception.BAD_CHECKSUM_CRC32;
                }
                case CRC32C: {
                    throw S3Exception.BAD_CHECKSUM_CRC32C;
                }
                case CRC64NVME: {
                    throw S3Exception.BAD_CHECKSUM_CRC64NVME;
                }
            }
            throw S3Exception.BAD_DIGEST;
        }
    }

    public static String checksumFor(Path path, ChecksumAlgorithm algorithm) {
        String string;
        block8: {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            try {
                string = DigestUtil.checksumFor(is, algorithm);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(CHECKSUM_COULD_NOT_BE_CALCULATED, e);
                }
            }
            is.close();
        }
        return string;
    }

    private static String checksumFor(InputStream is, ChecksumAlgorithm algorithm) {
        return BinaryUtils.toBase64((byte[])DigestUtil.checksum(is, algorithm));
    }

    private static byte[] checksum(InputStream is, ChecksumAlgorithm algorithm) {
        SdkChecksum sdkChecksum = SdkChecksum.forAlgorithm((ChecksumAlgorithm)algorithm);
        try {
            int read;
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) != -1) {
                sdkChecksum.update(buffer, 0, read);
            }
            return sdkChecksum.getChecksumBytes();
        }
        catch (IOException e) {
            throw new IllegalStateException(CHECKSUM_COULD_NOT_BE_CALCULATED, e);
        }
    }

    private static byte[] checksum(List<Path> paths, ChecksumAlgorithm algorithm) {
        SdkChecksum sdkChecksum = SdkChecksum.forAlgorithm((ChecksumAlgorithm)algorithm);
        for (Path path : paths) {
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    sdkChecksum.update(DigestUtil.checksum(inputStream, algorithm));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read from path " + String.valueOf(path), e);
            }
        }
        return sdkChecksum.getChecksumBytes();
    }

    public static String hexDigestMultipart(List<Path> paths) {
        return Hex.encodeHexString((byte[])DigestUtil.md5(null, paths)) + "-" + paths.size();
    }

    public static String checksumMultipart(List<Path> paths, ChecksumAlgorithm algorithm) {
        return BinaryUtils.toBase64((byte[])DigestUtil.checksum(paths, algorithm)) + "-" + paths.size();
    }

    public static String hexDigest(byte[] bytes) {
        return DigestUtils.md5Hex((byte[])bytes);
    }

    public static String hexDigest(File file) {
        String string;
        block8: {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                string = DigestUtil.hexDigest(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(DIGEST_COULD_NOT_BE_CALCULATED, e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String hexDigest(String salt, File file) {
        String string;
        block8: {
            FileInputStream is = FileUtils.openInputStream((File)file);
            try {
                string = DigestUtil.hexDigest(salt, is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(DIGEST_COULD_NOT_BE_CALCULATED, e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String hexDigest(InputStream inputStream) {
        return DigestUtil.hexDigest(null, inputStream);
    }

    public static String hexDigest(@Nullable String salt, InputStream inputStream) {
        return Hex.encodeHexString((byte[])DigestUtil.md5(salt, inputStream));
    }

    public static String base64Digest(InputStream inputStream) {
        return DigestUtil.base64Digest(null, inputStream);
    }

    private static String base64Digest(@Nullable String salt, InputStream inputStream) {
        return Base64.encodeBase64String((byte[])DigestUtil.md5(salt, inputStream));
    }

    public static String base64Digest(byte[] binaryData) {
        return BinaryUtils.toBase64((byte[])binaryData);
    }

    private static byte[] md5(@Nullable String salt, InputStream inputStream) {
        MessageDigest messageDigest = DigestUtil.messageDigest(salt);
        try {
            return DigestUtils.updateDigest((MessageDigest)messageDigest, (InputStream)inputStream).digest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not update digest.", e);
        }
    }

    private static byte[] md5(@Nullable String salt, List<Path> paths) {
        MessageDigest md5 = DigestUtils.getMd5Digest();
        for (Path path : paths) {
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    md5.update(DigestUtil.md5(salt, inputStream));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read from path " + String.valueOf(path), e);
            }
        }
        return md5.digest();
    }

    private static MessageDigest messageDigest(@Nullable String salt) {
        MessageDigest messageDigest = DigestUtils.getMd5Digest();
        messageDigest.reset();
        if (salt != null) {
            DigestUtils.updateDigest((MessageDigest)messageDigest, (byte[])salt.getBytes(StandardCharsets.UTF_8));
        }
        return messageDigest;
    }
}

