/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.store.MultipartUploadInfo;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

@JsonRootName(value="CompleteMultipartUploadResult")
public record CompleteMultipartUploadResult(@JsonProperty(value="Bucket") String bucket, @JsonProperty(value="ChecksumCRC32") String checksumCRC32, @JsonProperty(value="ChecksumCRC32C") String checksumCRC32C, @JsonProperty(value="ChecksumCRC64NVME") String checksumCRC64NVME, @JsonProperty(value="ChecksumSHA1") String checksumSHA1, @JsonProperty(value="ChecksumSHA256") String checksumSHA256, @JsonProperty(value="ChecksumType") ChecksumType checksumType, @JsonProperty(value="ETag") String etag, @JsonProperty(value="Key") String key, @JsonProperty(value="Location") String location, @JacksonXmlProperty(isAttribute=true, localName="xmlns") String xmlns, @JsonIgnore MultipartUploadInfo multipartUploadInfo, @JsonIgnore String versionId, @JsonIgnore String checksum) {
    public CompleteMultipartUploadResult {
        etag = EtagUtil.normalizeEtag(etag);
        if (xmlns == null) {
            xmlns = "http://s3.amazonaws.com/doc/2006-03-01/";
        }
    }

    public static CompleteMultipartUploadResult from(String location, String bucket, String key, String etag, MultipartUploadInfo multipartUploadInfo, String checksum, ChecksumType checksumType, ChecksumAlgorithm checksumAlgorithm, String versionId) {
        String usedChecksum;
        ChecksumAlgorithm usedAlgorithm = checksumAlgorithm != null ? checksumAlgorithm : multipartUploadInfo.checksumAlgorithm();
        String string = usedChecksum = checksum != null ? checksum : multipartUploadInfo.checksum();
        if (usedChecksum == null) {
            return new CompleteMultipartUploadResult(bucket, null, null, null, null, null, checksumType, etag, key, location, null, multipartUploadInfo, versionId, null);
        }
        return switch (usedAlgorithm) {
            default -> throw new IncompatibleClassChangeError();
            case ChecksumAlgorithm.CRC32 -> new CompleteMultipartUploadResult(bucket, usedChecksum, null, null, null, null, checksumType, etag, key, location, null, multipartUploadInfo, versionId, checksum);
            case ChecksumAlgorithm.CRC32C -> new CompleteMultipartUploadResult(bucket, null, usedChecksum, null, null, null, checksumType, etag, key, location, null, multipartUploadInfo, versionId, checksum);
            case ChecksumAlgorithm.CRC64NVME -> new CompleteMultipartUploadResult(bucket, null, null, usedChecksum, null, null, checksumType, etag, key, location, null, multipartUploadInfo, versionId, checksum);
            case ChecksumAlgorithm.SHA1 -> new CompleteMultipartUploadResult(bucket, null, null, null, usedChecksum, null, checksumType, etag, key, location, null, multipartUploadInfo, versionId, checksum);
            case ChecksumAlgorithm.SHA256 -> new CompleteMultipartUploadResult(bucket, null, null, null, null, usedChecksum, checksumType, etag, key, location, null, multipartUploadInfo, versionId, checksum);
        };
    }
}

