/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.AccessControlPolicy;
import com.adobe.testing.s3mock.dto.Grant;
import com.adobe.testing.s3mock.dto.Grantee;
import com.adobe.testing.s3mock.dto.Owner;
import java.util.List;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;

public class CannedAclUtil {
    private CannedAclUtil() {
    }

    public static AccessControlPolicy policyForCannedAcl(ObjectCannedACL cannedAcl) {
        return switch (cannedAcl) {
            default -> throw new IncompatibleClassChangeError();
            case ObjectCannedACL.PRIVATE -> CannedAclUtil.privateAcl();
            case ObjectCannedACL.PUBLIC_READ -> CannedAclUtil.publicReadAcl();
            case ObjectCannedACL.PUBLIC_READ_WRITE -> CannedAclUtil.publicReadWriteAcl();
            case ObjectCannedACL.AWS_EXEC_READ -> CannedAclUtil.awsExecReadAcl();
            case ObjectCannedACL.AUTHENTICATED_READ -> CannedAclUtil.authenticatedReadAcl();
            case ObjectCannedACL.BUCKET_OWNER_READ -> CannedAclUtil.bucketOwnerReadAcl();
            case ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL -> CannedAclUtil.bucketOwnerFulleControlAcl();
            case ObjectCannedACL.UNKNOWN_TO_SDK_VERSION -> null;
        };
    }

    private static AccessControlPolicy bucketOwnerFulleControlAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL), new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER_BUCKET.getId(), Owner.DEFAULT_OWNER_BUCKET.getDisplayName(), null, null), Grant.Permission.READ)));
    }

    private static AccessControlPolicy bucketOwnerReadAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL), new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER_BUCKET.getId(), Owner.DEFAULT_OWNER_BUCKET.getDisplayName(), null, null), Grant.Permission.READ)));
    }

    private static AccessControlPolicy authenticatedReadAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL), new Grant(new Grantee.Group(null, null, null, Grantee.Group.AUTHENTICATED_USERS_URI), Grant.Permission.READ)));
    }

    private static AccessControlPolicy awsExecReadAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL)));
    }

    private static AccessControlPolicy publicReadWriteAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL), new Grant(new Grantee.Group(null, null, null, Grantee.Group.ALL_USERS_URI), Grant.Permission.READ), new Grant(new Grantee.Group(null, null, null, Grantee.Group.ALL_USERS_URI), Grant.Permission.WRITE)));
    }

    private static AccessControlPolicy publicReadAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL), new Grant(new Grantee.Group(null, null, null, Grantee.Group.ALL_USERS_URI), Grant.Permission.READ)));
    }

    private static AccessControlPolicy privateAcl() {
        return new AccessControlPolicy(Owner.DEFAULT_OWNER, List.of(new Grant(new Grantee.CanonicalUser(Owner.DEFAULT_OWNER.getId(), Owner.DEFAULT_OWNER.getDisplayName(), null, null), Grant.Permission.FULL_CONTROL)));
    }
}

