/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public abstract class AbstractAwsInputStream
extends InputStream {
    protected static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    protected static final byte[] DELIMITER = ";".getBytes(StandardCharsets.UTF_8);
    protected static final byte[] CHECKSUM_HEADER = "x-amz-checksum-".getBytes(StandardCharsets.UTF_8);
    protected long readDecodedLength = 0L;
    protected final InputStream source;
    protected long chunkLength = 0L;
    protected String checksum;
    protected ChecksumAlgorithm algorithm;
    protected int chunks = 0;
    private static final int MAX_CHUNK_SIZE = 262144;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(262144);
    protected final long decodedLength;

    protected AbstractAwsInputStream(InputStream source, long decodedLength) {
        this.source = new BufferedInputStream(source);
        this.decodedLength = decodedLength;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    protected byte[] readUntil(byte[] endSequence) throws IOException {
        this.byteBuffer.clear();
        while (!this.endsWith(this.byteBuffer.asReadOnlyBuffer(), endSequence)) {
            int c = this.source.read();
            if (c < 0) {
                return new byte[0];
            }
            byte unsigned = (byte)(c & 0xFF);
            this.byteBuffer.put(unsigned);
        }
        byte[] result = new byte[this.byteBuffer.position() - endSequence.length];
        this.byteBuffer.rewind();
        this.byteBuffer.get(result);
        return result;
    }

    protected boolean endsWith(ByteBuffer buffer, byte[] endSequence) {
        int pos = buffer.position();
        if (pos >= endSequence.length) {
            for (int i = 0; i < endSequence.length; ++i) {
                if (buffer.get(pos - endSequence.length + i) == endSequence[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setChunkLength(byte[] hexLengthBytes) {
        this.chunkLength = Long.parseLong(new String(hexLengthBytes, StandardCharsets.UTF_8).trim(), 16);
    }

    protected void extractAlgorithmAndChecksum() throws IOException {
        if (this.algorithm == null && this.checksum == null) {
            this.readUntil(CHECKSUM_HEADER);
            byte[] typeAndChecksum = this.readUntil(CRLF);
            String typeAndChecksumString = new String(typeAndChecksum);
            if (!typeAndChecksumString.isBlank()) {
                String[] split = typeAndChecksumString.split(":");
                String type = split[0];
                this.algorithm = ChecksumAlgorithm.fromString(type);
                this.checksum = split[1];
            }
        }
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ChecksumAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

