/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import java.util.Objects;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public record CopySource(String bucket, String key) {
    public static final String DELIMITER = "/";

    public CopySource(String copySource) {
        this(CopySource.extractBucketAndKeyArray(SdkHttpUtils.urlDecode((String)copySource))[0], CopySource.extractBucketAndKeyArray(SdkHttpUtils.urlDecode((String)copySource))[1]);
    }

    private static String[] extractBucketAndKeyArray(String copySource) {
        Objects.requireNonNull(copySource, "copySource == null");
        String source = CopySource.normalizeCopySource(copySource);
        String[] bucketAndKey = source.split(DELIMITER, 2);
        if (bucketAndKey.length != 2) {
            throw new IllegalArgumentException("Expected a copySource as '/{bucket}/{key}' but got: " + copySource);
        }
        return bucketAndKey;
    }

    private static String normalizeCopySource(String copySource) {
        if (copySource.startsWith(DELIMITER)) {
            return copySource.substring(1);
        }
        return copySource;
    }
}

