/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.CompleteMultipartUpload;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.CopySource;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.ObjectKey;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.service.BucketService;
import com.adobe.testing.s3mock.service.MultipartService;
import com.adobe.testing.s3mock.service.ObjectService;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.HeaderUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRange;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@CrossOrigin(origins={"*"}, exposedHeaders={"*"})
@Controller
@RequestMapping(value={"${com.adobe.testing.s3mock.contextPath:}"})
public class MultipartController {
    private final BucketService bucketService;
    private final ObjectService objectService;
    private final MultipartService multipartService;

    public MultipartController(BucketService bucketService, ObjectService objectService, MultipartService multipartService) {
        this.bucketService = bucketService;
        this.objectService = objectService;
        this.multipartService = multipartService;
    }

    @GetMapping(value={"/{bucketName:.+}", "/{bucketName:.+}/"}, params={"uploads"}, produces={"application/xml"})
    public ResponseEntity<ListMultipartUploadsResult> listMultipartUploads(@PathVariable String bucketName, @RequestParam(required=false) String prefix) {
        this.bucketService.verifyBucketExists(bucketName);
        return ResponseEntity.ok((Object)this.multipartService.listMultipartUploads(bucketName, prefix));
    }

    @DeleteMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId", "!lifecycle"}, produces={"application/xml"})
    public ResponseEntity<Void> abortMultipartUpload(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam String uploadId) {
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        this.multipartService.abortMultipartUpload(bucketName, key.key(), uploadId);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId"}, produces={"application/xml"})
    public ResponseEntity<ListPartsResult> listParts(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam String uploadId) {
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        return ResponseEntity.ok((Object)this.multipartService.getMultipartUploadParts(bucketName, key.key(), uploadId));
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range"})
    public ResponseEntity<Void> uploadPart(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader HttpHeaders httpHeaders, InputStream inputStream) {
        ChecksumAlgorithm algorithmFromHeader;
        Pair tempFileAndChecksum = this.multipartService.toTempFile(inputStream, httpHeaders);
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        this.multipartService.verifyPartNumberLimits(partNumber);
        String checksum = null;
        ChecksumAlgorithm checksumAlgorithm = null;
        ChecksumAlgorithm algorithmFromSdk = HeaderUtil.checksumAlgorithmFromSdk(httpHeaders);
        if (algorithmFromSdk != null) {
            checksum = (String)tempFileAndChecksum.getRight();
            checksumAlgorithm = algorithmFromSdk;
        }
        if ((algorithmFromHeader = HeaderUtil.checksumAlgorithmFromHeader(httpHeaders)) != null) {
            checksum = HeaderUtil.checksumFrom(httpHeaders);
            checksumAlgorithm = algorithmFromHeader;
        }
        Path tempFile = (Path)tempFileAndChecksum.getLeft();
        if (checksum != null) {
            this.multipartService.verifyChecksum(tempFile, checksum, checksumAlgorithm);
        }
        String etag = this.multipartService.putPart(bucketName, key.key(), uploadId, partNumber, tempFile, HeaderUtil.encryptionHeadersFrom(httpHeaders));
        FileUtils.deleteQuietly((File)tempFile.toFile());
        Map<String, String> checksumHeader = HeaderUtil.checksumHeaderFrom(checksum, checksumAlgorithm);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> h.setAll(checksumHeader))).headers(h -> h.setAll(HeaderUtil.encryptionHeadersFrom(httpHeaders)))).eTag("\"" + etag + "\"")).build();
    }

    @PutMapping(value={"/{bucketName:.+}/{*key}"}, headers={"x-amz-copy-source"}, params={"uploadId", "partNumber"}, produces={"application/xml"})
    public ResponseEntity<CopyPartResult> uploadPartCopy(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="x-amz-copy-source") CopySource copySource, @RequestHeader(value="x-amz-copy-source-range", required=false) HttpRange copyRange, @RequestHeader(value="x-amz-copy-source-if-match", required=false) List<String> match, @RequestHeader(value="x-amz-copy-source-if-none-match", required=false) List<String> noneMatch, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader HttpHeaders httpHeaders) {
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyPartNumberLimits(partNumber);
        S3ObjectMetadata s3ObjectMetadata = this.objectService.verifyObjectExists(copySource.bucket(), copySource.key());
        this.objectService.verifyObjectMatchingForCopy(match, noneMatch, s3ObjectMetadata);
        CopyPartResult result = this.multipartService.copyPart(copySource.bucket(), copySource.key(), copyRange, partNumber, bucketName, key.key(), uploadId, HeaderUtil.encryptionHeadersFrom(httpHeaders));
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploads"}, produces={"application/xml"})
    public ResponseEntity<InitiateMultipartUploadResult> createMultipartUpload(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestHeader(value="Content-Type", required=false) String contentType, @RequestHeader(value="x-amz-storage-class", required=false, defaultValue="STANDARD") StorageClass storageClass, @RequestHeader HttpHeaders httpHeaders, InputStream inputStream) {
        this.bucketService.verifyBucketExists(bucketName);
        try {
            IOUtils.consume((InputStream)inputStream);
        }
        catch (IOException e) {
            throw S3Exception.BAD_REQUEST_CONTENT;
        }
        InitiateMultipartUploadResult result = this.multipartService.createMultipartUpload(bucketName, key.key(), contentType, HeaderUtil.storeHeadersFrom(httpHeaders), Owner.DEFAULT_OWNER, Owner.DEFAULT_OWNER, HeaderUtil.userMetadataFrom(httpHeaders), HeaderUtil.encryptionHeadersFrom(httpHeaders), storageClass, HeaderUtil.checksumFrom(httpHeaders), HeaderUtil.checksumAlgorithmFromHeader(httpHeaders));
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping(value={"/{bucketName:.+}/{*key}"}, params={"uploadId"}, produces={"application/xml"})
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUpload(@PathVariable String bucketName, @PathVariable ObjectKey key, @RequestParam String uploadId, @RequestBody CompleteMultipartUpload upload, HttpServletRequest request, @RequestHeader HttpHeaders httpHeaders) {
        this.bucketService.verifyBucketExists(bucketName);
        this.multipartService.verifyMultipartUploadExists(bucketName, uploadId);
        this.multipartService.verifyMultipartParts(bucketName, key.key(), uploadId, upload.parts());
        String objectName = key.key();
        String locationWithEncodedKey = request.getRequestURL().toString().replace(objectName, SdkHttpUtils.urlEncode((String)objectName));
        CompleteMultipartUploadResult result = this.multipartService.completeMultipartUpload(bucketName, key.key(), uploadId, upload.parts(), HeaderUtil.encryptionHeadersFrom(httpHeaders), locationWithEncodedKey);
        String checksum = result.checksum();
        ChecksumAlgorithm checksumAlgorithm = result.multipartUploadInfo().checksumAlgorithm();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(h -> h.setAll(HeaderUtil.checksumHeaderFrom(checksum, checksumAlgorithm)))).body((Object)result);
    }
}

