/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.util.StringEncoding;
import java.util.Objects;

public final class ObjectRef {
    public static final String DELIMITER = "/";
    private final String bucket;
    private final String key;

    public ObjectRef(String copySource) {
        Objects.requireNonNull(copySource, "copySource == null");
        String[] bucketAndKey = ObjectRef.extractBucketAndKeyArray(StringEncoding.decode(copySource));
        this.bucket = bucketAndKey[0];
        this.key = StringEncoding.encode(bucketAndKey[1]);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return "ObjectRef{bucket='" + this.bucket + '\'' + ", key='" + this.key + '\'' + '}';
    }

    private static String[] extractBucketAndKeyArray(String copySource) {
        String source = ObjectRef.normalizeCopySource(copySource);
        String[] bucketAndKey = source.split(DELIMITER, 2);
        if (bucketAndKey.length != 2) {
            throw new IllegalArgumentException("Expected a copySource as '/{bucket}/{key}' but got: " + copySource);
        }
        return bucketAndKey;
    }

    private static String normalizeCopySource(String copySource) {
        if (copySource.startsWith(DELIMITER)) {
            return copySource.substring(1);
        }
        return copySource;
    }
}

