/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.Owner;
import java.net.URI;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Grantee")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class Grantee
extends Owner {
    @XmlElement(name="EmailAddress")
    private String emailAddress;
    @XmlElement(name="URI")
    private URI uri;

    public Grantee() {
    }

    public Grantee(String id, String displayName, String emailAddress, URI uri) {
        super(id, displayName);
        this.emailAddress = emailAddress;
        this.uri = uri;
    }

    public static Grantee from(Owner owner) {
        return new CanonicalUser(owner.getId(), owner.getDisplayName(), null, null);
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Grantee grantee = (Grantee)o;
        return Objects.equals(this.emailAddress, grantee.emailAddress) && Objects.equals(this.uri, grantee.uri);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.emailAddress, this.uri);
    }

    @XmlType(name="CanonicalUser")
    public static class CanonicalUser
    extends Grantee {
        public CanonicalUser() {
        }

        public CanonicalUser(String id, String displayName, String emailAddress, URI uri) {
            super(id, displayName, emailAddress, uri);
        }
    }

    @XmlType(name="AmazonCustomerByEmail")
    public static class AmazonCustomerByEmail
    extends Grantee {
        public AmazonCustomerByEmail() {
        }

        public AmazonCustomerByEmail(String id, String displayName, String emailAddress, URI uri) {
            super(id, displayName, emailAddress, uri);
        }
    }

    @XmlType(name="Group")
    public static class Group
    extends Grantee {
        public Group() {
        }

        public Group(String id, String displayName, String emailAddress, URI uri) {
            super(id, displayName, emailAddress, uri);
        }
    }
}

