/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.dto.ErrorResponse;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.filter.OncePerRequestFilter;

class KmsValidationFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(KmsValidationFilter.class);
    private static final String AWS_KMS = "aws:kms";
    private final KmsKeyStore keystore;
    private final MappingJackson2XmlHttpMessageConverter messageConverter;

    KmsValidationFilter(KmsKeyStore keystore, MappingJackson2XmlHttpMessageConverter messageConverter) {
        this.keystore = keystore;
        this.messageConverter = messageConverter;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            LOG.debug("Checking KMS key, if present.");
            String encryptionTypeHeader = request.getHeader("x-amz-server-side-encryption");
            String encryptionKeyId = request.getHeader("x-amz-server-side-encryption-aws-kms-key-id");
            if (AWS_KMS.equals(encryptionTypeHeader) && !StringUtils.isBlank((CharSequence)encryptionKeyId) && !this.keystore.validateKeyId(encryptionKeyId)) {
                LOG.info("Received invalid KMS key ID {}. Sending error response.", (Object)encryptionKeyId);
                request.getInputStream().close();
                response.setStatus(HttpStatus.BAD_REQUEST.value());
                response.setHeader("Content-Type", "application/xml");
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setCode("KMS.NotFoundException");
                errorResponse.setMessage("Key ID " + encryptionKeyId + " does not exist!");
                this.messageConverter.getObjectMapper().writeValue((OutputStream)response.getOutputStream(), (Object)errorResponse);
                response.flushBuffer();
            } else if (AWS_KMS.equals(encryptionTypeHeader) && !StringUtils.isBlank((CharSequence)encryptionKeyId) && this.keystore.validateKeyId(encryptionKeyId)) {
                LOG.info("Received valid KMS key ID {}.", (Object)encryptionKeyId);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Caught exception", (Throwable)e);
            throw e;
        }
        finally {
            LOG.debug("Finished checking KMS key.");
        }
    }
}

