/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

@XStreamAlias(value="CopyPartResult")
public class CopyPartResult {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));
    @XStreamAlias(value="LastModified")
    private final String lastModified;
    @XStreamAlias(value="ETag")
    private final String etag;

    public CopyPartResult(String lastModified, String etag) {
        this.lastModified = lastModified;
        this.etag = etag;
    }

    public static CopyPartResult from(Date date, String etag) {
        return new CopyPartResult(DATE_TIME_FORMATTER.format(date.toInstant()), etag);
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getEtag() {
        return this.etag;
    }
}

