/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.domain;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;

public class KMSKeyStore {
    @Value(value="${validKmsKeys:}")
    private final Set<String> defaultKeys = new HashSet<String>();
    private final Map<String, String> kmsKeys = new ConcurrentHashMap<String, String>();

    public void registerKMSKeyRef(String validKeyRef) {
        this.kmsKeys.put(validKeyRef, validKeyRef);
    }

    public boolean validateKeyRef(String keyRef) {
        return this.kmsKeys.containsKey(keyRef);
    }

    @PostConstruct
    private void addDefaultKeys() {
        this.defaultKeys.forEach(this::registerKMSKeyRef);
    }
}

