/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.FileStoreController;
import com.adobe.testing.s3mock.KMSValidationFilter;
import com.adobe.testing.s3mock.domain.Bucket;
import com.adobe.testing.s3mock.domain.FileStore;
import com.adobe.testing.s3mock.domain.KMSKeyStore;
import com.adobe.testing.s3mock.domain.Tag;
import com.adobe.testing.s3mock.dto.BatchDeleteRequest;
import com.adobe.testing.s3mock.dto.BatchDeleteResponse;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.ErrorResponse;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Tagging;
import com.adobe.testing.s3mock.util.ObjectRefConverter;
import com.adobe.testing.s3mock.util.RangeConverter;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.Banner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.servlet.filter.OrderedHttpPutFormContentFilter;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableAutoConfiguration(exclude={SecurityAutoConfiguration.class})
@ComponentScan
public class S3MockApplication {
    public static final int DEFAULT_HTTPS_PORT = 9191;
    public static final int DEFAULT_HTTP_PORT = 9090;
    public static final int RANDOM_PORT = 0;
    public static final String PROP_INITIAL_BUCKETS = "initialBuckets";
    public static final String PROP_ROOT_DIRECTORY = "root";
    public static final String PROP_HTTPS_PORT = "server.port";
    public static final String PROP_HTTP_PORT = "http.port";
    public static final String PROP_SILENT = "silent";
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreController.class);
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private FileStore fileStore;
    @Autowired
    private KMSKeyStore kmsKeyStore;
    @Autowired
    private Environment environment;
    @Autowired
    private Config config;

    public static void main(String[] args) {
        S3MockApplication.start(args);
    }

    public static S3MockApplication start(String ... args) {
        return S3MockApplication.start(Collections.emptyMap(), args);
    }

    public static S3MockApplication start(Map<String, Object> properties, String ... args) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put(PROP_HTTPS_PORT, 9191);
        defaults.put(PROP_HTTP_PORT, 9090);
        Banner.Mode bannerMode = Banner.Mode.CONSOLE;
        if (Boolean.valueOf(String.valueOf(properties.remove(PROP_SILENT))).booleanValue()) {
            defaults.put("logging.level.root", "WARN");
            bannerMode = Banner.Mode.OFF;
        }
        ConfigurableApplicationContext ctx = new SpringApplicationBuilder(new Class[]{S3MockApplication.class}).properties(defaults).properties(properties).bannerMode(bannerMode).run(args);
        return (S3MockApplication)ctx.getBean(S3MockApplication.class);
    }

    public void stop() {
        SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    public int getPort() {
        return Integer.parseInt(this.environment.getProperty("local.server.port"));
    }

    public int getHttpPort() {
        return this.config.getHttpConnector().getLocalPort();
    }

    public void registerKMSKeyRef(String keyRef) {
        this.kmsKeyStore.registerKMSKeyRef(keyRef);
    }

    @PostConstruct
    void initBuckets() throws IOException {
        List buckets = Arrays.stream(this.config.getInitialBuckets().trim().split("[,; ]")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        LOG.info("Creating initial buckets: " + buckets);
        for (String bucketName : buckets) {
            LOG.info("Creating bucket: " + bucketName);
            this.fileStore.createBucket(bucketName);
        }
    }

    @Configuration
    static class Config
    implements WebMvcConfigurer {
        @Value(value="${http.port}")
        private int httpPort;
        @Value(value="${initialBuckets:}")
        private String initialBuckets;
        private Connector httpConnector;

        Config() {
        }

        @Bean
        ServletWebServerFactory webServerFactory() {
            TomcatServletWebServerFactory tomcat = new TomcatServletWebServerFactory();
            tomcat.addAdditionalTomcatConnectors(new Connector[]{this.createHttpConnector()});
            return tomcat;
        }

        private Connector createHttpConnector() {
            this.httpConnector = new Connector("org.apache.coyote.http11.Http11NioProtocol");
            this.httpConnector.setPort(this.httpPort);
            return this.httpConnector;
        }

        private Connector getHttpConnector() {
            return this.httpConnector;
        }

        @Bean
        KMSKeyStore kmsKeyStore() {
            return new KMSKeyStore();
        }

        @Bean
        RangeConverter rangeConverter() {
            return new RangeConverter();
        }

        @Bean
        ObjectRefConverter objectRefConverter() {
            return new ObjectRefConverter();
        }

        @Bean
        Filter kmsFilter(KMSKeyStore kmsKeyStore) {
            return new KMSValidationFilter(kmsKeyStore);
        }

        public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
            configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_FORM_URLENCODED});
            configurer.favorPathExtension(false);
            configurer.mediaType("xml", MediaType.TEXT_XML);
        }

        @Bean
        public MarshallingHttpMessageConverter getMessageConverter(XStreamMarshaller xstreamMarshaller) {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(MediaType.APPLICATION_XML);
            mediaTypes.add(MediaType.APPLICATION_FORM_URLENCODED);
            MarshallingHttpMessageConverter xmlConverter = new MarshallingHttpMessageConverter();
            xmlConverter.setSupportedMediaTypes(mediaTypes);
            xmlConverter.setMarshaller((Marshaller)xstreamMarshaller);
            xmlConverter.setUnmarshaller((Unmarshaller)xstreamMarshaller);
            return xmlConverter;
        }

        @Bean
        XStreamMarshaller getXStreamMarshaller() {
            final Class[] supportedClasses = new Class[]{BatchDeleteRequest.class, BatchDeleteRequest.ObjectToDelete.class, BatchDeleteResponse.class, Bucket.class, CompleteMultipartUploadResult.class, CopyObjectResult.class, CopyPartResult.class, ErrorResponse.class, InitiateMultipartUploadResult.class, ListAllMyBucketsResult.class, ListBucketResult.class, ListMultipartUploadsResult.class, ListPartsResult.class, Owner.class, Tagging.class, Tag.class};
            XStreamMarshaller xstreamMarshaller = new XStreamMarshaller(){

                protected void customizeXStream(XStream xstream) {
                    XStream.setupDefaultSecurity((XStream)xstream);
                    xstream.allowTypes(supportedClasses);
                }
            };
            xstreamMarshaller.setSupportedClasses(supportedClasses);
            xstreamMarshaller.setAnnotatedClasses(supportedClasses);
            return xstreamMarshaller;
        }

        @Bean
        OrderedHttpPutFormContentFilter httpPutFormContentFilter() {
            return new OrderedHttpPutFormContentFilter(){

                protected boolean shouldNotFilter(HttpServletRequest request) {
                    return true;
                }
            };
        }

        String getInitialBuckets() {
            return this.initialBuckets;
        }
    }
}

