/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.domain.KMSKeyStore;
import com.adobe.testing.s3mock.dto.ErrorResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.oxm.xstream.XStreamMarshaller;
import org.springframework.web.filter.OncePerRequestFilter;

class KMSValidationFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(KMSValidationFilter.class);
    private final KMSKeyStore keystore;
    @Autowired
    private XStreamMarshaller marshaller;

    public KMSValidationFilter(KMSKeyStore keystore) {
        this.keystore = keystore;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            LOG.debug("Checking KMS key, if present.");
            String encryptionTypeHeader = request.getHeader("x-amz-server-side-encryption");
            String encryptionKeyRef = request.getHeader("x-amz-server-side-encryption-aws-kms-key-id");
            if ("aws:kms".equals(encryptionTypeHeader) && !this.keystore.validateKeyRef(encryptionKeyRef)) {
                LOG.debug("Received invalid key, sending error response.");
                request.getInputStream().close();
                response.setStatus(HttpStatus.BAD_REQUEST.value());
                response.setHeader("Content-Type", "application/xml");
                ErrorResponse errorResponse = new ErrorResponse();
                errorResponse.setCode("KMS.NotFoundException");
                errorResponse.setMessage("Key " + encryptionKeyRef + " does not exist!");
                this.marshaller.marshalOutputStream((Object)errorResponse, (OutputStream)response.getOutputStream());
                response.flushBuffer();
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        catch (RuntimeException e) {
            LOG.error("Caught exception", (Throwable)e);
            throw e;
        }
        finally {
            LOG.debug("Finished checking KMS key.");
        }
    }
}

