/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock;

import com.adobe.testing.s3mock.domain.Bucket;
import com.adobe.testing.s3mock.domain.BucketContents;
import com.adobe.testing.s3mock.domain.FileStore;
import com.adobe.testing.s3mock.domain.S3Exception;
import com.adobe.testing.s3mock.domain.S3Object;
import com.adobe.testing.s3mock.domain.Tag;
import com.adobe.testing.s3mock.dto.BatchDeleteRequest;
import com.adobe.testing.s3mock.dto.BatchDeleteResponse;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CopyObjectResult;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.DeletedObject;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListAllMyBucketsResult;
import com.adobe.testing.s3mock.dto.ListBucketResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.ObjectRef;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Range;
import com.adobe.testing.s3mock.dto.Tagging;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
class FileStoreController {
    private static final String ANY = "*";
    private static final String RANGES_BYTES = "bytes";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final String HEADER_X_AMZ_CONTENT_SHA256 = "x-amz-content-sha256";
    private static final String HEADER_X_AMZ_META_PREFIX = "x-amz-meta-";
    private static final String ABSENT_ENCRYPTION = null;
    private static final String ABSENT_KEY_ID = null;
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreController.class);
    private static final Owner TEST_OWNER = new Owner(123L, "s3-mock-file-store");
    @Autowired
    private FileStore fileStore;

    FileStoreController() {
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/x-www-form-urlencoded"})
    @ResponseBody
    public ListAllMyBucketsResult listBuckets() {
        return new ListAllMyBucketsResult(TEST_OWNER, this.fileStore.listBuckets());
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putBucket(@PathVariable String bucketName) {
        try {
            this.fileStore.createBucket(bucketName);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (IOException e) {
            LOG.error("Bucket could not be created!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.HEAD})
    public ResponseEntity<String> headBucket(@PathVariable String bucketName) {
        if (this.fileStore.doesBucketExist(bucketName).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{bucketName}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteBucket(@PathVariable String bucketName) {
        boolean deleted;
        this.verifyBucketExistence(bucketName);
        try {
            deleted = this.fileStore.deleteBucket(bucketName);
        }
        catch (IOException e) {
            LOG.error("Bucket could not be deleted!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (deleted) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.HEAD})
    public ResponseEntity<String> headObject(@PathVariable String bucketName, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        S3Object s3Object = this.fileStore.getS3Object(bucketName, filename);
        if (s3Object != null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setContentLength(Long.valueOf(s3Object.getSize()).longValue());
            if (!"".equals(s3Object.getContentType())) {
                responseHeaders.setContentType(MediaType.parseMediaType((String)s3Object.getContentType()));
            }
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            if (s3Object.isEncrypted()) {
                responseHeaders.add("x-amz-server-side-encryption-aws-kms-key-id", s3Object.getKmsKeyId());
            }
            this.addUserMetadata((arg_0, arg_1) -> ((HttpHeaders)responseHeaders).add(arg_0, arg_1), s3Object);
            return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{bucketName}/"}, method={RequestMethod.GET}, produces={"application/x-www-form-urlencoded"})
    @ResponseBody
    public ListBucketResult listObjectsInsideBucket(@PathVariable String bucketName, @RequestParam(required=false) String prefix, HttpServletResponse response) throws IOException {
        this.verifyBucketExistence(bucketName);
        try {
            ArrayList<BucketContents> contents = new ArrayList<BucketContents>();
            List<S3Object> s3Objects = this.fileStore.getS3Objects(bucketName, prefix);
            LOG.debug(String.format("Found %s objects in bucket %s", s3Objects.size(), bucketName));
            for (S3Object s3Object : s3Objects) {
                contents.add(new BucketContents(s3Object.getName(), s3Object.getModificationDate(), s3Object.getMd5(), s3Object.getSize(), "STANDARD", TEST_OWNER));
            }
            return new ListBucketResult(bucketName, prefix, null, "1000", false, contents, null);
        }
        catch (IOException e) {
            LOG.error(String.format("Object(s) could not retrieved from bucket %s", bucketName));
            response.sendError(500, e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObject(@PathVariable String bucketName, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        try (ServletInputStream inputStream = request.getInputStream();){
            Map<String, String> userMetadata = this.getUserMetadata(request);
            S3Object s3Object = this.fileStore.putS3Object(bucketName, filename, request.getContentType(), (InputStream)inputStream, this.isV4SigningEnabled(request), userMetadata);
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            this.addUserMetadata((arg_0, arg_1) -> ((HttpHeaders)responseHeaders).add(arg_0, arg_1), s3Object);
            ResponseEntity responseEntity = new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
            return responseEntity;
        }
        catch (IOException e) {
            LOG.error("Object could not be saved!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private Map<String, String> getUserMetadata(HttpServletRequest request) {
        return Collections.list(request.getHeaderNames()).stream().filter(header -> header.startsWith(HEADER_X_AMZ_META_PREFIX)).collect(Collectors.toMap(header -> header.substring(HEADER_X_AMZ_META_PREFIX.length()), arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
    }

    private boolean isV4SigningEnabled(HttpServletRequest request) {
        String sha256Header = request.getHeader(HEADER_X_AMZ_CONTENT_SHA256);
        return sha256Header != null && !sha256Header.equals(UNSIGNED_PAYLOAD);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, headers={"x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObjectEncrypted(@PathVariable String bucketName, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id") String kmsKeyId, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        try (ServletInputStream inputStream = request.getInputStream();){
            Map<String, String> userMetadata = this.getUserMetadata(request);
            S3Object s3Object = this.fileStore.putS3ObjectWithKMSEncryption(bucketName, filename, request.getContentType(), (InputStream)inputStream, this.isV4SigningEnabled(request), userMetadata, encryption, kmsKeyId);
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            responseHeaders.add("x-amz-server-side-encryption-aws-kms-key-id", kmsKeyId);
            ResponseEntity responseEntity = new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
            return responseEntity;
        }
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "!x-amz-server-side-encryption"}, produces={"application/x-www-form-urlencoded; charset=utf-8"})
    @ResponseBody
    public CopyObjectResult copyObject(@PathVariable String destinationBucket, @RequestHeader(value="x-amz-copy-source") ObjectRef objectRef, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.copyObject(destinationBucket, objectRef, ABSENT_ENCRYPTION, ABSENT_KEY_ID, request, response);
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "x-amz-server-side-encryption"}, produces={"application/x-www-form-urlencoded; charset=utf-8"})
    @ResponseBody
    public CopyObjectResult copyObject(@PathVariable String destinationBucket, @RequestHeader(value="x-amz-copy-source") ObjectRef objectRef, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.verifyBucketExistence(destinationBucket);
        String destinationFile = FileStoreController.filenameFrom(destinationBucket, request);
        CopyObjectResult copyObjectResult = this.fileStore.copyS3ObjectEncrypted(objectRef.getBucket(), objectRef.getKey(), destinationBucket, destinationFile, encryption, kmsKeyId);
        response.addHeader("x-amz-server-side-encryption-aws-kms-key-id", kmsKeyId);
        if (copyObjectResult == null) {
            response.sendError(404, String.format("Could not find source File %s in Bucket %s!", objectRef.getBucket(), objectRef.getKey()));
        }
        return copyObjectResult;
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.GET}, produces={"application/x-www-form-urlencoded"})
    public void getObject(@PathVariable String bucketName, @RequestHeader(value="Range", required=false) Range range, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        if (range != null) {
            this.getObjectWithRange(response, range, s3Object);
        } else {
            response.setHeader("ETag", "\"" + s3Object.getMd5() + "\"");
            response.setContentType(s3Object.getContentType());
            response.setContentLengthLong(s3Object.getDataFile().length());
            response.setHeader("Accept-Ranges", RANGES_BYTES);
            response.setHeader("Access-Control-Allow-Origin", ANY);
            this.addUserMetadata((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1), s3Object);
            try (ServletOutputStream outputStream = response.getOutputStream();){
                Files.copy(s3Object.getDataFile().toPath(), (OutputStream)outputStream);
            }
        }
    }

    private void addUserMetadata(BiConsumer<String, String> responseHeaders, S3Object s3Object) {
        if (s3Object.getUserMetadata() != null) {
            s3Object.getUserMetadata().forEach((key, value) -> responseHeaders.accept(HEADER_X_AMZ_META_PREFIX + key, (String)value));
        }
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteObject(@PathVariable String bucketName, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        try {
            this.fileStore.deleteObject(bucketName, filename);
        }
        catch (IOException e) {
            LOG.error("Object could not be deleted!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{bucketName}"}, params={"delete"}, method={RequestMethod.POST}, produces={"application/x-www-form-urlencoded"})
    public BatchDeleteResponse batchDeleteObjects(@PathVariable String bucketName, @RequestBody BatchDeleteRequest body) {
        this.verifyBucketExistence(bucketName);
        BatchDeleteResponse response = new BatchDeleteResponse();
        for (BatchDeleteRequest.ObjectToDelete object : body.getObjectsToDelete()) {
            this.verifyObjectExistence(bucketName, object.getKey());
            try {
                this.fileStore.deleteObject(bucketName, object.getKey());
                DeletedObject deletedObject = new DeletedObject();
                deletedObject.setKey(object.getKey());
                response.addDeletedObject(deletedObject);
            }
            catch (IOException e) {
                LOG.error("Object could not be deleted!", (Throwable)e);
            }
        }
        return response;
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"tagging"}, method={RequestMethod.GET})
    public ResponseEntity<Tagging> getObjectTagging(@PathVariable String bucketName, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        tagList.addAll(s3Object.getTags());
        Tagging result = new Tagging(tagList);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
        responseHeaders.setLastModified(s3Object.getLastModified());
        return ResponseEntity.ok((Object)result);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"tagging"}, method={RequestMethod.PUT})
    public ResponseEntity<String> putObjectTagging(@PathVariable String bucketName, @RequestBody Tagging body, HttpServletRequest request) {
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.verifyBucketExistence(bucketName);
        S3Object s3Object = this.verifyObjectExistence(bucketName, filename);
        try {
            this.fileStore.setObjectTags(bucketName, filename, body.getTagSet());
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.setETag("\"" + s3Object.getMd5() + "\"");
            responseHeaders.setLastModified(s3Object.getLastModified());
            return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (IOException e) {
            LOG.error("Tags could not be set!", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploads"}, method={RequestMethod.POST}, produces={"application/x-www-form-urlencoded"})
    public InitiateMultipartUploadResult initiateMultipartUpload(@PathVariable String bucketName, HttpServletRequest request) {
        return this.initiateMultipartUpload(bucketName, ABSENT_ENCRYPTION, ABSENT_KEY_ID, request);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploads"}, headers={"x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"}, method={RequestMethod.POST}, produces={"application/x-www-form-urlencoded"})
    public InitiateMultipartUploadResult initiateMultipartUpload(@PathVariable String bucketName, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id") String kmsKeyId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        Map<String, String> userMetadata = this.getUserMetadata(request);
        String uploadId = UUID.randomUUID().toString();
        this.fileStore.prepareMultipartUpload(bucketName, filename, request.getContentType(), uploadId, TEST_OWNER, TEST_OWNER, userMetadata);
        return new InitiateMultipartUploadResult(bucketName, filename, uploadId);
    }

    @RequestMapping(value={"/{bucketName:.+}/"}, params={"uploads"}, method={RequestMethod.GET}, produces={"application/x-www-form-urlencoded"})
    public ListMultipartUploadsResult listMultipartUploads(@PathVariable String bucketName, @RequestParam String uploads) {
        this.verifyBucketExistence(bucketName);
        ArrayList<MultipartUpload> multipartUploads = new ArrayList<MultipartUpload>(this.fileStore.listMultipartUploads());
        int maxUploads = Math.max(1000, multipartUploads.size());
        boolean isTruncated = false;
        String uploadIdMarker = null;
        String nextUploadIdMarker = null;
        String keyMarker = null;
        String nextKeyMarker = null;
        String delimiter = null;
        String prefix = null;
        List<String> commmonPrefixes = Collections.emptyList();
        return new ListMultipartUploadsResult(bucketName, keyMarker, delimiter, prefix, uploadIdMarker, maxUploads, false, nextKeyMarker, nextUploadIdMarker, multipartUploads, commmonPrefixes);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.DELETE}, produces={"application/x-www-form-urlencoded"})
    public void abortMultipartUpload(@PathVariable String bucketName, @RequestParam(required=true) String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        this.fileStore.abortMultipartUpload(bucketName, filename, uploadId);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId", "part-number-marker"}, method={RequestMethod.GET}, produces={"application/x-www-form-urlencoded"})
    public ListPartsResult multipartListParts(@PathVariable String bucketName, @RequestParam String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        return new ListPartsResult(bucketName, filename, uploadId);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range", "x-amz-server-side-encryption"}, method={RequestMethod.PUT})
    public ResponseEntity<CopyPartResult> putObjectPart(@PathVariable String bucketName, @RequestParam String uploadId, @RequestParam String partNumber, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        String etag = this.fileStore.putPart(bucketName, filename, uploadId, partNumber, (InputStream)request.getInputStream(), this.isV4SigningEnabled(request));
        HttpHeaders responseHeaders = new HttpHeaders();
        String quotedEtag = "\"" + etag + "\"";
        responseHeaders.setETag(quotedEtag);
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId", "partNumber"}, headers={"!x-amz-copy-source", "!x-amz-copy-source-range"}, method={RequestMethod.PUT})
    public ResponseEntity<CopyPartResult> putObjectPart(@PathVariable String bucketName, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        return this.putObjectPart(bucketName, uploadId, partNumber, ABSENT_ENCRYPTION, ABSENT_KEY_ID, request);
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "x-amz-copy-source-range", "x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"})
    public ResponseEntity<CopyPartResult> copyObjectPart(@RequestHeader(value="x-amz-copy-source") ObjectRef copySource, @RequestHeader(value="x-amz-copy-source-range") Range copyRange, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id", required=false) String kmsKeyId, @PathVariable String destinationBucket, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        this.verifyBucketExistence(destinationBucket);
        String destinationFile = FileStoreController.filenameFrom(destinationBucket, request);
        String partEtag = this.fileStore.copyPart(copySource.getBucket(), copySource.getKey(), (int)copyRange.getStart(), (int)copyRange.getEnd(), this.isV4SigningEnabled(request), partNumber, destinationBucket, destinationFile, uploadId);
        return ResponseEntity.ok((Object)CopyPartResult.from(new Date(), "\"" + partEtag + "\""));
    }

    @RequestMapping(value={"/{destinationBucket:.+}/**"}, method={RequestMethod.PUT}, headers={"x-amz-copy-source", "x-amz-copy-source-range", "!x-amz-server-side-encryption"})
    public ResponseEntity<CopyPartResult> copyObjectPart(@RequestHeader(value="x-amz-copy-source") ObjectRef copySource, @RequestHeader(value="x-amz-copy-source-range") Range copyRange, @PathVariable String destinationBucket, @RequestParam String uploadId, @RequestParam String partNumber, HttpServletRequest request) throws IOException {
        return this.copyObjectPart(copySource, copyRange, ABSENT_ENCRYPTION, ABSENT_KEY_ID, destinationBucket, uploadId, partNumber, request);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, params={"uploadId"}, method={RequestMethod.POST})
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUpload(@PathVariable String bucketName, @RequestParam String uploadId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        String eTag = this.fileStore.completeMultipartUpload(bucketName, filename, uploadId);
        return new ResponseEntity((Object)new CompleteMultipartUploadResult(request.getRequestURL().toString(), bucketName, filename, eTag), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    @RequestMapping(value={"/{bucketName:.+}/**"}, headers={"x-amz-server-side-encryption", "x-amz-server-side-encryption-aws-kms-key-id"}, params={"uploadId"}, method={RequestMethod.POST})
    public ResponseEntity<CompleteMultipartUploadResult> completeMultipartUploadEncrypted(@PathVariable String bucketName, @RequestParam String uploadId, @RequestHeader(value="x-amz-server-side-encryption") String encryption, @RequestHeader(value="x-amz-server-side-encryption-aws-kms-key-id") String kmsKeyId, HttpServletRequest request) {
        this.verifyBucketExistence(bucketName);
        String filename = FileStoreController.filenameFrom(bucketName, request);
        String eTag = this.fileStore.completeMultipartUpload(bucketName, filename, uploadId, encryption, kmsKeyId);
        return new ResponseEntity((Object)new CompleteMultipartUploadResult(request.getRequestURL().toString(), bucketName, filename, eTag), (MultiValueMap)new HttpHeaders(), HttpStatus.OK);
    }

    private void getObjectWithRange(HttpServletResponse response, Range range, S3Object s3Object) throws IOException {
        long fileSize = s3Object.getDataFile().length();
        long bytesToRead = Math.min(fileSize - 1L, range.getEnd()) - range.getStart() + 1L;
        if (bytesToRead < 0L || fileSize < range.getStart()) {
            response.setStatus(HttpStatus.REQUESTED_RANGE_NOT_SATISFIABLE.value());
            response.flushBuffer();
            return;
        }
        response.setStatus(HttpStatus.PARTIAL_CONTENT.value());
        response.setHeader("Accept-Ranges", RANGES_BYTES);
        response.setHeader("Content-Range", String.format("bytes %s-%s", range.getStart(), bytesToRead + range.getStart() - 1L));
        response.setHeader("ETag", "\"" + s3Object.getMd5() + "\"");
        response.setDateHeader("Last-Modified", s3Object.getLastModified());
        response.setContentType(s3Object.getContentType());
        response.setContentLengthLong(bytesToRead);
        this.addUserMetadata((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1), s3Object);
        try (ServletOutputStream outputStream = response.getOutputStream();
             FileInputStream fis = new FileInputStream(s3Object.getDataFile());){
            fis.skip(range.getStart());
            IOUtils.copy((InputStream)new BoundedInputStream((InputStream)fis, bytesToRead), (OutputStream)outputStream);
        }
    }

    private static String filenameFrom(@PathVariable String bucketName, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        return requestURI.substring(requestURI.indexOf(bucketName) + bucketName.length() + 1);
    }

    private S3Object verifyObjectExistence(@PathVariable String bucketName, String filename) {
        S3Object s3Object = this.fileStore.getS3Object(bucketName, filename);
        if (s3Object == null) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchKey", "The specified key does not exist.");
        }
        return s3Object;
    }

    private void verifyBucketExistence(String bucketName) {
        Bucket bucket = this.fileStore.getBucket(bucketName);
        if (bucket == null) {
            throw new S3Exception(HttpStatus.NOT_FOUND.value(), "NoSuchBucket", "The specified bucket does not exist.");
        }
    }
}

