/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.workflows.CustomWorkflowAgreementCreationRequest;
import com.adobe.sign.model.workflows.CustomWorkflowFileInfo;
import com.adobe.sign.model.workflows.DocumentCreationInfo;
import com.adobe.sign.model.workflows.PostSignOptions;
import com.adobe.sign.model.workflows.RecipientInfo;
import com.adobe.sign.model.workflows.RecipientsInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.List;

public class WorkflowsApiValidator {
    private static final String CUSTOM_WORKFLOW_AGREEMENT_CREATION_REQUEST = "customWorkflowAgreementCreationRequest";
    private static final String DOCUMENT_CREATION_INFO = "documentCreationInfo";
    private static final String NAME = "name";
    private static final String RECIPIENTS = "recipients";

    public static void getWorkflowsValidator(Boolean includeDraftWorkflows, String groupId) throws ApiException {
        if (groupId != null) {
            ApiValidatorHelper.validateId(groupId, SdkErrorCodes.INVALID_GROUP_ID);
        }
    }

    public static void getWorkflowInfoValidator(String workflowId) throws ApiException {
        ApiValidatorHelper.validateId(workflowId, SdkErrorCodes.INVALID_WORKFLOW_ID);
    }

    public static void createWorkflowAgreementValidator(String workflowId, CustomWorkflowAgreementCreationRequest customWorkflowAgreementCreationRequest) throws ApiException {
        ApiValidatorHelper.validateId(workflowId, SdkErrorCodes.INVALID_WORKFLOW_ID);
        ApiValidatorHelper.validateParameter(customWorkflowAgreementCreationRequest, CUSTOM_WORKFLOW_AGREEMENT_CREATION_REQUEST);
        DocumentCreationInfo documentCreationInfo = customWorkflowAgreementCreationRequest.getDocumentCreationInfo();
        ApiValidatorHelper.validateParameter(documentCreationInfo, DOCUMENT_CREATION_INFO);
        ApiValidatorHelper.validateParameter(documentCreationInfo.getName(), NAME);
        List<CustomWorkflowFileInfo> fileInfos = documentCreationInfo.getFileInfos();
        if (fileInfos == null) {
            throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
        }
        for (CustomWorkflowFileInfo fileInfo : fileInfos) {
            if (fileInfo == null) {
                throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
            }
            ApiValidatorHelper.validateParameter(fileInfo.getName(), SdkErrorCodes.FILE_INFO_NAME_MISSING);
            if (fileInfo.getTransientDocumentId() != null) {
                ApiValidatorHelper.validateId(fileInfo.getTransientDocumentId(), SdkErrorCodes.INVALID_TRANSIENTDOCUMENT_ID);
            }
            if (fileInfo.getWorkflowLibraryDocumentId() == null) continue;
            ApiValidatorHelper.validateId(fileInfo.getWorkflowLibraryDocumentId(), SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
        }
        WorkflowsApiValidator.validatePostSignOptions(documentCreationInfo.getPostSignOptions());
        List<RecipientsInfo> recipientSetInfos = documentCreationInfo.getRecipientsListInfo();
        WorkflowsApiValidator.validateRecipientSetInfos(recipientSetInfos);
    }

    private static void validateRecipientSetInfos(List<RecipientsInfo> recipientSetInfos) throws ApiException {
        for (RecipientsInfo recipientSetInfo : recipientSetInfos) {
            ApiValidatorHelper.validateParameter(recipientSetInfo.getRecipients(), RECIPIENTS);
            List<RecipientInfo> recipientInfos = recipientSetInfo.getRecipients();
            int numberOfRecipients = recipientInfos.size();
            for (RecipientInfo recipientInfo : recipientInfos) {
                ApiValidatorHelper.validateWorkflowRecipientSetInfos(recipientInfo.getEmail(), recipientInfo.getFax(), numberOfRecipients);
            }
        }
    }

    private static void validatePostSignOptions(PostSignOptions postSignOptions) throws ApiException {
        if (postSignOptions == null) {
            return;
        }
        ApiValidatorHelper.validatePostSignOptions(postSignOptions.getRedirectUrl(), postSignOptions.getRedirectDelay());
    }
}

