/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.megaSigns.FileInfo;
import com.adobe.sign.model.megaSigns.MegaSignCreationInfo;
import com.adobe.sign.model.megaSigns.MegaSignCreationRequest;
import com.adobe.sign.model.megaSigns.MegaSignStatusUpdateInfo;
import com.adobe.sign.model.megaSigns.PostSignOptions;
import com.adobe.sign.model.megaSigns.RecipientInfo;
import com.adobe.sign.model.megaSigns.RecipientSetInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.List;

public class MegaSignsApiValidator {
    private static final String MEGA_SIGN_CREATION_REQUEST = "megaSignCreationRequest";
    private static final String MEGA_SIGN_CREATION_INFO = "megasignCreationInfo";
    private static final String NAME = "name";
    private static final String SIGNATURE_TYPE = "signatureType";
    private static final String MEGA_SIGN_STATUS_UPDATE_INFO = "megaSignStatusUpdateInfo";
    private static final String RECIPIENT_SET_MEMBER_INFOS = "recipientSetMemberInfos";

    public static void getMegaSignsValidator(String query) throws ApiException {
    }

    public static void createMegaSignValidator(MegaSignCreationRequest megaSignCreationRequest) throws ApiException {
        ApiValidatorHelper.validateParameter(megaSignCreationRequest, MEGA_SIGN_CREATION_REQUEST);
        MegaSignCreationInfo megasignCreationInfo = megaSignCreationRequest.getMegaSignCreationInfo();
        ApiValidatorHelper.validateParameter(megasignCreationInfo, MEGA_SIGN_CREATION_INFO);
        List<FileInfo> fileInfos = megasignCreationInfo.getFileInfos();
        MegaSignsApiValidator.validateFileInfo(fileInfos);
        ApiValidatorHelper.validateParameter(megasignCreationInfo.getName(), NAME);
        MegaSignsApiValidator.validatePostSignOptions(megasignCreationInfo.getPostSignOptions());
        List<RecipientSetInfo> recipientSetInfos = megasignCreationInfo.getRecipientSetInfos();
        if (recipientSetInfos != null) {
            MegaSignsApiValidator.validateRecipientSetInfos(recipientSetInfos);
        }
        ApiValidatorHelper.validateParameter(megasignCreationInfo.getSignatureType(), SIGNATURE_TYPE);
    }

    public static void getMegaSignInfoValidator(String megaSignId) throws ApiException {
        ApiValidatorHelper.validateId(megaSignId, SdkErrorCodes.INVALID_MEGASIGN_ID);
    }

    public static void getMegaSignChildAgreementsValidator(String megaSignId) throws ApiException {
        ApiValidatorHelper.validateId(megaSignId, SdkErrorCodes.INVALID_MEGASIGN_ID);
    }

    public static void getMegaSignFormDataValidator(String megaSignId) throws ApiException {
        ApiValidatorHelper.validateId(megaSignId, SdkErrorCodes.INVALID_MEGASIGN_ID);
    }

    public static void updateMegaSignStatusValidator(String megaSignId, MegaSignStatusUpdateInfo megaSignStatusUpdateInfo) throws ApiException {
        ApiValidatorHelper.validateId(megaSignId, SdkErrorCodes.INVALID_MEGASIGN_ID);
        ApiValidatorHelper.validateParameter(megaSignStatusUpdateInfo, MEGA_SIGN_STATUS_UPDATE_INFO);
        String updateValue = megaSignStatusUpdateInfo.getValue() == null ? "" : megaSignStatusUpdateInfo.getValue().toString();
        ApiValidatorHelper.validateParameter(updateValue, SdkErrorCodes.INVALID_MEGASIGN_STATUS);
    }

    private static void validateFileInfo(List<FileInfo> fileInfos) throws ApiException {
        if (fileInfos == null) {
            throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
        }
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo == null) {
                throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
            }
            String url = fileInfo.getDocumentURL() == null ? null : fileInfo.getDocumentURL().getUrl();
            ApiValidatorHelper.validateFileInfo(fileInfo.getDocumentURL(), fileInfo.getLibraryDocumentId(), fileInfo.getLibraryDocumentName(), fileInfo.getTransientDocumentId(), url);
        }
    }

    private static void validateRecipientSetInfos(List<RecipientSetInfo> recipientSetInfos) throws ApiException {
        for (RecipientSetInfo recipientSetInfo : recipientSetInfos) {
            ApiValidatorHelper.validateParameter(recipientSetInfo.getRecipientSetMemberInfos(), RECIPIENT_SET_MEMBER_INFOS);
            List<RecipientInfo> recipientInfos = recipientSetInfo.getRecipientSetMemberInfos();
            int numberOfRecipients = recipientInfos.size();
            if (recipientSetInfo.getRecipientSetMemberInfos().size() > 1) {
                throw new ApiException(SdkErrorCodes.RECIPIENT_SET_NOT_SUPPORTED);
            }
            for (RecipientInfo recipientInfo : recipientInfos) {
                ApiValidatorHelper.validateRecipientSetInfos(recipientInfo.getEmail(), recipientInfo.getFax(), numberOfRecipients);
            }
        }
    }

    public static void validatePostSignOptions(PostSignOptions postSignOptions) throws ApiException {
        if (postSignOptions == null) {
            return;
        }
        ApiValidatorHelper.validatePostSignOptions(postSignOptions.getRedirectUrl(), postSignOptions.getRedirectDelay());
    }
}

