/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.StringUtil;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class ApiValidatorHelper {
    private static final String X_API_USER_USER_ID_FORMAT_BEGINNING = "userid:";
    private static final String X_API_USER_EMAIL_ID_FORMAT_BEGINNING = "email:";
    private static final String ACCESS_TOKEN_KEY = "Access-Token";
    private static final String X_API_USER_KEY = "x-api-user";
    private static final String FAX = "fax";
    private static final String COMMA = " , ";
    private static final String EMAIL = "email";

    public static void validateHeaderParams(MultivaluedMap headerParams) throws ApiException {
        Set keys = headerParams.keySet();
        boolean accessToken = false;
        for (String key : keys) {
            if (key.equalsIgnoreCase(ACCESS_TOKEN_KEY)) {
                ApiValidatorHelper.validateAccessToken(headerParams.get((Object)key));
                accessToken = true;
                continue;
            }
            if (!key.equalsIgnoreCase(X_API_USER_KEY)) continue;
            ApiValidatorHelper.validateXApiUser(headerParams.get((Object)key));
        }
        if (!accessToken) {
            throw new ApiException(SdkErrorCodes.NO_ACCESS_TOKEN_HEADER);
        }
    }

    public static void validateRequiredParameters(HashMap hashMap) throws ApiException {
        Set keys = hashMap.keySet();
        for (String key : keys) {
            ApiValidatorHelper.validateParameter(hashMap.get(key), key);
        }
    }

    public static <T> void validateParameter(T param, String missingField) throws ApiException {
        ApiValidatorHelper.validateParameter(param, SdkErrorCodes.MISSING_REQUIRED_PARAM, missingField);
    }

    public static <T> void validateParameter(T param, SdkErrorCodes sdkErrorCode) throws ApiException {
        if (param == null) {
            throw new ApiException(sdkErrorCode);
        }
        if (param instanceof List && ((List)param).isEmpty()) {
            throw new ApiException(sdkErrorCode);
        }
        if (param instanceof String && StringUtil.isEmpty((String)param)) {
            throw new ApiException(sdkErrorCode);
        }
    }

    public static <T> void validateParameter(T param, SdkErrorCodes sdkErrorCode, String missingField) throws ApiException {
        if (param == null) {
            throw new ApiException(sdkErrorCode, missingField);
        }
        if (param instanceof List && ((List)param).isEmpty()) {
            throw new ApiException(sdkErrorCode, missingField);
        }
        if (param instanceof String && StringUtil.isEmpty((String)param)) {
            throw new ApiException(sdkErrorCode, missingField);
        }
    }

    public static void validateId(String id, SdkErrorCodes sdkErrorCode) throws ApiException {
        ApiValidatorHelper.validateParameter(id, sdkErrorCode);
    }

    public static void validateEmailParamater(String email) throws ApiException {
        if (!EmailValidator.getInstance().isValid(email)) {
            throw new ApiException(SdkErrorCodes.INVALID_EMAIL);
        }
    }

    public static void validateVersionId(String versionId) throws ApiException {
        if (versionId == null) {
            return;
        }
        if (versionId.length() == 0) {
            throw new ApiException(SdkErrorCodes.INVALID_VERSION_ID);
        }
    }

    public static void validateParticipantEmail(String participantEmail) throws ApiException {
        if (participantEmail == null) {
            return;
        }
        if (!EmailValidator.getInstance().isValid(participantEmail)) {
            throw new ApiException(SdkErrorCodes.INVALID_PARTICIPANT);
        }
    }

    public static void validateFileInfo(Object documentUrl, String libraryDocumentId, String libraryDocumentName, String transientDocumentId, String url) throws ApiException {
        int count = (documentUrl != null ? 1 : 0) + (StringUtil.isEmpty(libraryDocumentId) ? 0 : 1) + (StringUtil.isEmpty(libraryDocumentName) ? 0 : 1) + (StringUtil.isEmpty(transientDocumentId) ? 0 : 1);
        if (count != 1) {
            throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
        }
        if (!StringUtil.isEmpty(url)) {
            ApiValidatorHelper.validateUrlParameter(url, SdkErrorCodes.URL_INVALID);
        }
    }

    public static void validatePostSignOptions(String redirectUrl, Integer redirectDelay) throws ApiException {
        if (StringUtil.isEmpty(redirectUrl)) {
            throw new ApiException(SdkErrorCodes.EMPTY_REDIRECT_URL);
        }
        if (redirectDelay != null && redirectDelay < 0) {
            throw new ApiException(SdkErrorCodes.INVALID_REDIRECT_DELAY);
        }
        if (!UrlValidator.getInstance().isValid(redirectUrl)) {
            throw new ApiException(SdkErrorCodes.INVALID_REDIRECT_URL);
        }
    }

    public static void validateVersionIdAndParticipantEmail(String versionId, String participantEmail) throws ApiException {
        ApiValidatorHelper.validateVersionId(versionId);
        ApiValidatorHelper.validateParticipantEmail(participantEmail);
    }

    public static void validateRecipientSetInfos(String email, String fax, int numberOfRecipients) throws ApiException {
        if (StringUtil.isEmpty(fax) && StringUtil.isEmpty(email)) {
            throw new ApiException(SdkErrorCodes.MISSING_REQUIRED_PARAM, "email , fax");
        }
        if (!StringUtil.isEmpty(fax) && !StringUtil.isEmpty(email)) {
            throw new ApiException(SdkErrorCodes.INVALID_ARGUMENTS);
        }
        if (!StringUtil.isEmpty(fax) && numberOfRecipients > 1) {
            throw new ApiException(SdkErrorCodes.INVALID_ARGUMENTS);
        }
        if (email != null) {
            ApiValidatorHelper.validateEmailParamater(email);
        }
        if (fax != null) {
            ApiValidatorHelper.validateParameter(fax, FAX);
        }
    }

    public static void validateWorkflowRecipientSetInfos(String email, String fax, int numberOfRecipients) throws ApiException {
        if (StringUtil.isEmpty(fax) && StringUtil.isEmpty(email)) {
            throw new ApiException(SdkErrorCodes.MIN_ADDRESSES_NOT_MET);
        }
        ApiValidatorHelper.validateRecipientSetInfos(email, fax, numberOfRecipients);
    }

    public static void validateUrlParameter(String url, SdkErrorCodes sdkErrorCode) throws ApiException {
        UrlValidator urlValidator = new UrlValidator(8L);
        if (!urlValidator.isValid(url)) {
            throw new ApiException(sdkErrorCode);
        }
    }

    public static void validateStartAndEndDatesParameter(Date startDate, Date endDate) throws ApiException {
        ApiValidatorHelper.validateParameter(startDate, SdkErrorCodes.INVALID_DATE);
        ApiValidatorHelper.validateParameter(endDate, SdkErrorCodes.INVALID_DATE);
        if (endDate.before(startDate)) {
            throw new ApiException(SdkErrorCodes.INVALID_DATE);
        }
    }

    public static void validateAccessToken(Object accessToken) throws ApiException {
        if (accessToken == null) {
            throw new ApiException(SdkErrorCodes.NO_ACCESS_TOKEN_HEADER);
        }
        String accessTokenValue = accessToken.toString();
        if (accessTokenValue.length() == 0) {
            throw new ApiException(SdkErrorCodes.INVALID_ACCESS_TOKEN);
        }
    }

    private static void validateXApiUser(Object xApiUser) throws ApiException {
        if (xApiUser == null) {
            return;
        }
        String xApiUserValue = xApiUser.toString();
        if (xApiUserValue.length() == 0 || !xApiUserValue.contains(X_API_USER_EMAIL_ID_FORMAT_BEGINNING) && !xApiUserValue.contains(X_API_USER_USER_ID_FORMAT_BEGINNING)) {
            throw new ApiException(SdkErrorCodes.INVALID_X_API_USER_HEADER);
        }
    }
}

