/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.agreements.AgreementCreationInfo;
import com.adobe.sign.model.agreements.AgreementStatusUpdateInfo;
import com.adobe.sign.model.agreements.AlternateParticipantInfo;
import com.adobe.sign.model.agreements.DocumentCreationInfo;
import com.adobe.sign.model.agreements.FileInfo;
import com.adobe.sign.model.agreements.InteractiveOptions;
import com.adobe.sign.model.agreements.PostSignOptions;
import com.adobe.sign.model.agreements.RecipientInfo;
import com.adobe.sign.model.agreements.RecipientSetInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.StringUtil;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.List;

public class AgreementsApiValidator {
    private static final String AGREEMENT_CREATION_INFO = "agreementCreationInfo";
    private static final String DOCUMENT_CREATION_INFO = "documentCreationInfo";
    private static final String NAME = "name";
    private static final String RECIPIENT_SET_INFOS = "recipientSetInfos";
    private static final String SIGNATURE_TYPE = "signatureType";
    private static final String ALTERNATE_PARTICIPANT_INFO = "alternateParticipantInfo";
    private static final String EMAIL = "email";
    private static final String AGREEMENT_STATUS_UPATE_INFO = "agreementStatusUpdateInfo";
    private static final String RECIPIENT_SET_MEMBER_INFO = "recipientSetMemberInfos";
    private static final String RECIPIENT_SET_ROLE = "recipientSetRole";

    public static void getAgreementsValidator(String query, String externalId, String externalGroup, String externalNamespace) throws ApiException {
        if (!(StringUtil.isEmpty(externalNamespace) && StringUtil.isEmpty(externalGroup) && StringUtil.isEmpty(externalId))) {
            ApiValidatorHelper.validateId(externalId, SdkErrorCodes.EMPTY_EXTERNALID_PARAMETER);
        }
    }

    public static void createAgreementValidator(AgreementCreationInfo agreementCreationInfo) throws ApiException {
        ApiValidatorHelper.validateParameter(agreementCreationInfo, AGREEMENT_CREATION_INFO);
        DocumentCreationInfo documentCreationInfo = agreementCreationInfo.getDocumentCreationInfo();
        ApiValidatorHelper.validateParameter(documentCreationInfo, DOCUMENT_CREATION_INFO);
        List<FileInfo> fileInfos = documentCreationInfo.getFileInfos();
        AgreementsApiValidator.validateFileInfo(fileInfos);
        ApiValidatorHelper.validateParameter(documentCreationInfo.getName(), NAME);
        AgreementsApiValidator.validatePostSignOptions(documentCreationInfo.getPostSignOptions());
        ApiValidatorHelper.validateParameter(documentCreationInfo.getRecipientSetInfos(), RECIPIENT_SET_INFOS);
        List<RecipientSetInfo> recipientSetInfos = documentCreationInfo.getRecipientSetInfos();
        AgreementsApiValidator.validateRecipientSetInfos(recipientSetInfos);
        AgreementsApiValidator.validateInteractiveOptions(agreementCreationInfo);
        ApiValidatorHelper.validateParameter(documentCreationInfo.getSignatureType(), SIGNATURE_TYPE);
    }

    public static void getAgreementInfoValidator(String agreementId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void deleteAgreementValidator(String agreementId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void getAuditTrailValidator(String agreementId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void getCombinedDocumentValidator(String agreementId, String versionId, String participantEmail, boolean attachSupportingDocuments, boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void getCombinedDocumentPagesInfoValidator(String agreementId, boolean includeSupportingDocumentsPagesInfo) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void getCombinedDocumentUrlValidator(String agreementId, String versionId, String participantEmail, boolean attachSupportingDocuments, boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void getAllDocumentsValidator(String agreementId, String versionId, String participantEmail, String supportingDocumentContentFormat) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void deleteDocumentsValidator(String agreementId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void getCombinedDocumentImageUrlsValidator(String agreementId, String versionId, String participantEmail, String imageSizes, boolean includeSupportingDocumentsImageUrls, boolean showImageAvailabilityOnly) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void getDocumentValidator(String agreementId, String documentId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateId(documentId, SdkErrorCodes.INVALID_DOCUMENT_ID);
    }

    public static void getDocumentImageUrlsValidator(String agreementId, String documentId, String versionId, String participantEmail, String imageSizes, boolean showImageAvailabilityOnly, Integer startPage, Integer endPage) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
        ApiValidatorHelper.validateId(documentId, SdkErrorCodes.INVALID_DOCUMENT_ID);
    }

    public static void getDocumentUrlValidator(String agreementId, String documentId, String versionId, String participantEmail) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateId(documentId, SdkErrorCodes.INVALID_DOCUMENT_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void getFormDataValidator(String agreementId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void createAlternateParticipantValidator(String agreementId, String participantSetId, String participantId, AlternateParticipantInfo alternateParticipantInfo) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateId(participantId, SdkErrorCodes.INVALID_PARTICIPANT_ID);
        ApiValidatorHelper.validateId(participantSetId, SdkErrorCodes.INVALID_PARTICIPANT_SET_ID);
        ApiValidatorHelper.validateParameter(alternateParticipantInfo, ALTERNATE_PARTICIPANT_INFO);
        ApiValidatorHelper.validateParameter(alternateParticipantInfo.getEmail(), EMAIL);
        ApiValidatorHelper.validateEmailParamater(alternateParticipantInfo.getEmail());
        ApiValidatorHelper.validateParameter(alternateParticipantInfo.getPrivateMessage(), SdkErrorCodes.EMPTY_PRIVATE_MESSAGE);
    }

    public static void getSigningUrlValidator(String agreementId) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
    }

    public static void updateStatusValidator(String agreementId, AgreementStatusUpdateInfo agreementStatusUpdateInfo) throws ApiException {
        ApiValidatorHelper.validateId(agreementId, SdkErrorCodes.INVALID_AGREEMENT_ID);
        ApiValidatorHelper.validateParameter(agreementStatusUpdateInfo, AGREEMENT_STATUS_UPATE_INFO);
        ApiValidatorHelper.validateParameter(agreementStatusUpdateInfo.getValue(), SdkErrorCodes.MUST_PROVIDE_VALID_AGREEMENT_STATUS);
    }

    private static void validateInteractiveOptions(AgreementCreationInfo agreementCreationInfo) throws ApiException {
        List<RecipientSetInfo> recipientSetInfos = agreementCreationInfo.getDocumentCreationInfo().getRecipientSetInfos();
        InteractiveOptions interactiveOptions = agreementCreationInfo.getOptions();
        if (interactiveOptions == null) {
            return;
        }
        for (RecipientSetInfo recipientSetInfo : recipientSetInfos) {
            ApiValidatorHelper.validateParameter(recipientSetInfo.getRecipientSetMemberInfos(), RECIPIENT_SET_MEMBER_INFO);
            int numberOfRecipients = recipientSetInfo.getRecipientSetMemberInfos().size();
            if (!interactiveOptions.getAuthoringRequested().booleanValue() && !interactiveOptions.getSendThroughWeb().booleanValue() || numberOfRecipients <= 1) continue;
            throw new ApiException(SdkErrorCodes.INVALID_ARGUMENTS);
        }
    }

    private static void validateFileInfo(List<FileInfo> fileInfos) throws ApiException {
        if (fileInfos == null) {
            throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
        }
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo == null) {
                throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
            }
            String url = fileInfo.getDocumentURL() == null ? null : fileInfo.getDocumentURL().getUrl();
            ApiValidatorHelper.validateFileInfo(fileInfo.getDocumentURL(), fileInfo.getLibraryDocumentId(), fileInfo.getLibraryDocumentName(), fileInfo.getTransientDocumentId(), url);
        }
    }

    private static void validateRecipientSetInfos(List<RecipientSetInfo> recipientSetInfos) throws ApiException {
        for (RecipientSetInfo recipientSetInfo : recipientSetInfos) {
            ApiValidatorHelper.validateParameter(recipientSetInfo.getRecipientSetMemberInfos(), RECIPIENT_SET_MEMBER_INFO);
            List<RecipientInfo> recipientInfos = recipientSetInfo.getRecipientSetMemberInfos();
            int numberOfRecipients = recipientInfos.size();
            for (RecipientInfo recipientInfo : recipientInfos) {
                ApiValidatorHelper.validateRecipientSetInfos(recipientInfo.getEmail(), recipientInfo.getFax(), numberOfRecipients);
            }
            ApiValidatorHelper.validateParameter(recipientSetInfo.getRecipientSetRole(), RECIPIENT_SET_ROLE);
        }
    }

    private static void validatePostSignOptions(PostSignOptions postSignOptions) throws ApiException {
        if (postSignOptions == null) {
            return;
        }
        ApiValidatorHelper.validatePostSignOptions(postSignOptions.getRedirectUrl(), postSignOptions.getRedirectDelay());
    }
}

