/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils;

import com.adobe.sign.model.oAuth.Scope;
import com.adobe.sign.utils.ApiException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;

public class OAuthUtils {
    private static String REDIRECT_URI = "redirect_uri";
    private static String RESPONSE_TYPE = "response_type";
    private static String CLIENT_ID = "client_id";
    private static String SCOPE = "scope";
    private static String STATE = "state";
    private static String ENCODING = "UTF-8";
    private static String SPACE_DELIMITER = "+";
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final char PARAM_SEPARATOR = '&';
    private static final char EQUALS = '=';

    public static String getValueByKey(String[] pairs, String name) throws UnsupportedEncodingException {
        for (String pair : pairs) {
            int idx = pair.indexOf(61);
            if (!URLDecoder.decode(String.valueOf(pair.substring(0, idx)), ENCODING).equals(name)) continue;
            return URLDecoder.decode(pair.substring(idx + 1), ENCODING);
        }
        return null;
    }

    public static String spaceDelimitedSet(ArrayList<Scope> scopes) {
        if (scopes.isEmpty()) {
            return null;
        }
        String scopeSet = "";
        Iterator<Scope> it = scopes.iterator();
        while (true) {
            Scope s = it.next();
            if (!it.hasNext()) {
                scopeSet = scopeSet + s.toString();
                return scopeSet;
            }
            scopeSet = scopeSet + s.toString() + SPACE_DELIMITER;
        }
    }

    public static String appendTo(String url, String clientId, String redirectUrl, String scopes, String state, String responseType) throws ApiException {
        if (!url.isEmpty()) {
            return url + '?' + REDIRECT_URI + '=' + redirectUrl + '&' + RESPONSE_TYPE + '=' + responseType + '&' + CLIENT_ID + '=' + clientId + '&' + SCOPE + '=' + scopes + (state != null ? '&' + STATE + '=' + state : "");
        }
        return null;
    }
}

