/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils;

import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.TypeRef;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JSON {
    private ObjectMapper mapper = new ObjectMapper();
    private static final String CLASS_NAME = "class ";
    private static final String DESERIALIZATION_ERROR = "Error in deserialization.";

    public JSON() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        this.mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        this.mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.registerModule((Module)new JodaModule());
    }

    public String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                return this.mapper.writeValueAsString(obj);
            }
            return null;
        }
        catch (Exception e) {
            throw new ApiException(400, e.getMessage());
        }
    }

    public <T> T deserialize(String body, TypeRef returnType) throws ApiException {
        if (body.equals("[]")) {
            return (T)this.getEmptyClassInstance(returnType.getType());
        }
        JavaType javaType = this.mapper.constructType(returnType.getType());
        try {
            return (T)this.mapper.readValue(body, javaType);
        }
        catch (IOException e) {
            if (returnType.getType().equals(String.class)) {
                return (T)body;
            }
            throw new ApiException(DESERIALIZATION_ERROR);
        }
    }

    private Object getEmptyClassInstance(Type type) {
        if (type == null) {
            return null;
        }
        String className = type.toString();
        if (className == null) {
            return null;
        }
        className = className.substring(CLASS_NAME.length());
        try {
            Class<?> classType = Class.forName(className);
            return classType == null ? null : classType.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }
}

