/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils;

import com.adobe.sign.model.baseUris.BaseUriInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.JSON;
import com.adobe.sign.utils.OAuthException;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.RestException;
import com.adobe.sign.utils.StringUtil;
import com.adobe.sign.utils.TypeRef;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ApiClient {
    private final String VERSION = "1.1.2";
    private final String SDK_NAME = "Java SDK ";
    private final String X_SDK_VERSION_KEY = "x-sdk-version";
    private final String X_SDK_VERSION = "Java SDK 1.1.2";
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private boolean debugging = false;
    private String envHostName = "https://api.echosign.com/".replaceAll("\\/+$", "/");
    private String baseUri = null;
    private String subPath = "api/rest/v5";
    private JSON json = new JSON();
    private int statusCode;
    private Map<String, List<String>> responseHeaders;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public ApiClient() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setUserAgent("Adobe Sign Java SDK 1.0");
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getEnvHostName() {
        return this.envHostName;
    }

    public void setEnvHostName(String hostName) {
        if (hostName != null && hostName.length() > 0) {
            this.envHostName = hostName;
            this.baseUri = null;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Date parseDate(String str) {
        try {
            return this.dateFormat.parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date) {
            return this.formatDate((Date)param);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(String.valueOf(o));
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    public List<Pair> parameterToPairs(String collectionFormat, String name, Object value) {
        ArrayList<Pair> params = new ArrayList<Pair>();
        if (name == null || name.isEmpty() || value == null) {
            return params;
        }
        Collection valueCollection = null;
        if (!(value instanceof Collection)) {
            params.add(new Pair(name, this.parameterToString(value)));
            return params;
        }
        valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return params;
        }
        String string = collectionFormat = collectionFormat == null || collectionFormat.isEmpty() ? "csv" : collectionFormat;
        if (collectionFormat.equals("multi")) {
            for (Object item : valueCollection) {
                params.add(new Pair(name, this.parameterToString(item)));
            }
            return params;
        }
        String delimiter = ",";
        if (collectionFormat.equals("csv")) {
            delimiter = ",";
        } else if (collectionFormat.equals("ssv")) {
            delimiter = " ";
        } else if (collectionFormat.equals("tsv")) {
            delimiter = "\t";
        } else if (collectionFormat.equals("pipes")) {
            delimiter = "|";
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : valueCollection) {
            sb.append(delimiter);
            sb.append(this.parameterToString(item));
        }
        params.add(new Pair(name, sb.substring(1)));
        return params;
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        if (StringUtil.containsIgnoreCase(accepts, "application/json")) {
            return "application/json";
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        if (StringUtil.containsIgnoreCase(contentTypes, "application/json")) {
            return "application/json";
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public String serialize(Object obj, String contentType) throws ApiException {
        if (contentType.startsWith("application/json")) {
            return this.json.serialize(obj);
        }
        throw new ApiException(400, "can not serialize object into Content-Type: " + contentType);
    }

    public <T> T deserialize(ClientResponse response, TypeRef returnType) throws ApiException {
        String contentType = null;
        List contentTypes = (List)response.getHeaders().get((Object)"Content-Type");
        if (contentTypes != null && !contentTypes.isEmpty()) {
            contentType = (String)contentTypes.get(0);
        }
        if (contentType == null) {
            throw new ApiException(500, "missing Content-Type in response");
        }
        String body = response.hasEntity() ? (String)response.getEntity(String.class) : "";
        if (contentType.startsWith("application/json")) {
            return this.json.deserialize(body, returnType);
        }
        if (returnType.getType().equals(String.class)) {
            return (T)body;
        }
        throw new ApiException(500, "Content type \"" + contentType + "\" is not supported for type: " + returnType.getType());
    }

    private ClientResponse getAPIResponse(String baseUrl, String path, String method, List<Pair> queryParams, Object body, byte[] binaryBody, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType) throws ApiException {
        if (!this.isOauth(path)) {
            headerParams.put("x-sdk-version", "Java SDK 1.1.2");
        }
        if (body != null && binaryBody != null) {
            throw new ApiException(500, "either body or binaryBody must be null");
        }
        Client client = this.getClient(baseUrl);
        StringBuilder b = new StringBuilder();
        b.append("?");
        if (queryParams != null) {
            for (Pair queryParam : queryParams) {
                if (queryParam.getName().isEmpty()) continue;
                b.append(this.escapeString(queryParam.getName()));
                b.append("=");
                b.append(this.escapeString(queryParam.getValue()));
                b.append("&");
            }
        }
        String querystring = b.substring(0, b.length() - 1);
        WebResource.Builder builder = accept == null ? client.resource(baseUrl + path + querystring).getRequestBuilder() : client.resource(baseUrl + path + querystring).accept(new String[]{accept});
        for (String key : headerParams.keySet()) {
            builder = (WebResource.Builder)builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder = (WebResource.Builder)builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        String encodedFormParams = null;
        if (contentType.startsWith("multipart/form-data")) {
            FormDataMultiPart mp = new FormDataMultiPart();
            for (Map.Entry<String, Object> param : formParams.entrySet()) {
                if (param.getValue() instanceof File) {
                    File file = (File)param.getValue();
                    mp.bodyPart((BodyPart)new FileDataBodyPart(param.getKey(), file, MediaType.MULTIPART_FORM_DATA_TYPE));
                    continue;
                }
                mp.field(param.getKey(), (Object)this.parameterToString(param.getValue()), MediaType.MULTIPART_FORM_DATA_TYPE);
            }
            body = mp;
        } else if (contentType.startsWith("application/x-www-form-urlencoded")) {
            encodedFormParams = this.getXWWWFormUrlencodedParams(formParams);
        }
        ClientResponse response = null;
        try {
            if ("GET".equals(method)) {
                response = (ClientResponse)builder.get(ClientResponse.class);
            } else if ("POST".equals(method)) {
                response = encodedFormParams != null ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)encodedFormParams) : (body == null ? (binaryBody == null ? (ClientResponse)builder.post(ClientResponse.class, null) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)binaryBody)) : (body instanceof FormDataMultiPart ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, body) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)this.serialize(body, contentType))));
            } else if ("PUT".equals(method)) {
                response = encodedFormParams != null ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)encodedFormParams) : (body == null ? (binaryBody == null ? (ClientResponse)builder.put(ClientResponse.class, null) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)binaryBody)) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)this.serialize(body, contentType)));
            } else if ("DELETE".equals(method)) {
                response = encodedFormParams != null ? (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)encodedFormParams) : (body == null ? (binaryBody == null ? (ClientResponse)builder.delete(ClientResponse.class) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)binaryBody)) : (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)this.serialize(body, contentType)));
            } else {
                throw new ApiException(500, "unknown method type " + method);
            }
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR) {
                throw new ApiException(response.getStatusInfo().getStatusCode(), "Service Unavailable");
            }
            return response;
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception error) {
            throw new ApiException("Connection Error");
        }
    }

    private String getBaseUrl(String accessToken) throws ApiException {
        String baseUrl = this.envHostName + this.subPath;
        String path = "/base_uris".replaceAll("\\{format\\}", "json");
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (accessToken != null) {
            headerParams.put("Access-Token", this.parameterToString(accessToken));
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String acceptHeader = this.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.selectHeaderContentType(contentTypes);
        TypeRef<BaseUriInfo> returnType = new TypeRef<BaseUriInfo>(){};
        ClientResponse response = this.getAPIResponse(baseUrl, path, "GET", queryParams, null, null, headerParams, formParams, acceptHeader, contentType);
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            BaseUriInfo baseUriInfo = (BaseUriInfo)this.deserialize(response, returnType);
            return baseUriInfo.getApiAccessPoint();
        }
        return this.envHostName;
    }

    public <T> T invokeAPI(String path, String method, List<Pair> queryParams, Object body, byte[] binaryBody, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, TypeRef returnType, boolean addSubPath) throws ApiException {
        String baseUrl = this.baseUri;
        if (baseUrl == null) {
            baseUrl = this.getBaseUrl(headerParams.get("Access-Token"));
        }
        if (addSubPath) {
            baseUrl = baseUrl + this.subPath;
        }
        ClientResponse response = this.getAPIResponse(baseUrl, path, method, queryParams, body, binaryBody, headerParams, formParams, accept, contentType);
        this.statusCode = response.getStatusInfo().getStatusCode();
        this.responseHeaders = response.getHeaders();
        if (response.getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (returnType == null) {
                return null;
            }
            return this.deserialize(response, returnType);
        }
        String message = "error";
        String respBody = null;
        if (addSubPath) {
            this.throwApiException(message, response, respBody, RestException.class);
        } else {
            this.throwApiException(message, response, respBody, OAuthException.class);
        }
        return null;
    }

    private <T> void throwApiException(String message, ClientResponse response, String respBody, Class<T> clazz) throws ApiException {
        Object exception = null;
        if (response.hasEntity()) {
            try {
                message = String.valueOf(response.getEntity(String.class));
                exception = this.getRestException(message, clazz);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String code = null;
        if (exception instanceof OAuthException) {
            code = ((OAuthException)exception).getCode();
            message = ((OAuthException)exception).getMessage();
        } else {
            code = ((RestException)exception).getCode();
            message = ((RestException)exception).getMessage();
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), message, code, (Map<String, List<String>>)response.getHeaders(), respBody);
    }

    public byte[] invokeBinaryAPI(String path, String method, List<Pair> queryParams, Object body, byte[] binaryBody, Map<String, String> headerParams, Map<String, Object> formParams, String accept, String contentType, boolean addSubPath) throws ApiException {
        ClientResponse response;
        String baseUrl = this.baseUri;
        if (baseUrl == null) {
            baseUrl = this.getBaseUrl(headerParams.get("Access-Token"));
        }
        if (addSubPath) {
            baseUrl = baseUrl + this.subPath;
        }
        if ((response = this.getAPIResponse(baseUrl, path, method, queryParams, body, binaryBody, headerParams, formParams, accept, contentType)).getStatusInfo() == ClientResponse.Status.NO_CONTENT) {
            return null;
        }
        if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            if (response.hasEntity()) {
                DataInputStream stream = new DataInputStream(response.getEntityInputStream());
                byte[] data = new byte[response.getLength()];
                try {
                    stream.readFully(data);
                }
                catch (IOException ex) {
                    throw new ApiException(500, "Error obtaining binary response data");
                }
                return data;
            }
            return new byte[0];
        }
        String message = "error";
        RestException exception = null;
        if (response.hasEntity()) {
            try {
                message = String.valueOf(response.getEntity(String.class));
                exception = this.getRestException(message, RestException.class);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ApiException(response.getStatusInfo().getStatusCode(), exception == null ? null : exception.getCode(), exception == null ? message : exception.getMessage());
    }

    private <T> T getRestException(String message, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(message, clazz);
    }

    private String getXWWWFormUrlencodedParams(Map<String, Object> formParams) {
        StringBuilder formParamBuilder = new StringBuilder();
        for (Map.Entry<String, Object> param : formParams.entrySet()) {
            String keyStr = param.getKey();
            String valueStr = this.parameterToString(param.getValue());
            try {
                formParamBuilder.append(URLEncoder.encode(param.getKey(), "utf8")).append("=").append(URLEncoder.encode(valueStr, "utf8"));
                formParamBuilder.append("&");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String encodedFormParams = formParamBuilder.toString();
        if (encodedFormParams.endsWith("&")) {
            encodedFormParams = encodedFormParams.substring(0, encodedFormParams.length() - 1);
        }
        return encodedFormParams;
    }

    private Client getClient(String baseUrl) {
        if (!this.hostMap.containsKey(baseUrl)) {
            Client client = Client.create();
            if (this.debugging) {
                client.addFilter((ClientFilter)new LoggingFilter());
            }
            this.hostMap.put(baseUrl, client);
        }
        return this.hostMap.get(baseUrl);
    }

    private boolean isOauth(String path) {
        return (path = path.toLowerCase()).startsWith("oauth");
    }
}

