/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.widgets;

import com.adobe.sign.model.widgets.WidgetEventDeviceLocation;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;

@ApiModel(description="")
public class WidgetHistoryEvent {
    private String actingUserEmail = null;
    private String actingUserIpAddress = null;
    private String comment = null;
    private Date date = null;
    private String description = null;
    private WidgetEventDeviceLocation deviceLocation = null;
    private String participantEmail = null;
    private String synchronizationId = null;
    private TypeEnum type = null;
    private String vaultEventId = null;
    private String versionId = null;

    @ApiModelProperty(required=true, value="Email address of the user that initiated the event")
    @JsonProperty(value="actingUserEmail")
    public String getActingUserEmail() {
        return this.actingUserEmail;
    }

    public void setActingUserEmail(String actingUserEmail) {
        this.actingUserEmail = actingUserEmail;
    }

    @ApiModelProperty(required=true, value="The IP address of the user that initiated the event")
    @JsonProperty(value="actingUserIpAddress")
    public String getActingUserIpAddress() {
        return this.actingUserIpAddress;
    }

    public void setActingUserIpAddress(String actingUserIpAddress) {
        this.actingUserIpAddress = actingUserIpAddress;
    }

    @ApiModelProperty(value="The event comment. For RECALLED or REJECTED, the reason given by the user that initiates the event. For DELEGATE or SHARE, the message from the acting user to the participant")
    @JsonProperty(value="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @ApiModelProperty(required=true, value="The date of the audit event")
    @JsonProperty(value="date")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @ApiModelProperty(required=true, value="A description of the audit event")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="Location of the device that created the event (This value may be null due to limited privileges)")
    @JsonProperty(value="deviceLocation")
    public WidgetEventDeviceLocation getDeviceLocation() {
        return this.deviceLocation;
    }

    public void setDeviceLocation(WidgetEventDeviceLocation deviceLocation) {
        this.deviceLocation = deviceLocation;
    }

    @ApiModelProperty(required=true, value="Email address of the user that initiated the event")
    @JsonProperty(value="participantEmail")
    public String getParticipantEmail() {
        return this.participantEmail;
    }

    public void setParticipantEmail(String participantEmail) {
        this.participantEmail = participantEmail;
    }

    @ApiModelProperty(value="A unique identifier linking offline events to synchronization events (specified for offline signing events and synchronization events, else null)")
    @JsonProperty(value="synchronizationId")
    public String getSynchronizationId() {
        return this.synchronizationId;
    }

    public void setSynchronizationId(String synchronizationId) {
        this.synchronizationId = synchronizationId;
    }

    @ApiModelProperty(required=true, value="Type of the widget event")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @ApiModelProperty(value="The identifier assigned by the vault provider for the vault event (if vaulted, otherwise null)")
    @JsonProperty(value="vaultEventId")
    public String getVaultEventId() {
        return this.vaultEventId;
    }

    public void setVaultEventId(String vaultEventId) {
        this.vaultEventId = vaultEventId;
    }

    @ApiModelProperty(required=true, value="An ID which uniquely identifies the version of the widget associated with this audit event")
    @JsonProperty(value="versionId")
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WidgetHistoryEvent {\n");
        sb.append("    actingUserEmail: ").append(StringUtil.toIndentedString(this.actingUserEmail)).append("\n");
        sb.append("    actingUserIpAddress: ").append(StringUtil.toIndentedString(this.actingUserIpAddress)).append("\n");
        sb.append("    comment: ").append(StringUtil.toIndentedString(this.comment)).append("\n");
        sb.append("    date: ").append(StringUtil.toIndentedString(this.date)).append("\n");
        sb.append("    description: ").append(StringUtil.toIndentedString(this.description)).append("\n");
        sb.append("    deviceLocation: ").append(StringUtil.toIndentedString(this.deviceLocation)).append("\n");
        sb.append("    participantEmail: ").append(StringUtil.toIndentedString(this.participantEmail)).append("\n");
        sb.append("    synchronizationId: ").append(StringUtil.toIndentedString(this.synchronizationId)).append("\n");
        sb.append("    type: ").append(StringUtil.toIndentedString((Object)this.type)).append("\n");
        sb.append("    vaultEventId: ").append(StringUtil.toIndentedString(this.vaultEventId)).append("\n");
        sb.append("    versionId: ").append(StringUtil.toIndentedString(this.versionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum TypeEnum {
        CREATED("CREATED"),
        UPLOADED_BY_SENDER("UPLOADED_BY_SENDER"),
        FAXED_BY_SENDER("FAXED_BY_SENDER"),
        AGREEMENT_MODIFIED("AGREEMENT_MODIFIED"),
        USER_ACK_AGREEMENT_MODIFIED("USER_ACK_AGREEMENT_MODIFIED"),
        PRESIGNED("PRESIGNED"),
        SIGNED("SIGNED"),
        ESIGNED("ESIGNED"),
        DIGSIGNED("DIGSIGNED"),
        APPROVED("APPROVED"),
        OFFLINE_SYNC("OFFLINE_SYNC"),
        FAXIN_RECEIVED("FAXIN_RECEIVED"),
        SIGNATURE_REQUESTED("SIGNATURE_REQUESTED"),
        APPROVAL_REQUESTED("APPROVAL_REQUESTED"),
        RECALLED("RECALLED"),
        REJECTED("REJECTED"),
        EXPIRED("EXPIRED"),
        EXPIRED_AUTOMATICALLY("EXPIRED_AUTOMATICALLY"),
        SHARED("SHARED"),
        EMAIL_VIEWED("EMAIL_VIEWED"),
        AUTO_CANCELLED_CONVERSION_PROBLEM("AUTO_CANCELLED_CONVERSION_PROBLEM"),
        SIGNER_SUGGESTED_CHANGES("SIGNER_SUGGESTED_CHANGES"),
        SENDER_CREATED_NEW_REVISION("SENDER_CREATED_NEW_REVISION"),
        PASSWORD_AUTHENTICATION_FAILED("PASSWORD_AUTHENTICATION_FAILED"),
        KBA_AUTHENTICATION_FAILED("KBA_AUTHENTICATION_FAILED"),
        KBA_AUTHENTICATED("KBA_AUTHENTICATED"),
        WEB_IDENTITY_AUTHENTICATED("WEB_IDENTITY_AUTHENTICATED"),
        WEB_IDENTITY_SPECIFIED("WEB_IDENTITY_SPECIFIED"),
        EMAIL_BOUNCED("EMAIL_BOUNCED"),
        WIDGET_ENABLED("WIDGET_ENABLED"),
        WIDGET_DISABLED("WIDGET_DISABLED"),
        DELEGATED("DELEGATED"),
        AUTO_DELEGATED("AUTO_DELEGATED"),
        REPLACED_SIGNER("REPLACED_SIGNER"),
        VAULTED("VAULTED"),
        DOCUMENTS_DELETED("DOCUMENTS_DELETED"),
        OTHER("OTHER");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

