/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.users;

import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="")
public class UserCreationInfo {
    private String company = null;
    private String email = null;
    private String firstName = null;
    private String groupId = null;
    private String lastName = null;
    private OptInEnum optIn = null;
    private String password = null;
    private String phone = null;
    private List<RolesEnum> roles = null;
    private String title = null;

    @ApiModelProperty(value="The name of the company of the new user")
    @JsonProperty(value="company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @ApiModelProperty(required=true, value="The email address of the new user")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(required=true, value="The first name of the new user")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @ApiModelProperty(value="Group in which the new user should be added. It can be obtained through a call to the API which retrieves users. Default is Group of the user making this call. The user is inferred from the access_token header.")
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(required=true, value="The last name of the new user")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @ApiModelProperty(value="Whether or not the user has opted in to receive marketing information from Adobe Sign and its partners. Default value is UNKNOWN")
    @JsonProperty(value="optIn")
    public OptInEnum getOptIn() {
        return this.optIn;
    }

    public void setOptIn(OptInEnum optIn) {
        this.optIn = optIn;
    }

    @ApiModelProperty(value="The password of the new user")
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ApiModelProperty(value="The phone number of the new user")
    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @ApiModelProperty(value="The current roles of the user")
    @JsonProperty(value="roles")
    public List<RolesEnum> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RolesEnum> roles) {
        this.roles = roles;
    }

    @ApiModelProperty(value="The job title of the new user")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCreationInfo {\n");
        sb.append("    company: ").append(StringUtil.toIndentedString(this.company)).append("\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(StringUtil.toIndentedString(this.firstName)).append("\n");
        sb.append("    groupId: ").append(StringUtil.toIndentedString(this.groupId)).append("\n");
        sb.append("    lastName: ").append(StringUtil.toIndentedString(this.lastName)).append("\n");
        sb.append("    optIn: ").append(StringUtil.toIndentedString((Object)this.optIn)).append("\n");
        sb.append("    password: ").append(StringUtil.toIndentedString(this.password)).append("\n");
        sb.append("    phone: ").append(StringUtil.toIndentedString(this.phone)).append("\n");
        sb.append("    roles: ").append(StringUtil.toIndentedString(this.roles)).append("\n");
        sb.append("    title: ").append(StringUtil.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum RolesEnum {
        ACCOUNT_ADMIN("ACCOUNT_ADMIN"),
        GROUP_ADMIN("GROUP_ADMIN"),
        NORMAL_USER("NORMAL_USER");

        private String value;

        private RolesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum OptInEnum {
        YES("YES"),
        NO("NO"),
        UNKNOWN("UNKNOWN");

        private String value;

        private OptInEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

