/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.oAuth;

import com.adobe.sign.model.oAuth.Scope;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;

public class AuthorizationRequest {
    private String clientId = null;
    private String redirectUri = null;
    private ArrayList<Scope> scopes = new ArrayList();
    private String state = null;
    private String responseType = null;

    public AuthorizationRequest(String clientId, String redirectUri, ArrayList<Scope> scopes, String state, String responseType) {
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.scopes = scopes;
        this.state = state;
        this.responseType = responseType;
    }

    @ApiModelProperty(required=true, value="Identifies the application configured on the OAuth Configuration page.")
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ApiModelProperty(required=true, value="The url where the end user will be redirected after successful completion of authorization.\nThis value must belong to the set of values specified on the OAuth Configuration page.")
    @JsonProperty(value="redirect_uri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @ApiModelProperty(required=false, value="Value used by the client to maintain state between the request and callback.")
    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @ApiModelProperty(required=true, value="List of permissions required by the application on behalf of the user to access the resources.\n")
    @JsonProperty(value="scope")
    public ArrayList<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(ArrayList<Scope> scopes) {
        this.scopes = scopes;
    }

    @ApiModelProperty(required=true, value="Value must always be \"code\".")
    @JsonProperty(value="response_type")
    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationRequest {\n");
        sb.append("    clientId: ").append(StringUtil.toIndentedString(this.clientId)).append("\n");
        sb.append("    redirectUri: ").append(StringUtil.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    scopes: ").append(StringUtil.toIndentedString(this.scopes)).append("\n");
        sb.append("    state: ").append(StringUtil.toIndentedString(this.state)).append("\n");
        sb.append("    response_type: ").append(StringUtil.toIndentedString(this.responseType)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

