/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.oAuth;

import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

public class AccessTokenRequest {
    private String clientId = null;
    private String clientSecret = null;
    private String redirectUri = null;
    private String code = null;
    private String grantType = null;

    public AccessTokenRequest(String clientId, String clientSecret, String redirectUri, String code, String grantType) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
        this.code = code;
        this.grantType = grantType;
    }

    @ApiModelProperty(required=true, value="Value must always be \"authorization_code\".")
    @JsonProperty(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @ApiModelProperty(required=true, value="Identifies the application configured on the OAuth Configuration page.")
    @JsonProperty(value="client_id")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @ApiModelProperty(required=true, value="Authenticates the application configured on the OAuth Configuration page.")
    @JsonProperty(value="client_secret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @ApiModelProperty(required=true, value="The url where the end user will be redirected after successful completion of authorization.\nThis value must belong to the set of values specified on the OAuth Configuration page.")
    @JsonProperty(value="redirect_uri")
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @ApiModelProperty(required=true, value="The authorization code retrieved by successful authorization workflow.\nThis credential represents the resource owner's authorization.")
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessTokenRequest {\n");
        sb.append("    clientId: ").append(StringUtil.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(StringUtil.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    redirectUri: ").append(StringUtil.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    code: ").append(StringUtil.toIndentedString(this.code)).append("\n");
        sb.append("    grantType: ").append(StringUtil.toIndentedString(this.grantType)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

