/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.megaSigns;

import com.adobe.sign.model.megaSigns.DocumentHistoryEvent;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="")
public class MegaSignInfo {
    private List<DocumentHistoryEvent> events = null;
    private Date expiration = null;
    private String locale = null;
    private String megaSignId = null;
    private String message = null;
    private String latestVersionId = null;
    private String name = null;
    private List<SecurityOptionsEnum> securityOptions = null;
    private StatusEnum status = null;

    @ApiModelProperty(required=true, value="An ordered list of the events in the audit trail of this document")
    @JsonProperty(value="events")
    public List<DocumentHistoryEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<DocumentHistoryEvent> events) {
        this.events = events;
    }

    @ApiModelProperty(value="The date after which the document can no longer be signed, if an expiration date is configured. The value is nil if an expiration date is not set for the document")
    @JsonProperty(value="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @ApiModelProperty(required=true, value="The locale associated with this agreement - for example, en_US or fr_FR")
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @ApiModelProperty(required=true, value="Unique identifier of the MegaSign parent agreement")
    @JsonProperty(value="megaSignId")
    public String getMegaSignId() {
        return this.megaSignId;
    }

    public void setMegaSignId(String megaSignId) {
        this.megaSignId = megaSignId;
    }

    @ApiModelProperty(value="The message associated with the document that the sender has provided")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @ApiModelProperty(required=true, value="A version ID which uniquely identifies the current version of the agreement")
    @JsonProperty(value="latestVersionId")
    public String getLatestVersionId() {
        return this.latestVersionId;
    }

    public void setLatestVersionId(String latestVersionId) {
        this.latestVersionId = latestVersionId;
    }

    @ApiModelProperty(required=true, value="The name of the document, specified by the sender")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="Security information about the document that specifies whether or not a password is required to view and sign the document")
    @JsonProperty(value="securityOptions")
    public List<SecurityOptionsEnum> getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(List<SecurityOptionsEnum> securityOptions) {
        this.securityOptions = securityOptions;
    }

    @ApiModelProperty(required=true, value="Current status of the MegaSign parent agreement from the perspective of the user")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MegaSignInfo {\n");
        sb.append("    events: ").append(StringUtil.toIndentedString(this.events)).append("\n");
        sb.append("    expiration: ").append(StringUtil.toIndentedString(this.expiration)).append("\n");
        sb.append("    locale: ").append(StringUtil.toIndentedString(this.locale)).append("\n");
        sb.append("    megaSignId: ").append(StringUtil.toIndentedString(this.megaSignId)).append("\n");
        sb.append("    message: ").append(StringUtil.toIndentedString(this.message)).append("\n");
        sb.append("    latestVersionId: ").append(StringUtil.toIndentedString(this.latestVersionId)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    securityOptions: ").append(StringUtil.toIndentedString(this.securityOptions)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum StatusEnum {
        WAITING_FOR_MY_SIGNATURE("WAITING_FOR_MY_SIGNATURE"),
        WAITING_FOR_MY_APPROVAL("WAITING_FOR_MY_APPROVAL"),
        WAITING_FOR_MY_DELEGATION("WAITING_FOR_MY_DELEGATION"),
        OUT_FOR_SIGNATURE("OUT_FOR_SIGNATURE"),
        OUT_FOR_APPROVAL("OUT_FOR_APPROVAL"),
        SIGNED("SIGNED"),
        APPROVED("APPROVED"),
        RECALLED("RECALLED"),
        WAITING_FOR_FAXIN("WAITING_FOR_FAXIN"),
        ARCHIVED("ARCHIVED"),
        FORM("FORM"),
        EXPIRED("EXPIRED"),
        WIDGET("WIDGET"),
        WAITING_FOR_AUTHORING("WAITING_FOR_AUTHORING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SecurityOptionsEnum {
        OPEN_PROTECTED("OPEN_PROTECTED"),
        OTHER("OTHER");

        private String value;

        private SecurityOptionsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

