/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.libraryDocuments;

import com.adobe.sign.model.libraryDocuments.LibDocParticipantInfo;
import com.adobe.sign.model.libraryDocuments.LibDocumentHistoryEvent;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="")
public class LibraryDocumentInfo {
    private List<LibDocumentHistoryEvent> events = null;
    private String libraryDocumentId = null;
    private String locale = null;
    private String message = null;
    private String latestVersionId = null;
    private String name = null;
    private List<LibDocParticipantInfo> participants = null;
    private List<SecurityOptionsEnum> securityOptions = null;
    private StatusEnum status = null;

    @ApiModelProperty(required=true, value="An ordered list of the events in the audit trail of this document")
    @JsonProperty(value="events")
    public List<LibDocumentHistoryEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<LibDocumentHistoryEvent> events) {
        this.events = events;
    }

    @ApiModelProperty(required=true, value="A resource identifier that can be used to uniquely identify the library document in other apis")
    @JsonProperty(value="libraryDocumentId")
    public String getLibraryDocumentId() {
        return this.libraryDocumentId;
    }

    public void setLibraryDocumentId(String libraryDocumentId) {
        this.libraryDocumentId = libraryDocumentId;
    }

    @ApiModelProperty(required=true, value="The locale associated with this agreement - for example, en_US or fr_FR")
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @ApiModelProperty(value="The message associated with the document that the sender has provided")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @ApiModelProperty(required=true, value="A version ID which uniquely identifies the current version of the agreement")
    @JsonProperty(value="latestVersionId")
    public String getLatestVersionId() {
        return this.latestVersionId;
    }

    public void setLatestVersionId(String latestVersionId) {
        this.latestVersionId = latestVersionId;
    }

    @ApiModelProperty(required=true, value="The name of the document, specified by the sender")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(required=true, value="Information about all the participants of this document")
    @JsonProperty(value="participants")
    public List<LibDocParticipantInfo> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<LibDocParticipantInfo> participants) {
        this.participants = participants;
    }

    @ApiModelProperty(value="Security information about the document that specifies whether or not a password is required to view and sign the document")
    @JsonProperty(value="securityOptions")
    public List<SecurityOptionsEnum> getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(List<SecurityOptionsEnum> securityOptions) {
        this.securityOptions = securityOptions;
    }

    @ApiModelProperty(required=true, value="The current status of the document")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LibraryDocumentInfo {\n");
        sb.append("    events: ").append(StringUtil.toIndentedString(this.events)).append("\n");
        sb.append("    libraryDocumentId: ").append(StringUtil.toIndentedString(this.libraryDocumentId)).append("\n");
        sb.append("    locale: ").append(StringUtil.toIndentedString(this.locale)).append("\n");
        sb.append("    message: ").append(StringUtil.toIndentedString(this.message)).append("\n");
        sb.append("    latestVersionId: ").append(StringUtil.toIndentedString(this.latestVersionId)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    participants: ").append(StringUtil.toIndentedString(this.participants)).append("\n");
        sb.append("    securityOptions: ").append(StringUtil.toIndentedString(this.securityOptions)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum StatusEnum {
        OUT_FOR_SIGNATURE("OUT_FOR_SIGNATURE"),
        WAITING_FOR_REVIEW("WAITING_FOR_REVIEW"),
        SIGNED("SIGNED"),
        APPROVED("APPROVED"),
        ABORTED("ABORTED"),
        DOCUMENT_LIBRARY("DOCUMENT_LIBRARY"),
        WIDGET("WIDGET"),
        EXPIRED("EXPIRED"),
        ARCHIVED("ARCHIVED"),
        PREFILL("PREFILL"),
        AUTHORING("AUTHORING"),
        WAITING_FOR_FAXIN("WAITING_FOR_FAXIN"),
        WAITING_FOR_VERIFICATION("WAITING_FOR_VERIFICATION"),
        WIDGET_WAITING_FOR_VERIFICATION("WIDGET_WAITING_FOR_VERIFICATION"),
        WAITING_FOR_PAYMENT("WAITING_FOR_PAYMENT"),
        OUT_FOR_APPROVAL("OUT_FOR_APPROVAL"),
        OTHER("OTHER");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SecurityOptionsEnum {
        OPEN_PROTECTED("OPEN_PROTECTED"),
        OTHER("OTHER");

        private String value;

        private SecurityOptionsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

