/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.api;

import com.adobe.sign.model.reminders.ReminderCreationInfo;
import com.adobe.sign.model.reminders.ReminderCreationResult;
import com.adobe.sign.utils.ApiClient;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.Context;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.TypeRef;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.RemindersApiValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class RemindersApi {
    private ApiClient apiClient = Context.getDefaultApiClient();
    private final String CONTENT_TYPE = "Content-Type";
    private final String ACCEPT = "Accept";
    private final String ACCESS_TOKEN = "Access-Token";
    private final String X_API_USER = "x-api-user";

    public ReminderCreationResult createReminder(MultivaluedMap headers, ReminderCreationInfo reminderCreationInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        RemindersApiValidator.createReminderValidator(reminderCreationInfo);
        String path = "/reminders".replaceAll("\\{format\\}", "json");
        ReminderCreationInfo postBody = reminderCreationInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<ReminderCreationResult> returnType = new TypeRef<ReminderCreationResult>(){};
        return (ReminderCreationResult)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }
}

