/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.api;

import com.adobe.sign.model.oAuth.AccessTokenRefreshRequest;
import com.adobe.sign.model.oAuth.AccessTokenRefreshResponse;
import com.adobe.sign.model.oAuth.AccessTokenRequest;
import com.adobe.sign.model.oAuth.AccessTokenResponse;
import com.adobe.sign.model.oAuth.AuthorizationRequest;
import com.adobe.sign.model.oAuth.Token;
import com.adobe.sign.utils.ApiClient;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.Context;
import com.adobe.sign.utils.OAuthUtils;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.TypeRef;
import com.adobe.sign.utils.validator.OAuthApiValidator;
import java.util.ArrayList;
import java.util.HashMap;

public class OAuthApi {
    private ApiClient apiClient = Context.getDefaultApiClient();

    public String getAuthorizationUrl(AuthorizationRequest authorizationRequest) throws ApiException {
        String baseUri = this.apiClient.getEnvHostName().replace("api", "secure");
        String subPath = "public/oauth";
        OAuthApiValidator.getAuthorizationUrlValidator(authorizationRequest);
        String baseUrl = baseUri + subPath;
        return OAuthUtils.appendTo(baseUrl, authorizationRequest.getClientId(), authorizationRequest.getRedirectUri(), OAuthUtils.spaceDelimitedSet(authorizationRequest.getScopes()), authorizationRequest.getState(), authorizationRequest.getResponseType());
    }

    public AccessTokenResponse getAccessToken(AccessTokenRequest accessTokenRequest) throws ApiException {
        OAuthApiValidator.getAccessTokenValidator(accessTokenRequest);
        String path = "oauth/token";
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        contentTypesList.add("application/x-www-form-urlencoded");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("code", accessTokenRequest.getCode());
        formParams.put("client_id", accessTokenRequest.getClientId());
        formParams.put("client_secret", accessTokenRequest.getClientSecret());
        formParams.put("redirect_uri", accessTokenRequest.getRedirectUri());
        formParams.put("grant_type", accessTokenRequest.getGrantType());
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AccessTokenResponse> returnType = new TypeRef<AccessTokenResponse>(){};
        return (AccessTokenResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, false);
    }

    public AccessTokenRefreshResponse refreshAccessToken(AccessTokenRefreshRequest accessTokenRefreshRequest) throws ApiException {
        OAuthApiValidator.refreshAccessTokenValidator(accessTokenRefreshRequest);
        String path = "oauth/refresh";
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        contentTypesList.add("application/x-www-form-urlencoded");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("refresh_token", accessTokenRefreshRequest.getRefreshToken());
        formParams.put("client_id", accessTokenRefreshRequest.getClientId());
        formParams.put("client_secret", accessTokenRefreshRequest.getClientSecret());
        formParams.put("grant_type", accessTokenRefreshRequest.getGrantType());
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AccessTokenRefreshResponse> returnType = new TypeRef<AccessTokenRefreshResponse>(){};
        return (AccessTokenRefreshResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, false);
    }

    public void revokeToken(Token token) throws ApiException {
        OAuthApiValidator.revokeTokenValidator(token);
        String path = "oauth/revoke";
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        contentTypesList.add("application/x-www-form-urlencoded");
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        formParams.put("token", token.getToken());
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef returnType = null;
        this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, false);
    }
}

