/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.api;

import com.adobe.sign.model.libraryDocuments.DocumentLibraryItems;
import com.adobe.sign.model.libraryDocuments.Documents;
import com.adobe.sign.model.libraryDocuments.LibraryCreationInfo;
import com.adobe.sign.model.libraryDocuments.LibraryDocumentCreationResponse;
import com.adobe.sign.model.libraryDocuments.LibraryDocumentInfo;
import com.adobe.sign.utils.ApiClient;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.Context;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.TypeRef;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.LibraryDocumentsApiValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class LibraryDocumentsApi {
    private ApiClient apiClient = Context.getDefaultApiClient();
    private final String CONTENT_TYPE = "Content-Type";
    private final String ACCEPT = "Accept";
    private final String ACCESS_TOKEN = "Access-Token";
    private final String X_API_USER = "x-api-user";

    public DocumentLibraryItems getLibraryDocuments(MultivaluedMap headers) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.getLibraryDocumentsValidator();
        String path = "/libraryDocuments".replaceAll("\\{format\\}", "json");
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<DocumentLibraryItems> returnType = new TypeRef<DocumentLibraryItems>(){};
        return (DocumentLibraryItems)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public LibraryDocumentCreationResponse createLibraryDocument(MultivaluedMap headers, LibraryCreationInfo libraryCreationInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.createLibraryDocumentValidator(libraryCreationInfo);
        String path = "/libraryDocuments".replaceAll("\\{format\\}", "json");
        LibraryCreationInfo postBody = libraryCreationInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<LibraryDocumentCreationResponse> returnType = new TypeRef<LibraryDocumentCreationResponse>(){};
        return (LibraryDocumentCreationResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public LibraryDocumentInfo getLibraryDocumentInfo(MultivaluedMap headers, String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.getLibraryDocumentInfoValidator(libraryDocumentId);
        String path = "/libraryDocuments/{libraryDocumentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{libraryDocumentId\\}", this.apiClient.escapeString(libraryDocumentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<LibraryDocumentInfo> returnType = new TypeRef<LibraryDocumentInfo>(){};
        return (LibraryDocumentInfo)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public void deleteLibraryDocument(MultivaluedMap headers, String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.deleteLibraryDocumentValidator(libraryDocumentId);
        String path = "/libraryDocuments/{libraryDocumentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{libraryDocumentId\\}", this.apiClient.escapeString(libraryDocumentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, null, true);
    }

    public byte[] getLibraryDocumentAuditTrail(MultivaluedMap headers, String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.getLibraryDocumentAuditTrailValidator(libraryDocumentId);
        String path = "/libraryDocuments/{libraryDocumentId}/auditTrail".replaceAll("\\{format\\}", "json").replaceAll("\\{libraryDocumentId\\}", this.apiClient.escapeString(libraryDocumentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/pdf");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }

    public byte[] getCombinedDocument(MultivaluedMap headers, String libraryDocumentId, Boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.getCombinedDocumentValidator(libraryDocumentId, auditReport);
        String path = "/libraryDocuments/{libraryDocumentId}/combinedDocument".replaceAll("\\{format\\}", "json").replaceAll("\\{libraryDocumentId\\}", this.apiClient.escapeString(libraryDocumentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/pdf");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "auditReport", auditReport));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }

    public Documents getDocuments(MultivaluedMap headers, String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.getDocumentsValidator(libraryDocumentId);
        String path = "/libraryDocuments/{libraryDocumentId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{libraryDocumentId\\}", this.apiClient.escapeString(libraryDocumentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<Documents> returnType = new TypeRef<Documents>(){};
        return (Documents)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public byte[] getLibraryDocument(MultivaluedMap headers, String libraryDocumentId, String documentId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        LibraryDocumentsApiValidator.getLibraryDocumentValidator(libraryDocumentId, documentId);
        String path = "/libraryDocuments/{libraryDocumentId}/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{libraryDocumentId\\}", this.apiClient.escapeString(libraryDocumentId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add(" */* ");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }
}

