/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.api;

import com.adobe.sign.model.groups.GroupCreationInfo;
import com.adobe.sign.model.groups.GroupCreationResponse;
import com.adobe.sign.model.groups.GroupDetailsInfo;
import com.adobe.sign.model.groups.GroupModificationInfo;
import com.adobe.sign.model.groups.GroupModificationResponse;
import com.adobe.sign.model.groups.GroupsInfo;
import com.adobe.sign.model.groups.UsersInfo;
import com.adobe.sign.utils.ApiClient;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.Context;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.TypeRef;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.GroupsApiValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class GroupsApi {
    private ApiClient apiClient = Context.getDefaultApiClient();
    private final String CONTENT_TYPE = "Content-Type";
    private final String ACCEPT = "Accept";
    private final String ACCESS_TOKEN = "Access-Token";
    private final String X_API_USER = "x-api-user";

    public GroupsInfo getGroups(MultivaluedMap headers) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        GroupsApiValidator.getGroupsValidator();
        String path = "/groups".replaceAll("\\{format\\}", "json");
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<GroupsInfo> returnType = new TypeRef<GroupsInfo>(){};
        return (GroupsInfo)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public GroupCreationResponse createGroup(MultivaluedMap headers, GroupCreationInfo groupCreationInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        GroupsApiValidator.createGroupValidator(groupCreationInfo);
        String path = "/groups".replaceAll("\\{format\\}", "json");
        GroupCreationInfo postBody = groupCreationInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<GroupCreationResponse> returnType = new TypeRef<GroupCreationResponse>(){};
        return (GroupCreationResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public GroupDetailsInfo getGroupDetails(MultivaluedMap headers, String groupId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        GroupsApiValidator.getGroupDetailsValidator(groupId);
        String path = "/groups/{groupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<GroupDetailsInfo> returnType = new TypeRef<GroupDetailsInfo>(){};
        return (GroupDetailsInfo)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public GroupModificationResponse modifyGroup(MultivaluedMap headers, String groupId, GroupModificationInfo groupModificationInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        GroupsApiValidator.modifyGroupValidator(groupId, groupModificationInfo);
        String path = "/groups/{groupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        GroupModificationInfo postBody = groupModificationInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<GroupModificationResponse> returnType = new TypeRef<GroupModificationResponse>(){};
        return (GroupModificationResponse)this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public void deleteGroup(MultivaluedMap headers, String groupId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        GroupsApiValidator.deleteGroupValidator(groupId);
        String path = "/groups/{groupId}".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, null, true);
    }

    public UsersInfo getUsersInGroup(MultivaluedMap headers, String groupId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        GroupsApiValidator.getUsersInGroupValidator(groupId);
        String path = "/groups/{groupId}/users".replaceAll("\\{format\\}", "json").replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<UsersInfo> returnType = new TypeRef<UsersInfo>(){};
        return (UsersInfo)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }
}

